/*
* Copyright (c) 1992 Carnegie Mellon University 
*                    SCAL project: Guy Blelloch, Siddhartha Chatterjee,
*                                  Jonathan Hardwick, Jay Sipelstein,
*                                  Marco Zagha
* All Rights Reserved.
*
* Permission to use, copy, modify and distribute this software and its
* documentation is hereby granted, provided that both the copyright
* notice and this permission notice appear in all copies of the
* software, derivative works or modified versions, and any portions
* thereof, and that both notices appear in supporting documentation.
*
* CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
* CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND FOR
* ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
*
* The SCAL project requests users of this software to return to 
*
*  Guy Blelloch				guy.blelloch@cs.cmu.edu
*  School of Computer Science
*  Carnegie Mellon University
*  5000 Forbes Ave.
*  Pittsburgh PA 15213-3890
*
* any improvements or extensions that they make and grant Carnegie Mellon
* the rights to redistribute these changes.
*/

/* These functions access the internal tokenized format of a VCODE program. */

#include <stdio.h>

#include "vcode.h"
#include "y.tab.h"
#include "symbol_table.h"
#include "vstack.h"
#include "program.h"
#include "constant.h"

/* print out a TYPE */
char *type_string(type)
TYPE type;
{
    switch (type) {
	case Int:       return("Int");
	case Bool:      return("Bool");
	case Float:     return("Float");
	case None: 	return("None");
	case Segdes: 	return("Segdes");
	case String:	return("String");
	case Illegal:	return("Illegal");
	default:        fprintf(stderr, "bad type: %d", type);
			return(NULL);
    }
}

/* print out a constant value */
static void show_const(prog_entry)
prog_entry_t *prog_entry;
{
    if (prog_entry->type == Float)
	fprintf(stderr, "type = Float; val = %f", prog_entry->misc.float_const);
    else if (prog_entry->type == Bool)
	fprintf(stderr, "type = Bool; val = %s", 
			prog_entry->misc.bool_const ? "T" : "F");
    else if (prog_entry->type == Int || prog_entry->type == Segdes)
	fprintf(stderr, "type = Int; val = %d", prog_entry->misc.int_const);
    else fprintf(stderr, "illegal CONSTANT type");
    return;
}

/* print out a prog_entry structure in a meaningful way */
void show_prog_entry(prog_entry, line)
prog_entry_t *prog_entry;
int line;
{
    fprintf(stderr, "(%d) vop = %s; ", line,
		  prog_entry->vopdes->vopname);
    if (prog_entry->vop <= LENGTHS)
	fprintf(stderr, "type = %s", type_string(prog_entry->type));
    else {
	switch (prog_entry->vop) {
	    case CONST: 
		if (!prog_entry->is_in_const_pool)
		    show_const(prog_entry);
		else {
		    const_show_vec(prog_entry->misc.const_pool_index);
		}
		break;
	    case POP:
	    case COPY:
		fprintf(stderr, "args = %d, %d",
				prog_entry->misc.stack_args.arg1,
				prog_entry->misc.stack_args.arg2);
		break;
	    case IF:
	    case ELSE:
	    case CALL:
		fprintf(stderr, "branch to %d", prog_entry->misc.branch);
		break;
	    default:
		break;
	}
    }
    fprintf(stderr, "; line = %d\n", prog_entry->lineno);
}


/* show_prog: print out a prettied version of the program. */
void show_program()
{
    int i;
    for (i = 0; i < next_prog_num; i++) {
	show_prog_entry(program + i, i);
    }
}
