(in-package 'nesl-lisp)

(defun join-bindings (a b vars)
  (if (or (eql a :error) (eql b :error))
      :error
    (if vars
	(let ((tail (join-bindings a b (cdr vars)))
	      (va (assoc (car vars) a))
	      (vb (assoc (car vars) b)))
	  (if va
	      (if (and vb (not (equal (cdr va) (cdr vb))))
		  :error
		(cons va tail))
	    (if vb 
		(cons vb tail)
	      tail))))))

(defun match-val (a b vars)
  (if (atom b)
      (if (member b vars)
	  (list (cons b a))
	(if (eql a b) 
	    nil
	  :error))
    (if (atom a)
	:error
      (match-list a b vars))))

;;; This takes a general list a and unifies it with the specific
;;; list a, where vars are all the quantified variables in b.
;;; For example:  
;;; (match-list '(dog (cat mouse) cat) 
;;;             '(alpha (beta mouse) beta) 
;;;             '(alpha beta))
;;;  => ((ALPHA . DOG) (BETA . CAT)) 
;;;
(defun match-list (a b vars)
  (if a
      (if b
	  (join-bindings (match-val (car a) (car b) vars)
			 (match-list (cdr a) (cdr b) vars)
			 vars)
	:error)
    nil))

(defun typecheck (funname funtype argtypes)
  (let ((result (match-list argtypes 
			    (cdr (car funtype)) 
			    (if (atom (cadr funtype))
				(list (cadr funtype))
			      (mapcar 'first (cdr funtype))))))
    (if (eql result :error)
	(nesl-error "For function ~a, argument types don't match ~
                function specification.~%  ~
                Argument types: ~a~%  ~
                Function spec:  ~a~%"
		    funname 
		    (funcall *type-map* argtypes)
		    (funcall *type-map* (cdar funtype)))
      result)))

#|
(assert (equal (match-list '(int (bool (int float)) (int float) bool)
			   '(int (bool alpha) alpha beta) 
			   '(alpha beta))
	       '((alpha int float) (beta . bool))))
|#


