(in-package 'nesl)

;; This prints the string STR and then prints a .....FAILED
;; message if and only if V is false.
;; It only uses the most primitive output commands PRINT-STRING and 
;; PRINT-CHAR, which both only call the WRITE CHAR instruction in VCODE.
(defop (test str v) (int <- v.char bool)
  (with ((t1 (print-string str))
 	 (t2 (if v t (print-string "........FAILED")))
	 (t3 (print-char #\newline)))
    0))

;;; This is not a real test for rand, but it at least tests
;;; whether the result is within the expected range
(defop (test-rand-range a) (bool <- int)
  (with ((val1 (rand 100))
	 (val2 (rand 200)))
     (and (and (> val1 0) (< val1 100))
	  (and (> val2 0) (< val2 200)))))

(defop (almost= a b) (bool <- float float)
  (< (- a b) .001))

(defop (test-eql a) (bool <- int)
  (and (eql #v(1 2 3) #v(1 2 3))
       (not (eql #v(0 2 3) #v(1 2 3)))))

(defop (test-and-reduce a) (bool <- int)
  (and (and-reduce #v(t t t t))
       (and (not (and-reduce #v(t t f t)))
	    (and-reduce #v.bool()))))
		 
(defop (test-or-reduce a) (bool <- int)
  (and (or-reduce #v(f f t f))
       (and (not (or-reduce #v(f f f f)))
	    (not (or-reduce #v.bool())))))

(defop (test-+-reduce a) (bool <- int)
  (and (= 8 (+-reduce #v(2 3 3)))
       (= 0 (+-reduce #v.int()))))

(defop (test-+-scan a) (bool <- int)
  (eql #v(0 2 5) (+-scan #v(2 3 3))))

(defop (test-max-scan a) (bool <- int)
  (with ((vect #v(-5 8 1)))
    (eql #v(-5 8 8) (v.max vect (max-scan vect)))))

(defop (test-or-scan a) (bool <- int)
  (with ((vect #v(f f f t f f f)))
    (eql #v(f f f f t t t) (or-scan vect))))

(defop (test-permute a) (bool <- int)
  (and (eql "wombat" (permute "mowtab" #v(2 1 0 5 4 3)))
       (eql "" (permute "" #v.int()))))

(defop (test-permute-bool a) (bool <- int)
  (and (eql #v(t t f t f t) (permute #v(f f t t t t) #v(2 4 0 1 3 5)))
       (eql #v.bool() (permute #v.bool() #v.int()))))

(defop (test-put a) (bool <- int)
  (and (eql "womtbat it" (put "mowtab" #v(2 1 0 6 5 4) "testing it"))
       (eql "testing it" (put "" #v.int() "testing it"))))

(defop (test-put-bool a) (bool <- int)
  (and (eql #v(t f f t f t) (put #v(f t t f) #v(4 0 5 1) #v(f f f t f f)))
       (eql #v(t t t t t t) (put #v.bool() #v.int() #v(t t t t t t)))))

(defop (test-cond-put a) (bool <- int)
  (eql "womting it" (cond-put "mowtab" #v(2 1 0 6 5 4) #v(t t t f f f)
		     "testing it")))

(defop (test-cond-put-bool a) (bool <- int)
  (eql #v(t t t f t f f f) (cond-put #v(f t t t) #v(5 2 2 4) #v(t t f f)
		     #v(t t f f t f f f))))

(defop (test-get a) (bool <- int)
  (and (eql "tie" (get "testing it" #v(3 4 1)))
       (eql "" (get "testing it" #v.int()))))

(defop (test-pack a) (bool <- int)
  (eql "te rs" (pack "the horse" #v(t f t t f f t t f))))

(defop (test-pack-bool a) (bool <- int)
  (eql #v(t t f t f) 
      (pack #v(t f t f t t t f f) #v(t f t t f f t t f))))

(sdefop (testshort) (int <-)
  (with ((len 2)
	 (seglen #v(2 2))
	 (te (test "int =" (= 2 2)))
	 (te (test "int !=" (/= 3 2)))
	 (te (test "int >" (> -2 -3)))
	 (te (test "int <" (< -3 -2)))
	 (te (test "int +" (= (+ 4 5) 9)))
	 (te (test "int -" (= (- 4 5) -1)))
	 (te (test "int *" (= (* 7 8) 56)))
	 (te (test "int /" (= (/ 7 2) 3)))
	 (te (test "int remainder" (= (rem 7 2) 1)))
	 (te (test "trunc" (= (trunc 3.2) 3)))
	 (te (test "floor" (= (floor -3.2) -4)))
	 (te (test "ceil" (= (ceil -3.2) -3)))
	 (te (test "round" (= (round 4.6) 5)))
	 (te (test "sin" (and (almost= (sin 1.5708) 1.0) 
			      (almost= (sin 0.0) 0.0))))
	 (te (test "cos" (and (almost= (cos 1.5708) 0.0) 
			      (almost= (cos 0.0) 1.0))))
	 (te (test "tan" (and (almost= (tan 0.7854) 1.0) 
			      (almost= (tan 0.0) 0.0))))
	 (te (test "asin" (and (almost= 1.5708 (asin 1.0))
			       (almost= 0.0 (asin 0.0)))))
	 (te (test "acos" (and (almost= 1.5708 (acos 0.0))
			       (almost= 0.0 (acos 1.0)))))
	 (te (test "atan" (and (almost= 0.7854 (atan 1.0))
			       (almost= 0.0 (atan 0.0)))))
	 (te (test "int select" (= (select t 2 3) 2)))
	 (te (test "bool not" (not f)))
	 (te (test "bool or" (or t f)))
	 (te (test "bool and" (and t t)))
	 (te (test "int not" (= -1 (not 0))))
	 (te (test "int or"  (= 3 (or 1 2))))
	 (te (test "int and" (= 2 (and 3 6))))
	 (te (test "lshift" (and (= -2 (lshift -1 1)) (= 4 (lshift 1 2)))))
	 (te (test "rshift" (and (= 0 (rshift 1 1)) (= 1 (rshift 4 2)))))
	 (te (test "sqrt" (= 6.0 (sqrt 36.0))))
	 (te (test "isqrt" (= 6 (isqrt 36))))
	 (te (test "rand (within range)" (test-rand-range len)))
	 (te (test "btoi" (= 1 (btoi t))))
	 (te (test "float" (= 1.0 (float 1))))
	 (te (test "bool and-reduce" (test-and-reduce len)))
	 (te (test "bool or-reduce" (test-or-reduce len)))
	 (te (test "int +-reduce" (test-+-reduce len)))
	 (te (test "eql" (test-eql len)))
	 (te (test "int dist" (eql (dist 1 2) #v(1 1))))
	 (te (test "int +-scan" (test-+-scan len)))
	 (te (test "int max-scan" (test-max-scan len)))
	 (te (test "bool or-scan" (test-or-scan len)))
	 (te (test "int permute" (test-permute len)))
	 (te (test "bool permute" (test-permute-bool len)))
	 (te (test "int put" (test-put len)))
         (te (test "bool put" (test-put-bool len)))
	 (te (test "int cond-put" (test-cond-put len)))
	 (te (test "bool cond-put" (test-cond-put-bool len)))
	 (te (test "int get" (test-get len)))
	 (te (test "int pack" (test-pack len)))
	 (te (test "bool pack" (test-pack-bool len)))
	 (te (test "seg int dist" 
		   (eql #v("a" "ff") (v.dist "af" #v(1 2)))))
	 (te (test "seg int dist (zero len)" 
		   (eql #v("a" "" "ff") (v.dist "ahf" #v(1 0 2)))))
	 (te (test "seg int +-reduce" 
		   (eql #v(8 2) (v.+-reduce #v(#v(2 3 3) #v(2))))))
	 (te (test "seg int +-reduce (zero len)" 
		   (eql #v(8 0 2) (v.+-reduce #v(#v(2 3 3) #v.int() #v(2))))))
	 (te (test "elt seg" 
		   (eql "foo" (elt #v("wombat" "foo" "horse") 1))))
	 (te (test "elt seg (zero len)" 
		   (eql "" (elt #v("wombat" "" "horse") 1))))
	 (te (test "dist seg"
		   (eql (elt (dist "foo" 4) 2) "foo")))
	 (te (test "dist seg (zero len)"
		   (eql (elt (dist "" 4) 2) "")))
	 (te (test "seg int +-scan" (and-reduce (v.test-+-scan seglen))))
	 (te (test "seg int max-scan" (and-reduce (v.test-max-scan seglen))))
	 (te (test "seg int permute" (and-reduce (v.test-permute seglen))))
	 (te (test "seg bool permute" (and-reduce (v.test-permute-bool seglen))))
	 (te (test "seg int put" (and-reduce (v.test-put seglen))))
	 (te (test "seg bool put" (and-reduce (v.test-put-bool seglen))))
	 (te (test "seg int cond-put" (and-reduce (v.test-cond-put seglen))))
	 (te (test "seg bool cond-put" (and-reduce (v.test-cond-put-bool seglen))))
	 (te (test "seg int get" (and-reduce (v.test-get seglen))))
	 (te (test "seg int pack" (and-reduce (v.test-pack seglen))))
	 (te (test "seg bool pack" (and-reduce (v.test-pack-bool seglen))))
	 )
	0))


(sdefop (test1 a) (bool <- int)
  (eql (v.get #v(#v(1) #v(4 11)) #v(#v.int() #v(1))) 
      #v(#v.int() #v(11))))

(defop (test2 a) (bool <- int)
  (eql (append "dog" "cat") "dogcat"))

(sdefop (test3 a) (bool <- int)
  (eql (v.join #v("dog" "cat")
              #v(#v(0 2 4) #v(0 1 2))
	      #v("cow" "horse") 
	      #v(#v(1 3 5) #v(3 4 5 6 7)))
      #v("dcoogw" "cathorse")))

(sdefop (test4 a) (bool <- int)
  (eql (v.append #v("dog" "cat") #v("cow" "horse"))
      #v("dogcow" "cathorse")))

(sdefop (test5 a) (bool <- int)
  (eql (flag-merge #v(f t) #v(2) #v(3))
      #v(2 3)))

(sdefop (test6 a) (bool <- int)
  (eql (flag-merge #v(f t) #v(#v(2 3)) #v(#v(4 5)))
      #v(#v(2 3) #v(4 5))))

(sdefop (testfuncs) (int <-)
  (with ((te (test "test1: (v.get)" (test1 0)))
	 (te (test "test2: (append)" (test2 0)))
	 (te (test "test3: (v.join)" (test3 0)))
	 (te (test "test4: (v.append)"  (test4 0)))
	 (te (test "test5: (flag-merge)" (test5 0)))
	 (te (test "test6: (flag-merge v.v.int)" (test6 0))))
	0))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; TESTS ON LARGE VECTORS
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defop (bigtest-dist-eql len) (bool <- int) 
  (not (eql (dist 5 len) (dist 6 len))))

(defop (bigtest-dist-reduce len) (bool <- int) 
  (= (* len 5) (+-reduce (dist 5 len))))

(defop (bigtest-index-scan len) (bool <- int) 
  (eql (index len) (+-scan (dist 1 len))))

(defop (bigtest-< len) (bool <- int) 
  (= (/ len 2) (count (v.< (index len) v.(/ len 2)))))

(defop (bigtest-permute len) (bool <- int) 
  (with ((reverse (v.- v.(- len 1) (index len))))
    (eql reverse (permute (index len) reverse))))

(defop (bigtest-get len) (bool <- int) 
  (with ((vals (index (* 2 len)))
	 (indices (v.+ v.(/ len 2) (index len))))
    (eql indices (get vals indices))))

(defop (bigtest-pack len) (bool <- int) 
  (eql (index (/ len 2))
      (pack (index len) (v.< (index len) v.(/ len 2)))))

(defop (bigtest len) (int <- int)
  (with ((te (test "bigtest dist and eql" (bigtest-dist-eql len)))
	 (te (test "bigtest dist and reduce" (bigtest-dist-reduce len)))
	 (te (test "bigtest index and scan" (bigtest-index-scan len)))
	 (te (test "bigtest <" (bigtest-< len)))
	 (te (test "bigtest permute" (bigtest-permute len)))
	 (te (test "bigtest get" (bigtest-get len)))
	 (te (test "bigtest pack" (bigtest-pack len)))
	 (seglen (append (dist (/ len 6) 1)
			 (vtup (/ len 2) (/ len 3))))
	 (te (test "segmented bigtest dist and eql" 
		   (and-reduce (v.bigtest-dist-eql seglen))))
	 (te (test "segmented bigtest dist and reduce" 
		   (and-reduce (v.bigtest-dist-reduce seglen))))
	 (te (test "segmented bigtest index and scan" 
		   (and-reduce (v.bigtest-index-scan seglen))))
	 (te (test "segmented bigtest <" 
		   (and-reduce (v.bigtest-< seglen))))
	 (te (test "segmented bigtest permute" 
		   (and-reduce (v.bigtest-permute seglen))))
	 (te (test "segmented bigtest get" 
		   (and-reduce (v.bigtest-get seglen))))
	 (te (test "segmented bigtest pack" 
		   (and-reduce (v.bigtest-pack seglen))))
	 )
    0))

(sdefop (nesl-test) (int <-)
  (with ((te (test "reverse" (eql "format" (reverse "tamrof"))))
	 (te (test "reverse nested" (eql #v("the" "big" "horse")
					 (reverse #v("horse" "big" "the")))))
	 (te (test "append" (eql "the mouse" (append "the " "mouse"))))
	 (te (test "append nested" (eql #v("the" "big" "horse")
					(append #v("the" "big") #v("horse")))))
	 (te (test "cons" (eql "format" (cons #\f "ormat"))))
	 (te (test "cons nested"  (eql #v("the" "big" "horse")
					(cons "the" #v("big" "horse")))))
	 (te (test "snoc" (eql "format" (snoc "forma" #\t))))
	 (te (test "snoc nested" (eql #v("the" "big" "horse")
					(snoc #v("the" "big") "horse"))))
	 (te (test "vtup" (eql "ab" (vtup #\a #\b))))
	 (te (test "vtup nested" (eql #v("the" "horse")
				      (vtup "the" "horse"))))
	 (te (test "vsep" (eql (tup #\a #\b) (vsep "ab"))))
	 (te (test "vsep nested" (eql (tup "the" "horse")
				      (vsep #v("the" "horse")))))
	 (te (test "subseq" (eql "omba" (subseq "wombat" 1 5))))
	 (te (test "subseq nested" (eql #v("big" "brown")
					(subseq #v("the" "big" "brown" "horse")
						1 3))))
	 (te (test "drop" (eql "mbat" (drop 2 "wombat"))))
	 (te (test "drop nested" (eql #v("brown" "horse") 
				      (drop 2 
					    #v("the" "big" "brown" "horse")))))
	 (te (test "take" (eql "womb" (take 4 "wombat"))))
	 (te (test "take nested" (eql #v("the" "big")
				      (take 2 
					    #v("the" "big" "brown" "horse")))))
	 (te (test "flatten" (eql "thebighorse" 
				  (flatten #v("the" "big" "horse")))))
	 (te (test "partition" (eql #v("the" "big" "horse")
				    (partition "thebighorse" #v(3 3 5)))))
	 (te (test "split" (eql #v("hebghe" "tiors") 
				    (split "thebighorse" 
					   (v.> "thebighorse" v. #\h)))))
	 (te (test "bottop" (eql #v("thebig" "horse")
				    (bottop "thebighorse"))))
	 (te (test "rotate" (eql "horsethebig" (rotate "thebighorse" 5)))))
    0))

(sdefop (io-test) (int <-)
  (with ((te (test "string int" (and (eql "234" (string 234))
				     (and (eql "-234" (string -234))
					  (eql "0" (string 0))))))
	 (te (test "string char" (eql "#\\a" (string #\a))))
	 (te (test "string bool" (and (eql "t" (string t))
				      (eql "f" (string f)))))
	 (te (test "string string" (eql "\"test\"" (string "test"))))
	 (te (test "string vector" (eql "#v(2 3 4)" (string #v(2 3 4)))))
	 (te (test "string tup" (eql "(TUP 2 5)" (string (tup 2 5))))))
    0))

(sdefop (test-nested-over n) (bool <- int)
  (eql #v(#v(#v(2 3) #v(2 3)) #v(#v(4 5) #v(4 5)))
       (over ((v #v(#v(2 3) #v(4 5))))
	 (over ((a v)) v))))

(sdefop (other-test) (int <-)
  (with ((te (test "nested over" (test-nested-over 0))))
    0))

(sdefop (testall) (int <-)
  (with ((te (test "Checking the Fail Mechanism, FAILED message should appear"
		   f))
	 (te (print-char #\newline))
	 (te (test "TEST OF ALL FUNCTIONS ON SHORT VECTORS" t))
	 (te (testshort))
	 (te (print-char #\newline))
	 (te (test "SOME OTHER TESTS ON SHORT VECTORS" t))
	 (te (testfuncs))
	 (te (print-char #\newline))
	 (te (test "TEST OF SOME FUNCTIONS ON LONG VECTORS" t))
	 (te (bigtest 50000))
	 (te (print-char #\newline))
	 (te (test "NESL VECTOR FUNCTIONS" t))
	 (te (nesl-test))
	 (te (print-char #\newline))
	 (te (test "STRING TESTS" t))
	 (te (io-test))
	 (te (print-char #\newline))
	 (te (test "OTHER TESTS" t))
	 (te (other-test)))
	0))
