(in-package 'nesl-lisp)

(defparameter *header*
"
% This file generated automatically from the function specifications.
\\section{List of Functions}
\\seclabel{functions}

\\newcommand{\\tdefop}[4]{
  \\vspace{.15in} \\noindent 
  {\\tt #1} \\hfill {\\em \\{#2 $\\leftarrow$ #3 $:$ #4\\} }\\\\[.05in] }
\\newcommand{\\ldefop}[3]{
  \\vspace{.15in} \\noindent 
  {\\tt #1} \\hfill {\\em \\{#2 $\\leftarrow$ #3\\} }\\\\[.05in] }
\\newcommand{\\fun}[1]{{\\tt #1}}
\\newcommand{\\farg}[1]{{\\tt #1}}

This section lists the functions available in \\lone.
Each function is listed in the following way:

\\vspace{.05in}
\\tdefop{(function-name arguments)}{result-type}{source-types}{type-bindings}
Definition of function.
\\vspace{.2in}

\\noindent In the type specifications, the following assignments are
valid:
{\\tt
\\begin{tabbing}
~~~~ordinal = int, char, float\\\\
~~~~number~~= int, float\\\\
~~~~logical = bool, int\\\\
~~~~any~~~~~= {\\em any valid type}
\\end{tabbing}
}
")

(defparameter *tlist* 
  '((nesl::a0 "$a_0$") (nesl::a1 "$a_1$") (nesl::a2 "$a_2$") (nesl::a3 "$a_3$")
    (nesl::a4 "$a_4$") (nesl::a5 "$a_5$") (nesl::a6 "$a_6$") (nesl::a7 "$a_7$")
    (nesl::b0 "$b_0$") (nesl::b1 "$b_1$") (nesl::b2 "$b_2$") (nesl::b3 "$b_3$")
    (nesl::b4 "$b_4$") (nesl::b5 "$b_5$") (nesl::b6 "$b_6$") (nesl::b7 "$b_7$")
    (nesl::inf "$\\infty$") (nesl::minf "$-\\infty$")
    (nesl::t "\\btrue t") (nesl::f "\\bfalse")))

(defparameter alpha "$alpha$")

(defun gen-latex-element (element stream)
  (cond ((atom element) 
	 (format stream "~a" 	  
		 (if (constantp element) element
		   (second (assoc element *tlist*)))))
	((listp element)
	 (format stream "\\#v(")
	 (gen-latex-element (car element) stream)
	 (dolist (element (cdr element))
	   (format stream " ")
	   (gen-latex-element element stream))
	 (format stream ")"))))
      
(defun gen-latex-vector (name elements stream)
  (format stream "  \\farg{~(~a~)} & = & " name)
  (gen-latex-element elements stream)
  (format stream "\\\\~%"))

(defun gen-latex-example (args example stream)
  (format stream "{\\tt \\tabcolsep 4pt \\defexample{lcl}{~%")
  (do ((arg-values (cddr example) (cdr arg-values))
       (arg-names (cdr args) (cdr arg-names)))
      ((null arg-names))
      (gen-latex-vector (first arg-names) (first arg-values) stream))
  (format stream "  [.07in]~%")
  (gen-latex-vector args (first example) stream)
  (format stream "}}~%"))

(defun gen-latex-type (name types stream)
  (let* ((type (subst alpha 'nesl::alpha types))
	(typeval (first type))
	(desttype (first typeval))
	(sourcetypes (cddr typeval))
	(typebind (second type)))
    (if typebind 
	(format stream "~(\\tdefop{~a}{~a}{~a~{ ~a~}}{~{ ~a~}}~)~%"
		name desttype (car sourcetypes) (cdr sourcetypes)
		(list (first typebind) "{\\rm in}" (second typebind)))
      (format stream "~(\\ldefop{~a}{~a}{~a~{ ~a~}}~)~%"
		name desttype (car sourcetypes) (cdr sourcetypes)))))	      
  
(defun gen-latex-description (function stream)
  (if (not (eql (first function) 'opdef))
      (format stream "\\~a{~a}~%~%~a~%~%" 
	      (first function) (second function) (third function))
    (let ((args (second function))
	  (types (third function))
	  (documentation (fourth function))
	  (example (fifth function)))
      (gen-latex-type args types stream)
      (when documentation
	    (format stream "~a~%" documentation))
      (when example
	    (format stream "For example:~%~%")
	    (gen-latex-example args example stream))
      (format stream "~%"))))

(defun write-all (file)
  (with-open-file (ofile file 
			 :direction :output
			 :if-exists :supersede)
    (format ofile "~a~%" *header*)
    (dolist (op (reverse *oplist*))
       (when (first op)
	 (gen-latex-description op ofile)))))

