;;;
;;; Copyright (c) 1992 Carnegie Mellon University 
;;;                    SCAL project: Guy Blelloch, Siddhartha Chatterjee,
;;;                                  Jonathan Hardwick, Jay Sipelstein,
;;;                                  Marco Zagha
;;; All Rights Reserved.
;;;
;;; Permission to use, copy, modify and distribute this software and its
;;; documentation is hereby granted, provided that both the copyright
;;; notice and this permission notice appear in all copies of the
;;; software, derivative works or modified versions, and any portions
;;; thereof, and that both notices appear in supporting documentation.
;;;
;;; CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
;;; CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND FOR
;;; ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
;;;
;;; The SCAL project requests users of this software to return to 
;;;
;;;  Guy Blelloch				guy.blelloch@cs.cmu.edu
;;;  School of Computer Science
;;;  Carnegie Mellon University
;;;  5000 Forbes Ave.
;;;  Pittsburgh PA 15213-3890
;;;
;;; any improvements or extensions that they make and grant Carnegie Mellon
;;; the rights to redistribute these changes.
;;;

(in-package 'nesl-lisp)

;; All information about operations and types are stored in
;; a definitions table.
;; The definitions table should only be accessed through the
;; functions supplied in this file.  The internal representation
;; should not be used.

(defun make-definitions-table ()
  (list 0 (make-hash-table :test #'equal) (make-hash-table) 0))

(defun make-name (name number)
  (intern (format nil "~A_~d" name number)))

;; The following six functions are for inserting and
;; accessing op definitions.

(defun add-op-def (name type code definitions)
  (setf (gethash (cons name (cdr type)) (second definitions))
	(cons (make-name name (incf (car definitions))) (cons type code))))

(defun add-primitive-op (name type prim-name definitions)
  (setf (gethash (cons name (cdr type)) (second definitions))
	(cons prim-name (cons type nil))))

(defun get-return-type (name source-type definitions)
  (caadr (gethash (cons name source-type) (second definitions))))

(defun get-full-name (name source-type definitions)
  (car (gethash (cons name source-type) (second definitions))))

(defun get-code (name source-type definitions)
  (cddr (gethash (cons name source-type) (second definitions))))

(defun primitivep (name source-type definitions)
  (not (get-code name source-type definitions)))

(defun types-of-name (name definitions)
  (let ((result nil))
    (maphash
     #'(lambda (key value)
	 (when (eql (first key) name)
	       (push (cons (caadr value) (cons '<- (cdr key))) result)))
     (second definitions))
    result))

;; The following four functions are for inserting and
;; accessing types.

(defun add-type-def (name length fields definitions)
  (setf (gethash name (third definitions))
	(cons length fields)))

(defun add-primitive-type (name definitions)
  (setf (gethash name (third definitions))
	(cons 1 name)))

(defun get-type-length (name definitions)
  (car (gethash name (third definitions))))

(defun get-type-fields (name definitions)
  (cdr (gethash name (third definitions))))

(defun get-type (name definitions)
  (mapcar #'second (cdr (gethash name (third definitions)))))

;; The following function is used for getting unique labels

(defun get-label (definitions)
  (intern (format nil "L~d" (incf (fourth definitions)))))
