(in-package :nesl-lisp) 

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; If you are NOT going to be using remote access, then this file can     ;;
;; probably be left alone.  If you are going to use remote access, then   ;;
;; you will need to set up the variables and configurations appropriately.;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; The remote shell command.  The name of this command, if it exists, 
;; is machine dependent.  Only used when running NESL on a remote machine.
(defparameter *RSH-COMMAND* "/usr/bin/rsh")

(defparameter *RSH-MACHINE-FIRST* nil)

;; Only used when running NESL on a remote machine without AFS.
;; It is the username and machine name from which the remote process
;; tries to read and write all the files via the unix "rcp" command.
;; It must be in the format "username@machinename" and the remote 
;; machine must be on the .rhosts list of the local machine.
(defparameter *VCODE-SOURCE-MACHINE* "foo@bar")

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; DEFINITION OF THE MACHINE CONFIGURATIONS. ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; This definition is the default
(defparameter nesl::*local* 
  (make-config :memsize 500000
	       :interp-file "vinterp"
	       :machine-name "local"))

;; An example of a connection Machine configuration
(defparameter nesl::*cm* 
  (make-config :memsize 16384
	       :interp-file "cm-vinterp"
	       :munch-lines 1
	       :user-name "foobar"
	       :machine-name "cmsuna.psc.edu"))

;; An example of a Cray configuration using AFS
(defparameter nesl::*cray* 
  (make-config :memsize 500000
	       :user-name "foobar"
	       :interp-file "cray-vinterp"
	       :afs t
	       :machine-name "pscymp.psc.edu"))

;; An example of a Cray configuration without AFS
(defparameter nesl::*cray-noafs* 
  (make-config :memsize 500000
	       :user-name "foobar"
	       :interp-file "cray-vinterp"
	       :afs nil
	       :machine-name "pscymp.psc.edu"))
