(in-package 'nesl-lisp)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;; THE FOLLOWING VARIABLE NEEDS TO BE         ;;;;
;;;; CHANGED DEPENDING ON YOUR SYSTEM.          ;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; The directory in which this file is located.
(defparameter *NESL-PATH* 
  "/usr/foo/nesl/")

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;; THE FOLLOWING TWO VARIABLE MIGHT NEED TO   ;;;;
;;;; BE CHANGED.                                ;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; Name of the directory of the vcode interpreter.
;; By default this is the vcode/bin/ subdirectory of NESL-PATH.
(defparameter *VCODE-INTERPRETER-DIR*
  (concatenate 'string *NESL-PATH* "vcode/vinterp/"))

;; Directory where the vcode files are written to.
;; It must be both readable and writable by all users of NESL.
(defparameter *VCODE-TEMP-DIRECTORY* 
  "/tmp/")

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;; THE REST OF THIS FILE SHOULD BE LEFT AS IS. ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defparameter *nesl-version* nil)

(defparameter *nesl-date* nil)

(with-open-file (releasefile (concatenate 'string *NESL-PATH* "src/releasenum")
			     :direction :input)
  (setq *nesl-version* (read-line releasefile))
  (setq *nesl-date* (read-line releasefile)))

(format t "~%; Loading NESL version ~a, ~a~%~%"
	*nesl-version* *nesl-date*)

(let ((*default-pathname-defaults* (pathname *NESL-PATH*))
      #+(or allegro excl)
      (obj-tailer ".fasl")
      #+lucid
      (obj-tailer ".sbin"))
  (load "make")
  (flet ((load-file (name)
		    (load (concatenate 'string "bin/" name obj-tailer))))
	(load-file "definitions")
	(load-file "free")
	(load-file "trans")
	(load-file "ptrans")
	(load-file "type-check")
	(load-file "output")
	(load-file "dispatch")
	(load-file "run-vcode")
	(load-file "config")
	(load-file "vcode-lisp")
	(load "src/scalar-ops.lisp")
	(load "src/vector-ops.lisp")
	(load "src/nest-ops.lisp")
	(load "src/io.lisp")

	(format t "~%")
	(init-machine-configuration)

	(format t "~%; -> You can switch to Lisp by typing (lisp) and back ~
                to Nesl by typing (nesl).~%~
                ; -> Use (nesl) when an error aborts you out of the ~
                interpreter.~%~
                ; -> Type (help) for a list of the top level commands.~%~%")
	))

(nesl)
