(lisp::let ((lisp::*default-pathname-defaults* 
	     (lisp::pathname nesl-lisp::*nesl-path*)))
  (load "examples/primes")
  (load "examples/string-search")
  (load "examples/median")
  (load "examples/quicksort")
  (load "examples/duplicates")
  (load "examples/string-sort")
  (load "examples/parentheses-match"))

;; This prints the string STR and then prints a ".....FAILED"
;; message if V is false and a "passed" message if it is true
(defop (test str v) (int <- v.char bool)
  (with ((t1 (print-string str))
 	 (t2 (if v 
		 (print-string " passed")
	       (print-string "........FAILED")))
	 (t3 (print-char #\newline)))
    0))

(sdefop (testexamps) (int <-)
  (with ((foo (test "PRIMES" 
		    (eql (length (primes 50000)) 5134)))
	 (foo (test "QUICKSORT" 
		    (eql (qsort (reverse (index 10000))) (index 10000))))
	 (foo (test "MEDIAN" 
		    (eql (order (iseq 5 10 500000) 1000) 10005)))
	 (foo (test "STRING SEARCH"
		    (eql (string-search "foo" (flatten (dist "foo" 5000)))
			 (iseq 0 3 15000))))
	 (foo (test "REMOVE DUPLICATES"
		    (= (length (remove-duplicates 
				(interleave (index 10000) (index 10000))))
		       10000)))
	 (randvect (v.+ (v.rand (dist 1000000 2000)) v.1000000))
	 (foo (test "STRING RANK"
		    (eql (string-rank (v.string randvect))
			 (rank randvect))))
	 (foo (test "PARENTHESES MATCH"
		    (eql (append (iseq 1999 -1 999) (iseq 999 -1 -1))
			 (paren-match (append (dist #\( 1000) 
					      (dist #\) 1000))))))
	 )
    0))

