(in-package 'nesl)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; CODE FOR SORTING CHARACTER STRINGS
;;;    Work Complexity = (+-reduce (v.length words))
;;;    Step Complexity = (max-reduce (v.length words))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; A vv-char is a segmented vector of characters
;;  OFFSET points to the begining of each segment
;;  LEN is the length of each segment
;;  VALS are the actual characters
(defrec vv-char (offset v.int) (len v.int) (vals v.char))

;; Makes a vv-char from a vector of vectors of characters
(defop (make-vv-char nstr) (vv-char <- v.v.char)
  (with ((len (v.length nstr)))
     (vv-char (+-scan len) len (flatten nstr))))

;; This returns the order (inverse of rank).
;;   WORDS (also x-WORDS) in this function are integer pointers to the
;;     the actual character strings, which are stored in data
(sdefop (string-orders words data i) (v.int <- v.int vv-char int)
  (if (zerop (length words)) 
      #v.int()
    (with ((long-word-flags     (v.> (get (len data) words) v.(+ 1 i)))
	   (long-words          (pack words long-word-flags))
	   (short-words         (pack words (v.not long-word-flags)))
	   (sorted-long-words   (string-orders long-words data (+ i 1)))
	   (sorted-words        (append short-words sorted-long-words))
	   (character-offsets   (v.+ v.i (get (offset data) sorted-words)))
	   (chars-at-position-i (get (vals data) character-offsets)))
      (permute sorted-words (char-rank chars-at-position-i)))))

;; This returns the lexicographic rank of a vector of character strings.
(sdefop (string-rank words) (v.int <- v.v.char)
  (with ((idx (index (length words))))
    (permute idx (string-orders idx (make-vv-char words) 0))))
