(defop (primes n) (v.int <- int)
  (if (= n 1) 
      #v.int()
    (with ((sqr-primes (primes (isqrt n)))
           (sieves     (over ((p sqr-primes)) 
                         (iseq (* 2 p) p n)))
           (flat-sieve (flatten sieves))
           (flags      (const-put f flat-sieve (dist t n))))
      (drop 2 (pack-index flags)))))
