/*
 * Decompiled with CFR 0.152.
 */
package ladybug.util;

import java.util.Vector;

public class Partitioning {
    private Vector _elements = new Vector();
    private int[] list;
    private int[] r = new int[this._allocElemSize];
    private int[] size;
    private int[] next;
    private int _numElements = 0;
    private int _numPartitions = 0;
    private int _allocPartSize = 8;
    private int _allocElemSize = 8;

    public Partitioning() {
        this.list = new int[this._allocPartSize];
        this.size = new int[this._allocPartSize];
        this.next = new int[this._allocElemSize];
    }

    public void addElement(Object elem) {
        int i;
        if (this._elements.contains(elem)) {
            return;
        }
        this._elements.addElement(elem);
        if (this._numElements == this._allocElemSize) {
            int[] oldr = this.r;
            int[] oldnext = this.next;
            this.r = new int[this._allocElemSize * 2];
            this.next = new int[this._allocElemSize * 2];
            i = 0;
            while (i < this._allocElemSize) {
                this.r[i] = oldr[i];
                this.next[i] = oldnext[i];
                ++i;
            }
            this._allocElemSize *= 2;
        }
        if (this._numPartitions == this._allocPartSize) {
            int[] oldlist = this.list;
            int[] oldsize = this.size;
            this.list = new int[this._allocPartSize * 2];
            this.size = new int[this._allocPartSize * 2];
            i = 0;
            while (i < this._allocPartSize) {
                this.list[i] = oldlist[i];
                this.size[i] = oldsize[i];
                ++i;
            }
            this._allocPartSize *= 2;
        }
        this.r[this._numElements] = this._numPartitions;
        this.list[this._numPartitions] = this._numElements;
        this.size[this._numPartitions] = 1;
        this.next[this._numElements] = -1;
        ++this._numElements;
        ++this._numPartitions;
    }

    public void join(Object elem1, Object elem2) {
        int e2;
        int p2;
        int e1;
        int p1;
        if (!this._elements.contains(elem1)) {
            this.addElement(elem1);
        }
        if (elem1 == elem2) {
            return;
        }
        if (!this._elements.contains(elem2)) {
            this.addElement(elem2);
        }
        if ((p1 = this.r[e1 = this._elements.indexOf(elem1)]) == (p2 = this.r[e2 = this._elements.indexOf(elem2)])) {
            return;
        }
        if (this.size[p1] > this.size[p2]) {
            int t = p1;
            p1 = p2;
            p2 = t;
        }
        int last = 0;
        int curr = this.list[p1];
        while (curr != -1) {
            this.r[curr] = p2;
            last = curr;
            curr = this.next[curr];
        }
        this.next[last] = this.list[p2];
        this.list[p2] = this.list[p1];
        int n = p2;
        this.size[n] = this.size[n] + this.size[p1];
        this.size[p1] = 0;
        this.list[p1] = -1;
    }

    public boolean same(Object elem1, Object elem2) {
        int e2;
        if (!this._elements.contains(elem1)) {
            return false;
        }
        if (!this._elements.contains(elem2)) {
            return false;
        }
        int e1 = this._elements.indexOf(elem1);
        return this.r[e1] == this.r[e2 = this._elements.indexOf(elem2)];
    }
}

