/*
 * Decompiled with CFR 0.152.
 */
package ladybug.ui;

import fontanus.ui.layout.TableLayout;
import fontanus.ui.window.DialogFactory;
import fontanus.ui.window.FrameList;
import fontanus.ui.window.WindowCloser;
import fontanus.ui.window.WindowUtil;
import fontanus.util.SavableObject;
import java.awt.Button;
import java.awt.CheckboxMenuItem;
import java.awt.Color;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Label;
import java.awt.List;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.TextArea;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import ladybug.engine.LadyBug;
import ladybug.engine.Script;
import ladybug.parse.Schema;
import ladybug.ui.DataTransferHandler;
import ladybug.ui.SchemaWindow;
import ladybug.ui.WindowMenuHandler;
import ladybug.util.Console;

public class MainWindow
extends Frame
implements Console,
SavableObject {
    private static final int[] colbases;
    private static final int[] colweights;
    private static final int[] rowbases;
    private static final int[] rowweights;
    private static final String release = "0.81";
    private static final String releaseMod = " (beta release)";
    private static final String fullRelease = "0.81 (beta release)";
    private static final String welcomeMsg = "Welcome to Ladybug 0.81 (beta release), Copyright 1998-1999";
    private static final String openInstr = "Select 'Open' to load a specification...";
    private static final String checkInstr1 = "Select a claim or schema and choose 'Check' from the menu";
    private static final String checkInstr2 = "    or double click on a claim or schema";
    private MenuBar mb = new MenuBar();
    private MenuItem checkMenuItem = new MenuItem("Check", new MenuShortcut(82));
    private MenuItem runScriptMenuItem = new MenuItem("Run Script");
    private MenuItem killScriptMenuItem = new MenuItem("Kill Scripts");
    private MenuItem pauseScriptMenuItem = new MenuItem("Pause Script");
    private MenuItem resumeScriptMenuItem = new MenuItem("Resume Scripts");
    private MenuItem scriptStatusMenuItem = new MenuItem("Script Status");
    private CheckboxMenuItem loggingMenuItem = new CheckboxMenuItem("Logging");
    private MenuItem logFileMenuItem = new MenuItem("Log File ...");
    private WindowCloser theCloser = null;
    private Hashtable schemaWins = new Hashtable();
    private TextField fname = new TextField();
    private Button reload = new Button("Reload");
    private Button open = new Button("Open");
    private List claims = new List();
    private List schemas = new List();
    private TextArea spec = new TextArea("", 15, 60);
    private TextField status = new TextField("Ready...");
    private boolean firstOpen = true;
    private boolean firstLoad = true;
    private boolean anyMessages = false;

    public MainWindow() {
        super("LadyBug 0.81");
        this.initColor();
        this.initLayout();
        this.status.setEditable(false);
        this.spec.setEditable(false);
        this.appendTextLine(welcomeMsg);
        this.appendTextLine("");
        this.appendTextLine(openInstr);
        this.theCloser = WindowCloser.getInstance("Exit", "Do you want to save the results before exiting?", this, true);
        SpecificationHandler theSpecHandler = new SpecificationHandler();
        this.initMenuBar(theSpecHandler, this.theCloser);
        this.fname.addActionListener(theSpecHandler);
        this.reload.addActionListener(theSpecHandler);
        this.open.addActionListener(theSpecHandler);
        SchemaListHandler theSchemaListHandler = new SchemaListHandler();
        this.claims.addItemListener(theSchemaListHandler);
        this.schemas.addItemListener(theSchemaListHandler);
        this.claims.addActionListener(theSchemaListHandler);
        this.schemas.addActionListener(theSchemaListHandler);
        this.addWindowListener(this.theCloser);
        this.pack();
        this.setMenuBar(this.mb);
        this.pack();
    }

    private void initColor() {
        ((Component)this).setBackground(Color.lightGray);
        ((Component)this.fname).setBackground(Color.white);
        this.claims.setBackground(Color.white);
        this.schemas.setBackground(Color.white);
        ((Component)this.spec).setBackground(Color.white);
    }

    private void initLayout() {
        TableLayout layout = new TableLayout(colbases, colweights, rowbases, rowweights);
        this.setLayout(layout);
        layout.addComponent(new Label("Specification"), this, 1, 1);
        layout.addComponent(this.fname, this, 3, 1, 3, 1);
        layout.addComponent(this.reload, this, 7, 1);
        layout.addComponent(this.open, this, 9, 1);
        layout.addComponent(new Label("Claims"), this, 1, 3, 3, 1);
        layout.addComponent(this.claims, this, 1, 4, 3, 1);
        layout.addComponent(new Label("Schemas"), this, 1, 6, 3, 1);
        layout.addComponent(this.schemas, this, 1, 7, 3, 2);
        layout.addComponent(this.spec, this, 5, 3, 5, 5);
        layout.addComponent(this.status, this, 5, 8, 5, 1);
    }

    private void initMenuBar(SpecificationHandler specHandler, WindowCloser theCloser) {
        MenuHandler theMenuHandler = new MenuHandler();
        Menu fileMenu = new Menu("File");
        this.mb.add(fileMenu);
        this.addMenuItem(fileMenu, new MenuItem("Open", new MenuShortcut(79)), specHandler);
        this.addMenuItem(fileMenu, new MenuItem("Reload"), specHandler);
        this.addMenuItem(fileMenu, new MenuItem("Save Log", new MenuShortcut(83)), new 1());
        fileMenu.addSeparator();
        this.addMenuItem(fileMenu, this.checkMenuItem, theMenuHandler);
        this.checkMenuItem.setEnabled(false);
        fileMenu.add(this.loggingMenuItem);
        this.loggingMenuItem.addItemListener(theMenuHandler);
        fileMenu.add(this.logFileMenuItem);
        this.logFileMenuItem.addActionListener(theMenuHandler);
        fileMenu.addSeparator();
        this.addMenuItem(fileMenu, MainWindow.getExitMenuItem(), theCloser);
        DataTransferHandler dth = new DataTransferHandler(this.spec);
        Menu editMenu = new Menu("Edit");
        this.mb.add(editMenu);
        this.addMenuItem(editMenu, new MenuItem("Copy", new MenuShortcut(67)), dth);
        editMenu.addSeparator();
        this.addMenuItem(editMenu, new MenuItem("Clear Log"), new 2());
        Menu scrMenu = new Menu("Scripts");
        this.mb.add(scrMenu);
        this.addMenuItem(scrMenu, this.runScriptMenuItem, theMenuHandler);
        this.addMenuItem(scrMenu, this.killScriptMenuItem, theMenuHandler);
        this.addMenuItem(scrMenu, this.pauseScriptMenuItem, theMenuHandler);
        this.addMenuItem(scrMenu, this.resumeScriptMenuItem, theMenuHandler);
        this.addMenuItem(scrMenu, this.scriptStatusMenuItem, theMenuHandler);
        Menu windowMenu = new Menu("Window");
        this.mb.add(windowMenu);
        new WindowMenuHandler(FrameList.getInstance(), windowMenu);
    }

    static MenuItem getExitMenuItem() {
        String os = System.getProperty("os.name");
        if (os.equals("Mac OS")) {
            return new MenuItem("Quit", new MenuShortcut(81));
        }
        return new MenuItem("Exit");
    }

    private void addMenuItem(Menu theMenu, MenuItem theItem, ActionListener listener) {
        theItem.addActionListener(listener);
        theMenu.add(theItem);
    }

    public void close() {
        this.theCloser.close(this);
    }

    public synchronized void dispose() {
        this.closeSchemas();
        super.dispose();
    }

    public synchronized void setText(String text) {
        this.spec.setText(text);
        this.anyMessages = true;
    }

    public synchronized void appendText(String text) {
        this.spec.append(text);
        this.anyMessages = true;
    }

    public void appendTextLine(String text) {
        this.appendText(String.valueOf(text) + '\n');
        this.anyMessages = true;
    }

    public int stringLength(String text) {
        FontMetrics fm = this.spec.getFontMetrics(this.spec.getFont());
        return fm.stringWidth(text);
    }

    public String fillerString(String str, int len) {
        FontMetrics fm = this.spec.getFontMetrics(this.spec.getFont());
        String s = str;
        int l2 = fm.stringWidth(str);
        while (fm.stringWidth(s) < len + l2) {
            s = fm.stringWidth(s) < len / 2 ? String.valueOf(s) + s : String.valueOf(s) + str;
        }
        return s;
    }

    public void setStatus(String text) {
        ((TextComponent)this.status).setText(text);
    }

    public boolean save() {
        File theFile = DialogFactory.showSaveDialog(this, "Save results");
        if (theFile == null) {
            return false;
        }
        try {
            FileWriter fw = new FileWriter(theFile);
            fw.write(this.spec.getText());
            fw.close();
            this.anyMessages = false;
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    public boolean needsSave() {
        return this.anyMessages;
    }

    public static void main(String[] args) {
        LadyBug.init();
        MainWindow m = new MainWindow();
        LadyBug.setConsole(m);
        FrameList fl = FrameList.getInstance();
        fl.addFrame(m);
        WindowUtil.cascade(m);
        m.show();
    }

    void closeSchemas() {
        Enumeration sws = this.schemaWins.elements();
        while (sws.hasMoreElements()) {
            Object o = sws.nextElement();
            if (o == Boolean.TRUE) continue;
            WindowUtil.close((SchemaWindow)o);
        }
    }

    void schemaClosed(SchemaWindow sw) {
        this.schemaWins.remove(sw.getSolver().getSchema().getName());
    }

    SchemaWindow getSchemaWindow(String name) {
        SchemaWindow sw;
        if (this.schemaWins.containsKey(name)) {
            Object o = this.schemaWins.get(name);
            if (o == Boolean.TRUE) {
                return null;
            }
            sw = (SchemaWindow)o;
            FrameList fl = FrameList.getInstance();
            fl.addFrame(sw);
            sw.show();
            sw.toFront();
        } else {
            this.schemaWins.put(name, Boolean.TRUE);
            sw = SchemaWindow.getSchemaWindow(name, this);
            FrameList fl = FrameList.getInstance();
            fl.addFrame(sw);
            WindowUtil.cascade(sw);
            sw.show();
            this.schemaWins.put(name, sw);
        }
        return sw;
    }

    static {
        int[] nArray = new int[11];
        nArray[0] = 6;
        nArray[2] = 6;
        nArray[4] = 6;
        nArray[6] = 6;
        nArray[8] = 6;
        nArray[10] = 6;
        colbases = nArray;
        int[] nArray2 = new int[11];
        nArray2[3] = 3;
        nArray2[5] = 7;
        colweights = nArray2;
        int[] nArray3 = new int[10];
        nArray3[0] = 6;
        nArray3[2] = 12;
        nArray3[5] = 12;
        nArray3[9] = 6;
        rowbases = nArray3;
        int[] nArray4 = new int[10];
        nArray4[4] = 5;
        nArray4[7] = 5;
        rowweights = nArray4;
    }

    private final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent evt) {
            MainWindow.this.save();
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    implements ActionListener {
        public void actionPerformed(ActionEvent evt) {
            MainWindow.this.setText("");
        }

        /* synthetic */ 2() {
        }
    }

    private class SpecificationHandler
    implements ActionListener {
        public void actionPerformed(ActionEvent evt) {
            String cmd = evt.getActionCommand();
            if (evt.getSource() == MainWindow.this.fname) {
                this.loadFile(new File(cmd));
            } else if ("Reload".equals(cmd)) {
                this.loadFile(new File(MainWindow.this.fname.getText()));
            } else if ("Open".equals(cmd)) {
                FileDialog fd = new FileDialog((Frame)MainWindow.this, "Open");
                fd.show();
                String theFile = fd.getFile();
                if (theFile != null) {
                    String theDir = fd.getDirectory();
                    ((TextComponent)MainWindow.this.fname).setText(LadyBug.localizePath(String.valueOf(theDir) + theFile));
                    this.loadFile(new File(theDir, theFile));
                }
            }
        }

        private void loadFile(File theFile) {
            MainWindow.this.claims.removeAll();
            MainWindow.this.schemas.removeAll();
            MainWindow.this.checkMenuItem.setEnabled(false);
            if (MainWindow.this.firstOpen) {
                MainWindow.this.firstOpen = false;
                MainWindow.this.setText(MainWindow.welcomeMsg);
                MainWindow.this.appendTextLine("");
                MainWindow.this.appendTextLine("");
            }
            MainWindow.this.closeSchemas();
            if (LadyBug.load(theFile)) {
                MainWindow.this.appendTextLine("");
                MainWindow.this.appendTextLine("Loaded " + theFile.getName());
                if (MainWindow.this.firstLoad) {
                    MainWindow.this.firstLoad = false;
                    MainWindow.this.appendTextLine("");
                    MainWindow.this.appendTextLine(MainWindow.checkInstr1);
                    MainWindow.this.appendTextLine(MainWindow.checkInstr2);
                    MainWindow.this.appendTextLine("");
                }
                MainWindow.this.setTitle(String.valueOf(theFile.getName()) + " - Ladybug " + MainWindow.release);
                Enumeration e = LadyBug.getSpec().schemas();
                while (e.hasMoreElements()) {
                    Schema theSchema = (Schema)e.nextElement();
                    if (theSchema.isClaim()) {
                        MainWindow.this.claims.add(theSchema.getName());
                        continue;
                    }
                    MainWindow.this.schemas.add(theSchema.getName());
                }
            } else {
                MainWindow.this.setTitle("Ladybug 0.81");
            }
        }

        SpecificationHandler() {
        }
    }

    private class SchemaListHandler
    implements ActionListener,
    ItemListener {
        public void actionPerformed(ActionEvent evt) {
            MainWindow.this.setStatus("Opening " + evt.getActionCommand());
            MainWindow.this.getSchemaWindow(evt.getActionCommand());
        }

        public void itemStateChanged(ItemEvent evt) {
            MainWindow.this.checkMenuItem.setEnabled(true);
            if (evt.getSource() == MainWindow.this.claims) {
                if (MainWindow.this.schemas.getSelectedIndex() != -1) {
                    MainWindow.this.schemas.deselect(MainWindow.this.schemas.getSelectedIndex());
                }
            } else if (MainWindow.this.claims.getSelectedIndex() != -1) {
                MainWindow.this.claims.deselect(MainWindow.this.claims.getSelectedIndex());
            }
        }

        SchemaListHandler() {
        }
    }

    private class MenuHandler
    implements ActionListener,
    ItemListener {
        private boolean startedLogging = false;

        public void actionPerformed(ActionEvent evt) {
            Object source = evt.getSource();
            if (source == MainWindow.this.checkMenuItem) {
                String name = MainWindow.this.schemas.getSelectedIndex() != -1 ? MainWindow.this.schemas.getSelectedItem() : MainWindow.this.claims.getSelectedItem();
                MainWindow.this.setStatus("Checking " + name);
                SchemaWindow sw = MainWindow.this.getSchemaWindow(name);
                if (sw != null) {
                    sw.checkSchema();
                }
            } else if (source == MainWindow.this.runScriptMenuItem) {
                File theFile = DialogFactory.showLoadDialog(MainWindow.this, "Select script to run");
                if (theFile != null) {
                    LadyBug.runScript(new Script(theFile));
                }
            } else if (source == MainWindow.this.killScriptMenuItem) {
                LadyBug.stopScripts();
            } else if (source == MainWindow.this.pauseScriptMenuItem) {
                LadyBug.pauseScripts();
            } else if (source == MainWindow.this.resumeScriptMenuItem) {
                LadyBug.resumeScripts();
            } else if (source == MainWindow.this.scriptStatusMenuItem) {
                LadyBug.scriptMessages();
            } else if (source == MainWindow.this.logFileMenuItem) {
                File theFile = DialogFactory.showSaveDialog(MainWindow.this, "Select log file");
                if (theFile == null) {
                    MainWindow.this.loggingMenuItem.setState(false);
                    return;
                }
                if (LadyBug.startLogging(theFile)) {
                    this.startedLogging = true;
                    MainWindow.this.loggingMenuItem.setState(true);
                } else {
                    MainWindow.this.loggingMenuItem.setState(false);
                }
            }
        }

        public void itemStateChanged(ItemEvent evt) {
            if (evt.getSource() == MainWindow.this.loggingMenuItem) {
                if (!MainWindow.this.loggingMenuItem.getState()) {
                    LadyBug.pauseLogging();
                    return;
                }
                if (this.startedLogging) {
                    LadyBug.resumeLogging();
                    return;
                }
                File theFile = DialogFactory.showSaveDialog(MainWindow.this, "Select log file");
                if (theFile == null) {
                    MainWindow.this.loggingMenuItem.setState(false);
                    return;
                }
                if (LadyBug.startLogging(theFile)) {
                    this.startedLogging = true;
                } else {
                    MainWindow.this.loggingMenuItem.setState(false);
                }
            }
        }

        MenuHandler() {
        }
    }
}

