/*
 * Decompiled with CFR 0.152.
 */
package ladybug.ui;

import fontanus.ui.IntegerField;
import fontanus.ui.layout.TableLayout;
import fontanus.ui.window.DialogConstants;
import fontanus.ui.window.StandardDialog;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import ladybug.engine.SchemaSolver;

public class LimitsDialog
extends Panel
implements DialogConstants {
    private static final int[] colbases;
    private static final int[] colweights;
    private static final int[] rowbases;
    private static final int[] rowweights;
    private Checkbox _displayBox = new Checkbox("Display at most:");
    private Checkbox _findBox = new Checkbox("Find at most:");
    private Checkbox _timeoutBox = new Checkbox("Timeout after:");
    private IntegerField _displayField = new IntegerField(7);
    private IntegerField _findField = new IntegerField(7);
    private IntegerField _timeoutField = new IntegerField(7);

    protected LimitsDialog(SchemaSolver solver) {
        this.initColor();
        TableLayout layout = new TableLayout(colbases, colweights, rowbases, rowweights);
        this.setLayout(layout);
        layout.addComponent(this._displayBox, this, 0, 0);
        layout.addComponent(this._displayField, this, 2, 0);
        layout.addComponent(this._findBox, this, 0, 2);
        layout.addComponent(this._findField, this, 2, 2);
        layout.addComponent(this._timeoutBox, this, 0, 4);
        layout.addComponent(this._timeoutField, this, 2, 4);
        layout.addComponent(new Label("seconds"), this, 4, 4);
        this.setupEventBindings();
    }

    private void initColor() {
        ((Component)this._displayField).setBackground(Color.white);
        ((Component)this._findField).setBackground(Color.white);
        ((Component)this._timeoutField).setBackground(Color.white);
    }

    private void setupEventBindings() {
        BoxListener bl = new BoxListener();
        this._displayBox.addItemListener(bl);
        this._findBox.addItemListener(bl);
        this._timeoutBox.addItemListener(bl);
    }

    public static void showLimitsDialog(Component parent, SchemaSolver solver) {
        LimitsDialog ld = new LimitsDialog(solver);
        ld.getSolverParams(solver);
        String result = StandardDialog.showStandardDialog(new StandardDialog(parent, "Limits", ld, StandardDialog.localize(DialogConstants.OK_CANCEL), DialogConstants.OK_CANCEL));
        if (result.equals("ok")) {
            ld.setSolverParams(solver);
        }
    }

    private void getSolverParams(SchemaSolver solver) {
        if (solver == null) {
            TextField[] fields = new TextField[]{this._displayField, this._findField, this._timeoutField};
            int i = 0;
            while (i < fields.length) {
                fields[i].setEnabled(false);
                fields[i].setEditable(false);
                ++i;
            }
            return;
        }
        this.setupBoxFieldPair(this._displayBox, this._displayField, solver.getUnlimitedModelsToDisplay(), solver.numModelsToDisplay());
        this.setupBoxFieldPair(this._findBox, this._findField, solver.getUnlimitedModelsWanted(), solver.numModelsWanted());
        this.setupBoxFieldPair(this._timeoutBox, this._timeoutField, solver.getUnlimitedTimeout(), solver.getTimeout() / 1000);
    }

    private void setupBoxFieldPair(Checkbox box, TextField field, boolean unlimited, int value) {
        box.setState(unlimited ^ true);
        ((TextComponent)field).setText(Integer.toString(value));
        if (unlimited) {
            field.setEnabled(false);
            field.setEditable(false);
        }
    }

    private void setSolverParams(SchemaSolver solver) {
        if (solver == null) {
            return;
        }
        solver.setNumModelsToDisplay(Integer.parseInt(this._displayField.getText()));
        solver.setUnlimitedModelsToDisplay(this._displayBox.getState() ^ true);
        solver.setNumModelsWanted(Integer.parseInt(this._findField.getText()));
        solver.setUnlimitedModelsWanted(this._findBox.getState() ^ true);
        solver.setTimeout(Integer.parseInt(this._timeoutField.getText()) * 1000);
        solver.setUnlimitedTimeout(this._timeoutBox.getState() ^ true);
    }

    static {
        int[] nArray = new int[5];
        nArray[1] = 6;
        nArray[3] = 6;
        colbases = nArray;
        int[] nArray2 = new int[5];
        nArray2[2] = 1;
        colweights = nArray2;
        int[] nArray3 = new int[5];
        nArray3[1] = 6;
        nArray3[3] = 6;
        rowbases = nArray3;
        rowweights = new int[5];
    }

    class BoxListener
    implements ItemListener {
        public void itemStateChanged(ItemEvent evt) {
            Checkbox cb = (Checkbox)evt.getSource();
            boolean state = cb.getState();
            IntegerField tf = null;
            if (cb == LimitsDialog.this._displayBox) {
                tf = LimitsDialog.this._displayField;
            } else if (cb == LimitsDialog.this._findBox) {
                tf = LimitsDialog.this._findField;
            } else if (cb == LimitsDialog.this._timeoutBox) {
                tf = LimitsDialog.this._timeoutField;
            }
            if (tf != null) {
                tf.setEnabled(state);
                tf.setEditable(state);
            }
        }

        BoxListener() {
        }
    }
}

