/*
 * Decompiled with CFR 0.152.
 */
package ladybug.ui;

import fontanus.ui.BorderPanel;
import fontanus.ui.layout.TableLayout;
import fontanus.ui.window.StandardDialog;
import fontanus.ui.window.WindowCloser;
import fontanus.ui.window.WindowUtil;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import ladybug.engine.AssignmentDisplay;
import ladybug.parse.VarEnumeration;

public class DisplayOptionsDialog
extends Dialog {
    private static final int[] colbases;
    private static final int[] colweights;
    private static final int[] rowbases;
    private static final int[] rowweights;
    private static final int[] colbases2;
    private static final int[] colweights2;
    private static final int[] rowbases2;
    private static final int[] rowweights2;
    private List _displayedList = new List(10, true);
    private List _hiddenList = new List(10, true);
    private Button _hideButton = new Button("-->");
    private Button _showButton = new Button("<--");
    private Checkbox _alphaRadio = new Checkbox("Alphabetic");
    private Checkbox _logicalRadio = new Checkbox("Logical");
    private Checkbox _derivedBox = new Checkbox("Derived", true);
    private Checkbox _intermedBox = new Checkbox("Intermediate", true);
    private Button _closeButton = new Button("Close");
    private AssignmentDisplay _display;

    public DisplayOptionsDialog(Component parent, AssignmentDisplay display) {
        super(WindowUtil.getFrame(parent), "Display Options", true);
        this._display = display;
        display.sortAlpha();
        this.initColor();
        this.initLayout();
        this.initEventBindings();
        this.syncState();
        this.pack();
    }

    private void initColor() {
        this._displayedList.setBackground(Color.white);
        this._hiddenList.setBackground(Color.white);
    }

    private void initLayout() {
        TableLayout layout = new TableLayout(colbases, colweights, rowbases, rowweights);
        this.setLayout(layout);
        TableLayout layout2 = new TableLayout(colbases2, colweights2, rowbases2, rowweights2);
        layout.addComponent(new Label("Displayed"), this, 1, 1, 2, 1);
        layout.addComponent(this._displayedList, this, 1, 2, 2, 5);
        layout.addComponent(new Label("Hidden"), this, 6, 1, 3, 1);
        layout.addComponent(this._hiddenList, this, 6, 2, 3, 5);
        layout.addComponent(this._hideButton, this, 4, 3);
        layout.addComponent(this._showButton, this, 4, 5);
        layout.addComponent(this.createSortingPanel(layout2), this, 1, 8, 1, 2);
        layout.addComponent(this.createShowPanel(layout2), this, 3, 8, 4, 2);
        layout.addComponent(this._closeButton, this, 8, 9);
    }

    private Panel createSortingPanel(TableLayout layout) {
        CheckboxGroup group = new CheckboxGroup();
        this._alphaRadio.setCheckboxGroup(group);
        this._logicalRadio.setCheckboxGroup(group);
        this._alphaRadio.setState(true);
        BorderPanel p = new BorderPanel("Sorting", 6);
        p.setLayout(layout);
        layout.addComponent(this._alphaRadio, p, 0, 0);
        layout.addComponent(this._logicalRadio, p, 0, 2);
        return p;
    }

    private Panel createShowPanel(TableLayout layout) {
        BorderPanel p = new BorderPanel("Show", 6);
        p.setLayout(layout);
        layout.addComponent(this._derivedBox, p, 0, 0);
        layout.addComponent(this._intermedBox, p, 0, 2);
        return p;
    }

    private void initEventBindings() {
        this.addWindowListener(WindowCloser.getInstance());
        this._closeButton.addActionListener(WindowCloser.getInstance());
        EventHandler handler = new EventHandler();
        this._showButton.addActionListener(handler);
        this._hideButton.addActionListener(handler);
        this._displayedList.addItemListener(handler);
        this._hiddenList.addItemListener(handler);
        this._alphaRadio.addItemListener(handler);
        this._logicalRadio.addItemListener(handler);
        this._derivedBox.addItemListener(handler);
        this._intermedBox.addItemListener(handler);
    }

    private void syncState() {
        this._displayedList.removeAll();
        this._hiddenList.removeAll();
        VarEnumeration e = this._display.displayedVars().elements();
        while (e.hasMoreElements()) {
            this._displayedList.add(e.nextVar().getName());
        }
        VarEnumeration e2 = this._display.hiddenVars().elements();
        while (e2.hasMoreElements()) {
            this._hiddenList.add(e2.nextVar().getName());
        }
        this._hideButton.setEnabled(false);
        this._showButton.setEnabled(false);
        this._derivedBox.setState(this._display.getShowDerived());
        this._intermedBox.setState(this._display.getShowIntermediate());
    }

    public static void showOptionsDialog(Component parent, AssignmentDisplay display) {
        DisplayOptionsDialog d = new DisplayOptionsDialog(parent, display);
        WindowUtil.center(d);
        StandardDialog.showDialog(d);
    }

    static {
        int[] nArray = new int[10];
        nArray[0] = 6;
        nArray[2] = 12;
        nArray[3] = 12;
        nArray[5] = 12;
        nArray[7] = 12;
        nArray[9] = 6;
        colbases = nArray;
        int[] nArray2 = new int[10];
        nArray2[1] = 5;
        nArray2[6] = 5;
        colweights = nArray2;
        int[] nArray3 = new int[11];
        nArray3[0] = 6;
        nArray3[2] = 12;
        nArray3[4] = 12;
        nArray3[6] = 12;
        nArray3[7] = 12;
        nArray3[10] = 6;
        rowbases = nArray3;
        int[] nArray4 = new int[11];
        nArray4[2] = 5;
        nArray4[6] = 5;
        rowweights = nArray4;
        colbases2 = new int[1];
        colweights2 = new int[]{1};
        int[] nArray5 = new int[3];
        nArray5[1] = 6;
        rowbases2 = nArray5;
        int[] nArray6 = new int[3];
        nArray6[0] = 1;
        nArray6[2] = 1;
        rowweights2 = nArray6;
    }

    private class EventHandler
    implements ItemListener,
    ActionListener {
        public void actionPerformed(ActionEvent evt) {
            Object source = evt.getSource();
            if (source == DisplayOptionsDialog.this._hideButton) {
                String[] items = DisplayOptionsDialog.this._displayedList.getSelectedItems();
                int i = 0;
                while (i < items.length) {
                    DisplayOptionsDialog.this._display.hideVar(items[i]);
                    ++i;
                }
                DisplayOptionsDialog.this.syncState();
                DisplayOptionsDialog.this._displayedList.requestFocus();
            } else if (source == DisplayOptionsDialog.this._showButton) {
                String[] items = DisplayOptionsDialog.this._hiddenList.getSelectedItems();
                int i = 0;
                while (i < items.length) {
                    DisplayOptionsDialog.this._display.showVar(items[i]);
                    ++i;
                }
                DisplayOptionsDialog.this.syncState();
                DisplayOptionsDialog.this._hiddenList.requestFocus();
            }
        }

        public void itemStateChanged(ItemEvent evt) {
            Object source = evt.getSource();
            if (source == DisplayOptionsDialog.this._displayedList) {
                this.setButtonEnabled(DisplayOptionsDialog.this._displayedList, DisplayOptionsDialog.this._hideButton);
            } else if (source == DisplayOptionsDialog.this._hiddenList) {
                this.setButtonEnabled(DisplayOptionsDialog.this._hiddenList, DisplayOptionsDialog.this._showButton);
            } else if (source == DisplayOptionsDialog.this._alphaRadio) {
                DisplayOptionsDialog.this._display.sortAlpha();
                DisplayOptionsDialog.this.syncState();
            } else if (source == DisplayOptionsDialog.this._logicalRadio) {
                DisplayOptionsDialog.this._display.sortLogical();
                DisplayOptionsDialog.this.syncState();
            } else if (source == DisplayOptionsDialog.this._derivedBox) {
                DisplayOptionsDialog.this._display.setShowDerived(DisplayOptionsDialog.this._derivedBox.getState());
                DisplayOptionsDialog.this.syncState();
            } else if (source == DisplayOptionsDialog.this._intermedBox) {
                DisplayOptionsDialog.this._display.setShowIntermediate(DisplayOptionsDialog.this._intermedBox.getState());
                DisplayOptionsDialog.this.syncState();
            }
        }

        private void setButtonEnabled(List theList, Button theButton) {
            theButton.setEnabled(theList.getSelectedIndexes().length > 0);
        }

        EventHandler() {
        }
    }
}

