/*
 * Decompiled with CFR 0.152.
 */
package ladybug.selenum.isomorph;

import ladybug.engine.FunctionValue;
import ladybug.engine.RelOrFuncValue;
import ladybug.engine.RelationValue;
import ladybug.engine.ScalarValue;
import ladybug.engine.SetValue;
import ladybug.engine.Value;
import ladybug.selenum.isomorph.ColorUpdater;
import ladybug.selenum.isomorph.Coloring;

public class StructuralUpdater
extends ColorUpdater {
    StructuralUpdater(Coloring base, SetValue domain) {
        super(base, domain);
    }

    StructuralUpdater(Coloring base, SetValue domain, SetValue range) {
        super(base, domain, range);
    }

    boolean independent() {
        return false;
    }

    void resetDomain(SetValue domain) {
        super.resetDomain(domain);
    }

    int update(ScalarValue value, int[] colors) {
        return this._base.distinguish(value);
    }

    int update(SetValue value, int[] colors) {
        return this._base.distinguish(value);
    }

    public int update(FunctionValue value, int[] colors, int[] rcolors) {
        int incr = 0;
        boolean changed = true;
        while (changed) {
            changed = false;
            incr = 0;
            int index = 1;
            while (index < colors.length) {
                if (colors[index] + incr == colors[index - 1] && (value.isMapped(index) || value.isMapped(index - 1))) {
                    if (!value.isMapped(index) || !value.isMapped(index - 1)) {
                        ++incr;
                    } else if (value.mapsTo(index) != value.mapsTo(index - 1) && rcolors[value.mapsTo(index)] != rcolors[value.mapsTo(index - 1)]) {
                        ++incr;
                    }
                }
                int n = index++;
                colors[n] = colors[n] + incr;
            }
            this._base.updateNumColors(incr);
            incr = 0;
            int dmax = value.domainMax();
            index = 1;
            while (index < rcolors.length) {
                block20: {
                    if (rcolors[index - 1] != rcolors[index] + incr) {
                        int n = index;
                        rcolors[n] = rcolors[n] + incr;
                    } else {
                        int mapped0 = -1;
                        int mapped1 = -1;
                        int j = 0;
                        while (j < dmax) {
                            if (value.isMapped(j)) {
                                if (value.hasMapping(j, index)) {
                                    if (mapped1 != -1) {
                                        int n = index;
                                        rcolors[n] = rcolors[n] + ++incr;
                                        break block20;
                                    }
                                    mapped1 = j;
                                } else if (value.hasMapping(j, index - 1)) {
                                    if (mapped0 != -1) {
                                        int n = index;
                                        rcolors[n] = rcolors[n] + ++incr;
                                        break block20;
                                    }
                                    mapped0 = j;
                                }
                            }
                            ++j;
                        }
                        if (mapped0 != mapped1) {
                            if (mapped0 == -1 || mapped1 == -1) {
                                ++incr;
                            } else if (colors[mapped0] != colors[mapped1]) {
                                ++incr;
                            }
                        }
                        int n = index;
                        rcolors[n] = rcolors[n] + incr;
                    }
                }
                ++index;
            }
            this._base.updateNumRColors(incr);
            if (incr <= 0) continue;
            changed = true;
        }
        return incr;
    }

    int update(RelationValue value, int[] colors, int[] rcolors) {
        int incr = 0;
        boolean changed = true;
        while (changed) {
            incr = 0;
            changed = false;
            int index = 1;
            while (index < colors.length) {
                int m1 = value.mapping(index);
                int m2 = value.mapping(index - 1);
                if (colors[index] + incr == colors[index - 1] && m1 != m2) {
                    if (Value.numbits(m1) != Value.numbits(m2)) {
                        ++incr;
                    } else if (Value.numbits(m1 ^ m2) != 2) {
                        ++incr;
                    } else if (rcolors[Value.maxbit(m1 & ~m2)] != rcolors[Value.maxbit(m2 & ~m1)]) {
                        ++incr;
                    }
                }
                int n = index++;
                colors[n] = colors[n] + incr;
            }
            this._base.updateNumColors(incr);
            incr = 0;
            int dmax = value.domainMax();
            index = 1;
            while (index < rcolors.length) {
                if (rcolors[index] + incr == rcolors[index - 1]) {
                    int extraCurr = -1;
                    int extraPrev = -1;
                    int j = 0;
                    while (j < dmax) {
                        if (value.hasMapping(j, index) != value.hasMapping(j, index - 1)) {
                            if (value.hasMapping(j, index)) {
                                if (extraCurr >= 0) {
                                    extraCurr = -2;
                                    break;
                                }
                                extraCurr = j;
                            } else {
                                if (extraPrev >= 0) {
                                    extraPrev = -2;
                                    break;
                                }
                                extraPrev = j;
                            }
                        }
                        ++j;
                    }
                    if (extraCurr == -2 || extraPrev == -2) {
                        ++incr;
                    } else if (extraCurr >= 0 || extraPrev >= 0) {
                        if (extraCurr < 0 || extraPrev < 0) {
                            ++incr;
                        } else if (colors[extraCurr] != colors[extraPrev]) {
                            ++incr;
                        }
                    }
                }
                int n = index++;
                rcolors[n] = rcolors[n] + incr;
            }
            this._base.updateNumRColors(incr);
            if (incr <= 0) continue;
            changed = true;
        }
        return incr;
    }

    void dependents(int index, SetValue effects, Coloring c) {
    }

    void dependents(ScalarValue index, SetValue effects, Coloring c) {
    }

    int[][] permutes(ScalarValue index, SetValue range, Coloring c) {
        return null;
    }

    int[][] permutes(int index, SetValue range, Coloring c) {
        return null;
    }

    int[][] permutes(int index1, int index2, SetValue range, Coloring c) {
        RelOrFuncValue rfv = (RelOrFuncValue)c.getValue();
        return null;
    }
}

