/*
 * Decompiled with CFR 0.152.
 */
package ladybug.selenum.isomorph;

import ladybug.engine.Scope;
import ladybug.engine.SetValue;
import ladybug.parse.RelationType;
import ladybug.parse.ScalarType;
import ladybug.selenum.isomorph.AtomicUpdater;
import ladybug.selenum.isomorph.ColorPolicy;
import ladybug.selenum.isomorph.ColorUpdater;
import ladybug.selenum.isomorph.Coloring;
import ladybug.selenum.isomorph.GlobalColoring;
import ladybug.selenum.isomorph.StructuralUpdater;
import ladybug.util.Partitioning;

public class StructuralPolicy
extends ColorPolicy {
    public StructuralPolicy(Scope scope) {
        super(scope);
    }

    public Coloring createColoring(SetValue domain) {
        return new GlobalColoring(domain, this._scope, null, (ColorPolicy)this);
    }

    public Coloring createColoring(SetValue domain, SetValue range) {
        return new GlobalColoring(domain, range, this._scope, null, this);
    }

    public Coloring createColoring(RelationType rt) {
        return this.createColoring(rt.domain().universe(this._scope), rt.range().universe(this._scope));
    }

    public Coloring extend(Coloring prevColoring, SetValue domain) {
        return new GlobalColoring(domain, this._scope, prevColoring, (ColorPolicy)this);
    }

    public Coloring extend(Coloring prevColoring, SetValue domain, SetValue range) {
        return new GlobalColoring(domain, range, this._scope, prevColoring, this);
    }

    public ColorUpdater chooseUpdater(Coloring base) {
        if (base.range() == null) {
            return new AtomicUpdater(base, base.domain());
        }
        if (!this.allowStructural(base)) {
            return new AtomicUpdater(base, base.domain(), base.range());
        }
        return new StructuralUpdater(base, base.domain(), base.range());
    }

    private boolean allowStructural(Coloring base) {
        ScalarType ran;
        ScalarType dom = base.baseType();
        if (dom.equiv(ran = base.rangeType())) {
            return false;
        }
        Coloring prev = base.getPrevColoring();
        if (prev == null) {
            return true;
        }
        Partitioning p = new Partitioning();
        Coloring c = prev;
        while (c != null) {
            if (c.range() != null && !(dom = c.baseType()).equiv(ran = c.rangeType())) {
                p.addElement(dom);
                p.addElement(ran);
                p.join(dom, ran);
            }
            c = c.getPrevColoring();
        }
        dom = base.baseType();
        ran = base.rangeType();
        return p.same(dom, ran) ^ true;
    }
}

