/*
 * Decompiled with CFR 0.152.
 */
package ladybug.selenum.isomorph;

import java.util.Enumeration;
import java.util.Vector;
import ladybug.engine.FunctionValue;
import ladybug.engine.RelationValue;
import ladybug.engine.ScalarValue;
import ladybug.engine.Scope;
import ladybug.engine.SetValue;
import ladybug.parse.RelationType;
import ladybug.parse.ScalarType;
import ladybug.parse.SetType;
import ladybug.parse.Tree;
import ladybug.selenum.isomorph.ColorPolicy;
import ladybug.selenum.isomorph.Coloring;

public class RelLocalColoring
extends Coloring {
    private int _numElems;
    private int _numColors;
    private int[] _colors;
    private int[] _elems;
    private int[] _coloredElems;
    private int _rnumElems;
    private int _rnumColors;
    private int[] _rcolors;
    private int[] _relems;
    private int[] _rcoloredElems;

    RelLocalColoring(RelationType rtype, Scope scope, Coloring prevColoring, ColorPolicy policy) {
        super(rtype, scope, prevColoring, policy);
        this._updater = policy.chooseUpdater(this);
        this.resetDomain(rtype.domain().universe(scope));
        this.resetRange(rtype.range().universe(scope));
        this.reset();
    }

    RelLocalColoring(SetValue domain, SetValue range, Scope scope, Coloring prevColoring, ColorPolicy policy) {
        super(domain, range, scope, prevColoring, policy);
        this._updater = policy.chooseUpdater(this);
        this.resetDomain(domain);
        this.resetRange(range);
        this.reset();
    }

    void updateNumColors(int addl) {
        this._numColors += addl;
        if (this.shared() != null) {
            this._rnumColors = this._numColors;
        }
    }

    void updateNumRColors(int addl) {
        this._rnumColors += addl;
        if (this.shared() != null) {
            this._numColors = this._rnumColors;
        }
    }

    int[] getColors(ScalarType type) {
        if (type.equiv(this.baseType())) {
            return this._colors;
        }
        if (type.equiv(this.rangeType())) {
            return this._rcolors;
        }
        return null;
    }

    boolean colors(ScalarType type) {
        return type.equiv(this.baseType()) || type.equiv(this.rangeType());
    }

    public void resetDomain(SetValue domain) {
        super.resetDomain(domain);
        this.allocDomain();
        this._updater.resetDomain(domain);
    }

    private void allocDomain() {
        SetValue useDomain = this.shared() == null ? this.domain() : this.shared();
        this._numElems = useDomain.card();
        this._elems = new int[(int)this.baseType().numValues(this._scope)];
        this._coloredElems = new int[this._numElems];
        int i = 0;
        while (i < this._elems.length) {
            this._elems[i] = -1;
            ++i;
        }
        i = 0;
        while (i < this._numElems) {
            this._coloredElems[i] = useDomain.nthElement(i + 1);
            this._elems[useDomain.nthElement((int)(i + 1))] = i;
            ++i;
        }
        this._colors = new int[this._numElems];
    }

    public void resetRange(SetValue range) {
        super.resetRange(range);
        if (this.shared() != null) {
            this.allocDomain();
            this._rcoloredElems = this._coloredElems;
            this._rnumElems = this._numElems;
            this._relems = this._elems;
            this._rcolors = this._colors;
            return;
        }
        this._rnumElems = range.card();
        this._relems = new int[(int)this.rangeType().numValues(this._scope)];
        this._rcoloredElems = new int[this._rnumElems];
        int i = 0;
        while (i < this._relems.length) {
            this._relems[i] = -1;
            ++i;
        }
        i = 0;
        while (i < this._rnumElems) {
            this._rcoloredElems[i] = range.nthElement(i + 1);
            this._relems[range.nthElement((int)(i + 1))] = i;
            ++i;
        }
        this._rcolors = new int[this._rnumElems];
        this._updater.resetRange(range);
    }

    public void reset() {
        this.resetColors();
    }

    public String dumpAllColors() {
        String s = String.valueOf(Tree.linesep()) + "Colorings:" + Tree.linesep();
        s = String.valueOf(s) + this.dumpAddlColors(new Vector());
        return s;
    }

    protected String dumpAddlColors(Vector dumpedDomains) {
        int i;
        int[] colors;
        String s = "";
        SetValue unColoredD = new SetValue(new SetType(this.baseType()), this.scope());
        if (this.shared() != null) {
            unColoredD.init(this.shared());
            Enumeration domains = dumpedDomains.elements();
            while (domains.hasMoreElements()) {
                SetValue sv = (SetValue)domains.nextElement();
                if (!this.baseType().includes(sv.elemType())) continue;
                unColoredD.diff(sv, unColoredD);
                if (unColoredD.isEmpty()) break;
            }
            if (!unColoredD.isEmpty()) {
                s = String.valueOf(s) + Tree.linesep() + this.baseType().getName() + ":" + Tree.linesep();
                int[] colors2 = new int[unColoredD.card()];
                this.coloring(unColoredD, colors2);
                int i2 = 0;
                while (i2 < colors2.length) {
                    s = String.valueOf(s) + "  " + this.baseType().getElementName(unColoredD.nthElement(i2 + 1)) + ":" + String.valueOf(colors2[i2] + dumpedDomains.size() * Coloring._coloringIncrement);
                    ++i2;
                }
                s = String.valueOf(s) + Tree.linesep();
                dumpedDomains.addElement(unColoredD);
            }
            if (this.getPrevColoring() != null) {
                s = String.valueOf(s) + this.getPrevColoring().dumpAddlColors(dumpedDomains);
            }
            return s;
        }
        SetValue unColoredR = new SetValue(new SetType(this.rangeType()), this.scope());
        unColoredD.init(this.domain());
        unColoredR.init(this.range());
        Enumeration domains = dumpedDomains.elements();
        while (domains.hasMoreElements()) {
            SetValue sv = (SetValue)domains.nextElement();
            if (this.baseType().includes(sv.elemType())) {
                unColoredD.diff(sv, unColoredD);
            }
            if (!this.rangeType().includes(sv.elemType())) continue;
            unColoredR.diff(sv, unColoredR);
        }
        if (!unColoredD.isEmpty()) {
            s = String.valueOf(s) + Tree.linesep() + this.baseType().getName() + ":" + Tree.linesep();
            colors = new int[unColoredD.card()];
            this.coloring(unColoredD, colors);
            i = 0;
            while (i < colors.length) {
                s = String.valueOf(s) + "  " + this.baseType().getElementName(unColoredD.nthElement(i + 1)) + ":" + String.valueOf(colors[i] + dumpedDomains.size() * Coloring._coloringIncrement);
                ++i;
            }
            s = String.valueOf(s) + Tree.linesep();
            dumpedDomains.addElement(unColoredD);
        }
        if (!unColoredR.isEmpty()) {
            s = String.valueOf(s) + Tree.linesep() + this.rangeType().getName() + ":" + Tree.linesep();
            colors = new int[unColoredR.card()];
            this.coloring(unColoredR, colors);
            i = 0;
            while (i < colors.length) {
                s = String.valueOf(s) + "  " + this.rangeType().getElementName(unColoredR.nthElement(i + 1)) + ":" + String.valueOf(colors[i] + dumpedDomains.size() * Coloring._coloringIncrement);
                ++i;
            }
            s = String.valueOf(s) + Tree.linesep();
            dumpedDomains.addElement(unColoredR);
        }
        if (this.getPrevColoring() != null) {
            s = String.valueOf(s) + this.getPrevColoring().dumpAddlColors(dumpedDomains);
        }
        return s;
    }

    public String dumpColors() {
        String s = String.valueOf(Tree.linesep()) + this._baseType.getName() + ":" + Tree.linesep();
        int[] colors = new int[this._domain.card()];
        this.coloring(this._domain, colors);
        int i = 0;
        while (i < colors.length) {
            s = String.valueOf(s) + "  " + this._baseType.getElementName(this._domain.nthElement(i + 1)) + ":" + String.valueOf(colors[i]);
            ++i;
        }
        s = String.valueOf(s) + Tree.linesep();
        if (this.shared() != null) {
            return s;
        }
        s = String.valueOf(s) + this._rangeType.getName() + ":" + Tree.linesep();
        colors = new int[this._range.card()];
        this.coloring(this._range, colors);
        int i2 = 0;
        while (i2 < colors.length) {
            s = String.valueOf(s) + "  " + this._rangeType.getElementName(this._range.nthElement(i2 + 1)) + ":" + String.valueOf(colors[i2]);
            ++i2;
        }
        s = String.valueOf(s) + Tree.linesep();
        return s;
    }

    public int color(ScalarValue index) {
        Coloring c = this;
        int level = 0;
        while (c != null) {
            if (c.baseType().includes(index.getType()) && c.domain().hasElement(index)) {
                return c.directColor(index) + level * Coloring._coloringIncrement;
            }
            c = c.getPrevColoring();
            ++level;
        }
        return 0;
    }

    int color(int index) {
        if (this._elems[index] < 0) {
            return 0;
        }
        return this._colors[this._elems[index]];
    }

    public int coloring(ScalarType domainType, int[] colors) {
        return this.coloring(domainType.universe(this._scope), colors);
    }

    public int coloring(SetValue domain, int[] colors) {
        if (domain.elemType().equiv(this.baseType())) {
            int numColors;
            if (this.domain().contains(domain)) {
                return this.directColoring(domain, 0, colors);
            }
            if (this.getPrevColoring() != null) {
                numColors = this.getPrevColoring().coloring(domain, colors);
            } else {
                int i = 0;
                while (i < colors.length) {
                    colors[i] = 0;
                    ++i;
                }
                numColors = 1;
            }
            if (domain.overlaps(this._domain)) {
                return this.directColoring(domain, numColors, colors);
            }
            return numColors;
        }
        if (this.range() != null && domain.elemType().equiv(this.rangeType())) {
            int numColors;
            if (this.range().contains(domain)) {
                return this.directColoring(domain, 0, colors);
            }
            if (this.getPrevColoring() != null) {
                numColors = this.getPrevColoring().coloring(domain, colors);
            } else {
                int i = 0;
                while (i < colors.length) {
                    colors[i] = 0;
                    ++i;
                }
                numColors = 1;
            }
            if (domain.overlaps(this.range())) {
                return this.directColoring(domain, numColors, colors);
            }
            return numColors;
        }
        if (this.getPrevColoring() != null) {
            return this.getPrevColoring().coloring(domain, colors);
        }
        int i = 0;
        while (i < colors.length) {
            colors[i] = 0;
            ++i;
        }
        return 1;
    }

    public int distinguish(ScalarValue elem) {
        return this.distinguish((ScalarType)elem.getType(), elem.getAdjValue());
    }

    public int distinguish(ScalarType stype, int elem) {
        if (stype.equiv(this.baseType())) {
            int index = this._elems[elem];
            if (index < 0) {
                return 0;
            }
            int incr = 0;
            if (index + 1 < this._colors.length && this._colors[index + 1] == this._colors[index]) {
                ++incr;
            }
            if (index > 0 && this._colors[index - 1] == this._colors[index]) {
                int n = index;
                this._colors[n] = this._colors[n] + 1;
                ++incr;
            }
            if (incr > 0) {
                int i = index + 1;
                while (i < this._colors.length) {
                    int n = i++;
                    this._colors[n] = this._colors[n] + incr;
                }
                this._numColors += incr;
                if (this.shared() != null) {
                    this._rnumColors = this._numColors;
                }
            }
            return incr;
        }
        if (this.range() != null && stype.equiv(this.rangeType())) {
            int index = this._relems[elem];
            if (index < 0) {
                return 0;
            }
            int incr = 0;
            if (index + 1 < this._rcolors.length && this._rcolors[index + 1] == this._rcolors[index]) {
                ++incr;
            }
            if (index > 0 && this._rcolors[index - 1] == this._rcolors[index]) {
                int n = index;
                this._rcolors[n] = this._rcolors[n] + 1;
                ++incr;
            }
            if (incr > 0) {
                int i = index + 1;
                while (i < this._rcolors.length) {
                    int n = i++;
                    this._rcolors[n] = this._rcolors[n] + incr;
                }
                this._rnumColors += incr;
            }
            return incr;
        }
        return 0;
    }

    public int distinguish(SetValue value) {
        int incr = 0;
        if (value.elemType().equiv(this.baseType())) {
            int index = 1;
            while (index < this._numElems) {
                if (this._colors[index] + incr == this._colors[index - 1] && value.hasElement(this._coloredElems[index]) != value.hasElement(this._coloredElems[index - 1])) {
                    ++incr;
                }
                int n = index++;
                this._colors[n] = this._colors[n] + incr;
            }
            this._numColors += incr;
            if (this.shared() != null) {
                this._rnumColors = this._numColors;
            }
            return incr;
        }
        if (this.range() != null && value.elemType().equiv(this.rangeType())) {
            int index = 1;
            while (index < this._rnumElems) {
                if (this._rcolors[index] + incr == this._rcolors[index - 1] && value.hasElement(this._rcoloredElems[index]) != value.hasElement(this._rcoloredElems[index - 1])) {
                    ++incr;
                }
                int n = index++;
                this._rcolors[n] = this._rcolors[n] + incr;
            }
            this._rnumColors += incr;
            return incr;
        }
        return 0;
    }

    public void updateColoring(ScalarValue value) {
        super.updateColoring(value);
        this.resetColors();
        this._updater.update(value, this._colors);
    }

    public void updateColoring(SetValue value) {
        super.updateColoring(value);
        this.resetColors();
        this._updater.update(value, this._colors);
    }

    public void updateColoring(FunctionValue value) {
        super.updateColoring(value);
        this.resetColors();
        this._updater.update(value, this._colors, this._rcolors);
    }

    public void updateColoring(RelationValue value) {
        super.updateColoring(value);
        this.resetColors();
        this._updater.update(value, this._colors, this._rcolors);
    }

    private void resetColors() {
        int i;
        if (this._prevRelatedDomain == null) {
            i = 0;
            while (i < this._numElems) {
                this._colors[i] = 0;
                ++i;
            }
            this._numColors = 1;
        } else {
            this._numColors = this._prevRelatedDomain.coloring(this.domain(), this._colors);
        }
        if (this.range() == null) {
            return;
        }
        if (this._prevRelatedRange == null) {
            i = 0;
            while (i < this._rnumElems) {
                this._rcolors[i] = 0;
                ++i;
            }
            this._rnumColors = 1;
        } else {
            this._rnumColors = this._prevRelatedRange.coloring(this.range(), this._rcolors);
        }
    }

    protected int directColor(ScalarValue elem) {
        int index = this._elems[elem.getAdjValue()];
        if (index < 0) {
            return 0;
        }
        return this._colors[this._elems[index]];
    }

    private int directColoring(SetValue domain, int offset, int[] colors) {
        if (domain.elemType().equiv(this.baseType())) {
            int i = 0;
            int j = 0;
            while (i <= domain.maxElem()) {
                if (domain.hasElement(i)) {
                    if (this._elems[i] >= 0) {
                        colors[j] = this._colors[this._elems[i]] + offset;
                    }
                    ++j;
                }
                ++i;
            }
            return this._numColors + offset;
        }
        int i = 0;
        int j = 0;
        while (i <= domain.maxElem()) {
            if (domain.hasElement(i)) {
                if (this._relems[i] >= 0) {
                    colors[j] = this._rcolors[this._relems[i]] + offset;
                }
                ++j;
            }
            ++i;
        }
        return this._rnumColors + offset;
    }
}

