/*
 * Decompiled with CFR 0.152.
 */
package ladybug.selenum.isomorph;

import java.util.Enumeration;
import java.util.Vector;
import ladybug.engine.FunctionValue;
import ladybug.engine.RelationValue;
import ladybug.engine.ScalarValue;
import ladybug.engine.Scope;
import ladybug.engine.SetValue;
import ladybug.parse.ScalarType;
import ladybug.parse.SetType;
import ladybug.parse.Tree;
import ladybug.selenum.isomorph.ColorPolicy;
import ladybug.selenum.isomorph.Coloring;

public class LocalColoring
extends Coloring {
    private int _numElems;
    private int _numColors;
    private int[] _colors;
    private int[] _elems;
    private int[] _coloredElems;

    LocalColoring(SetValue domain, Scope scope, Coloring prevColoring, ColorPolicy policy) {
        super(domain, scope, prevColoring, policy);
        this._updater = policy.chooseUpdater(this);
        this.resetDomain(domain);
        this.reset();
    }

    LocalColoring(ScalarType type, Scope scope, Coloring prevColoring, ColorPolicy policy) {
        this(type.universe(scope), scope, prevColoring, policy);
    }

    LocalColoring(SetType stype, Scope scope, Coloring prevColoring, ColorPolicy policy) {
        this(stype.elemType().universe(scope), scope, prevColoring, policy);
    }

    void updateNumColors(int addl) {
        this._numColors += addl;
    }

    int[] getColors(ScalarType type) {
        if (type.equiv(this.baseType())) {
            return this._colors;
        }
        return null;
    }

    boolean colors(ScalarType type) {
        return type.equiv(this.baseType());
    }

    public void resetDomain(SetValue domain) {
        super.resetDomain(domain);
        this._numElems = domain.card();
        this._elems = new int[(int)this.baseType().numValues(this._scope)];
        this._coloredElems = new int[this._numElems];
        int i = 0;
        while (i < this._elems.length) {
            this._elems[i] = -1;
            ++i;
        }
        int i2 = 0;
        while (i2 < this._numElems) {
            this._coloredElems[i2] = domain.nthElement(i2 + 1);
            this._elems[domain.nthElement((int)(i2 + 1))] = i2;
            ++i2;
        }
        this._colors = new int[this._numElems];
        this._updater.resetDomain(domain);
    }

    public void reset() {
        this.resetColors();
    }

    public String dumpAllColors() {
        String s = String.valueOf(Tree.linesep()) + "Colorings:" + Tree.linesep();
        s = String.valueOf(s) + this.dumpAddlColors(new Vector());
        return s;
    }

    protected String dumpAddlColors(Vector dumpedDomains) {
        String s = "";
        SetValue newElems = new SetValue(new SetType(this._baseType), this._scope);
        newElems.init(this._domain);
        Enumeration domains = dumpedDomains.elements();
        while (domains.hasMoreElements()) {
            SetValue sv = (SetValue)domains.nextElement();
            if (!this._baseType.includes(sv.elemType())) continue;
            if (sv.contains(newElems)) {
                newElems.init();
                break;
            }
            newElems.diff(sv, newElems);
            if (newElems.isEmpty()) break;
        }
        if (!newElems.isEmpty()) {
            s = String.valueOf(Tree.linesep()) + this._baseType.getName() + ":" + Tree.linesep();
            int[] colors = new int[newElems.card()];
            this.coloring(newElems, colors);
            int i = 0;
            while (i < colors.length) {
                s = String.valueOf(s) + "  " + this._baseType.getElementName(newElems.nthElement(i + 1)) + ":" + String.valueOf(colors[i] + dumpedDomains.size() * Coloring._coloringIncrement);
                ++i;
            }
            s = String.valueOf(s) + Tree.linesep();
            dumpedDomains.addElement(newElems);
        }
        if (this.getPrevColoring() != null) {
            s = String.valueOf(s) + this.getPrevColoring().dumpAddlColors(dumpedDomains);
        }
        return s;
    }

    public String dumpColors() {
        String s = String.valueOf(Tree.linesep()) + this._baseType.getName() + ":" + Tree.linesep();
        int[] colors = new int[this._domain.card()];
        this.coloring(this._domain, colors);
        int i = 0;
        while (i < colors.length) {
            s = String.valueOf(s) + "  " + this._baseType.getElementName(this._domain.nthElement(i + 1)) + ":" + String.valueOf(colors[i]);
            ++i;
        }
        s = String.valueOf(s) + Tree.linesep();
        return s;
    }

    public int color(ScalarValue index) {
        Coloring c = this;
        int level = 0;
        while (c != null) {
            if (c.baseType().includes(index.getType()) && c.domain().hasElement(index)) {
                return c.directColor(index) + level * Coloring._coloringIncrement;
            }
            c = c.getPrevColoring();
            ++level;
        }
        return 0;
    }

    int color(int index) {
        if (this._elems[index] < 0) {
            return 0;
        }
        return this._colors[this._elems[index]];
    }

    public int coloring(ScalarType domainType, int[] colors) {
        return this.coloring(domainType.universe(this._scope), colors);
    }

    public int coloring(SetValue domain, int[] colors) {
        int numColors;
        if (!domain.elemType().equiv(this.baseType())) {
            if (this.getPrevColoring() != null) {
                return this.getPrevColoring().coloring(domain, colors);
            }
            int i = 0;
            while (i < colors.length) {
                colors[i] = 0;
                ++i;
            }
            return 1;
        }
        if (this.domain().contains(domain)) {
            return this.directColoring(domain, 0, colors);
        }
        if (this.getPrevColoring() != null) {
            numColors = this.getPrevColoring().coloring(domain, colors);
        } else {
            int i = 0;
            while (i < colors.length) {
                colors[i] = 0;
                ++i;
            }
            numColors = 1;
        }
        if (domain.overlaps(this._domain)) {
            return this.directColoring(domain, numColors, colors);
        }
        return numColors;
    }

    public int distinguish(ScalarValue elem) {
        if (!elem.getType().equiv(this.baseType())) {
            return 0;
        }
        return this.distinguish(elem.getAdjValue());
    }

    public int distinguish(ScalarType stype, int elem) {
        if (!stype.equiv(this.baseType())) {
            return 0;
        }
        return this.distinguish(elem);
    }

    private int distinguish(int elem) {
        int index = this._elems[elem];
        if (index < 0) {
            return 0;
        }
        int incr = 0;
        if (index + 1 < this._colors.length && this._colors[index + 1] == this._colors[index]) {
            ++incr;
        }
        if (index > 0 && this._colors[index - 1] == this._colors[index]) {
            int n = index;
            this._colors[n] = this._colors[n] + 1;
            ++incr;
        }
        if (incr > 0) {
            int i = index + 1;
            while (i < this._colors.length) {
                int n = i++;
                this._colors[n] = this._colors[n] + incr;
            }
            this._numColors += incr;
        }
        return incr;
    }

    public int distinguish(SetValue value) {
        int incr = 0;
        int index = 1;
        while (index < this._numElems) {
            if (this._colors[index] + incr == this._colors[index - 1] && value.hasElement(this._coloredElems[index]) != value.hasElement(this._coloredElems[index - 1])) {
                ++incr;
            }
            int n = index++;
            this._colors[n] = this._colors[n] + incr;
        }
        this._numColors += incr;
        return incr;
    }

    public void updateColoring(ScalarValue value) {
        super.updateColoring(value);
        this.resetColors();
        this._updater.update(value, this._colors);
    }

    public void updateColoring(SetValue value) {
        super.updateColoring(value);
        this.resetColors();
        this._updater.update(value, this._colors);
    }

    public void updateColoring(FunctionValue value) {
        super.updateColoring(value);
        this.resetColors();
        this._updater.update(value, this._colors, null);
    }

    public void updateColoring(RelationValue value) {
        super.updateColoring(value);
        this.resetColors();
        this._updater.update(value, this._colors, null);
    }

    private void resetColors() {
        if (this._prevRelatedDomain == null) {
            int i = 0;
            while (i < this._numElems) {
                this._colors[i] = 0;
                ++i;
            }
            this._numColors = 1;
            return;
        }
        this._numColors = this._prevRelatedDomain.coloring(this._domain, this._colors);
    }

    protected int directColor(ScalarValue elem) {
        int index = this._elems[elem.getAdjValue()];
        if (index < 0) {
            return 0;
        }
        return this._colors[this._elems[index]];
    }

    private int directColoring(SetValue domain, int offset, int[] colors) {
        int i = 0;
        int j = 0;
        while (i <= domain.maxElem()) {
            if (domain.hasElement(i)) {
                if (this._elems[i] >= 0) {
                    colors[j] = this._colors[this._elems[i]] + offset;
                }
                ++j;
            }
            ++i;
        }
        return this._numColors + offset;
    }
}

