/*
 * Decompiled with CFR 0.152.
 */
package ladybug.selenum.isomorph;

import ladybug.engine.FunctionValue;
import ladybug.engine.RelOrFuncValue;
import ladybug.engine.RelationValue;
import ladybug.engine.ScalarValue;
import ladybug.engine.Scope;
import ladybug.engine.SetValue;
import ladybug.engine.Value;
import ladybug.parse.RelationType;
import ladybug.parse.ScalarType;
import ladybug.parse.SetType;
import ladybug.parse.Tree;
import ladybug.selenum.isomorph.ColorFrame;
import ladybug.selenum.isomorph.ColorFrameWork;
import ladybug.selenum.isomorph.ColorPolicy;
import ladybug.selenum.isomorph.ColorUpdater;
import ladybug.selenum.isomorph.Coloring;

public class GlobalColoring
extends Coloring {
    private int[][] colorings;
    private int[] baseColors;
    private int[] rangeColors;
    private boolean anyDependent;
    private ColorFrameWork framework;
    private ScalarType[] types;
    private Coloring[] lastColors;
    private SetValue[] universes;

    GlobalColoring(SetValue domain, Scope scope, Coloring prevColoring, ColorPolicy policy) {
        super(domain, scope, prevColoring, policy);
        this.initColors();
    }

    GlobalColoring(ScalarType type, Scope scope, Coloring prevColoring, ColorPolicy policy) {
        super(type, scope, prevColoring, policy);
        this.initColors();
    }

    GlobalColoring(SetType stype, Scope scope, Coloring prevColoring, ColorPolicy policy) {
        super(stype, scope, prevColoring, policy);
        this.initColors();
    }

    GlobalColoring(RelationType rtype, Scope scope, Coloring prevColoring, ColorPolicy policy) {
        super(rtype, scope, prevColoring, policy);
        this.initColors();
    }

    GlobalColoring(SetValue domain, SetValue range, Scope scope, Coloring prevColoring, ColorPolicy policy) {
        super(domain, range, scope, prevColoring, policy);
        this.initColors();
    }

    private void initColors() {
        this.colorings = null;
        this.types = null;
        this.lastColors = null;
        this.universes = null;
        this.anyDependent = false;
        this.framework = null;
        this.buildColorings(this);
        this.baseColors = this.getColors(this.baseType());
        this.rangeColors = (int[])(this.range() != null ? this.getColors(this.rangeType()) : null);
        this._updater = this._policy.chooseUpdater(this);
    }

    private void buildColorings(Coloring c) {
        ColorUpdater u;
        if (c.getPrevColoring() != null) {
            this.buildColorings(c.getPrevColoring());
        }
        if ((u = c.updater()) != null && !u.independent()) {
            this.anyDependent = true;
        }
        this.addType(c, c.baseType());
        if (c.range() != null) {
            this.addType(c, c.rangeType());
        }
    }

    private void addType(Coloring c, ScalarType st) {
        int i;
        if (this.types == null) {
            this.types = new ScalarType[1];
            this.types[0] = st;
            this.colorings = new int[1][];
            this.colorings[0] = new int[(int)st.numValues(this._scope)];
            int j = 0;
            while (j < this.colorings[0].length) {
                this.colorings[0][j] = 0;
                ++j;
            }
            this.lastColors = new Coloring[1];
            this.universes = new SetValue[1];
            this.universes[0] = st.universe(this._scope);
            i = 0;
        } else {
            i = 0;
            while (i < this.types.length) {
                if (this.types[i].equiv(st)) break;
                ++i;
            }
            if (i == this.types.length) {
                ScalarType[] oldTypes = this.types;
                this.types = new ScalarType[i + 1];
                this.types[i] = st;
                int[][] oldColorings = this.colorings;
                this.colorings = new int[i + 1][];
                this.colorings[i] = new int[(int)st.numValues(this._scope)];
                int j = 0;
                while (j < this.colorings[i].length) {
                    this.colorings[i][j] = 0;
                    ++j;
                }
                Coloring[] oldColors = this.lastColors;
                this.lastColors = new Coloring[i + 1];
                SetValue[] oldUnivs = this.universes;
                this.universes = new SetValue[i + 1];
                j = 0;
                while (j < i) {
                    this.types[j] = oldTypes[j];
                    this.colorings[j] = oldColorings[j];
                    this.lastColors[j] = oldColors[j];
                    this.universes[j] = oldUnivs[j];
                    ++j;
                }
                this.universes[i] = st.universe(this._scope);
            }
        }
        if (c != this) {
            this.lastColors[i] = c;
        }
    }

    private ColorFrameWork getFramework() {
        if (this.anyDependent && this.framework == null) {
            this.framework = new ColorFrameWork(this);
            this.buildFramework(this);
        }
        return this.framework;
    }

    private void buildFramework(Coloring c) {
        Value val = c.getValue();
        if (val instanceof RelOrFuncValue) {
            ColorFrame cf = new ColorFrame((RelOrFuncValue)val, true, c, c.updater());
            this.framework.addFrame(cf);
            cf = new ColorFrame((RelOrFuncValue)val, false, c, c.updater());
            this.framework.addFrame(cf);
        }
        if (c.getPrevColoring() != null) {
            this.buildFramework(c.getPrevColoring());
        }
    }

    int[] getColors(ScalarType type) {
        if (this.types == null) {
            return null;
        }
        int i = 0;
        while (i < this.types.length) {
            if (this.types[i].equiv(type)) {
                return this.colorings[i];
            }
            ++i;
        }
        return null;
    }

    public void reset() {
        this.resetColors();
    }

    private void resetColors() {
        if (this.types == null) {
            return;
        }
        int i = 0;
        while (i < this.types.length) {
            if (this.lastColors[i] != null) {
                this.lastColors[i].coloring(this.universes[i], this.colorings[i]);
            } else {
                int j = 0;
                while (j < this.colorings[i].length) {
                    this.colorings[i][j] = 0;
                    ++j;
                }
            }
            ++i;
        }
    }

    public String dumpAllColors() {
        return this.dumpColors();
    }

    public String dumpColors() {
        if (this.types == null) {
            return "";
        }
        String s = "all colors";
        int i = 0;
        while (i < this.types.length) {
            s = String.valueOf(s) + Tree.linesep() + this.types[i].getName() + ":" + Tree.linesep();
            int j = 0;
            while (j < this.colorings[i].length) {
                s = String.valueOf(s) + "  " + this.types[i].getElementName(j) + ":" + String.valueOf(this.colorings[i][j]);
                ++j;
            }
            s = String.valueOf(s) + Tree.linesep();
            ++i;
        }
        return s;
    }

    public boolean colors(ScalarType type) {
        if (this.types == null) {
            return false;
        }
        int i = 0;
        while (i < this.types.length) {
            if (this.types[i].equiv(type)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public int distinguish(ScalarValue elem) {
        if (this.types == null) {
            return 0;
        }
        ScalarType domainType = (ScalarType)elem.getType();
        return this.distinguish(domainType, elem.getValue());
    }

    public int distinguish(int elem) {
        return this.distinguish(this.baseType(), elem);
    }

    public int distinguish(ScalarType domainType, int elem) {
        if (this.types == null) {
            return 0;
        }
        int i = 0;
        while (i < this.types.length) {
            if (this.types[i].equiv(domainType)) break;
            ++i;
        }
        if (i == this.types.length) {
            return 0;
        }
        int incr = 0;
        int index = elem;
        if (index + 1 < this.colorings[i].length && this.colorings[i][index + 1] == this.colorings[i][index]) {
            ++incr;
        }
        if (index > 0 && this.colorings[i][index - 1] == this.colorings[i][index]) {
            int[] nArray = this.colorings[i];
            int n = index;
            nArray[n] = nArray[n] + 1;
            ++incr;
        }
        if (incr > 0) {
            int j = index + 1;
            while (j < this.colorings[i].length) {
                int[] nArray = this.colorings[i];
                int n = j++;
                nArray[n] = nArray[n] + incr;
            }
            if (this.anyDependent) {
                this.getFramework().colorUpdated(this.baseType());
            }
        }
        return incr;
    }

    public int distinguish(SetValue value) {
        if (this.types == null) {
            return 0;
        }
        ScalarType domainType = ((SetType)value.getType()).elemType();
        int i = 0;
        while (i < this.types.length) {
            if (this.types[i].equiv(domainType)) break;
            ++i;
        }
        if (i == this.types.length) {
            return 0;
        }
        int incr = 0;
        int index = 1;
        while (index < this.colorings[i].length) {
            if (this.colorings[i][index] + incr == this.colorings[i][index - 1] && value.hasElement(index) != value.hasElement(index - 1)) {
                ++incr;
            }
            int[] nArray = this.colorings[i];
            int n = index++;
            nArray[n] = nArray[n] + incr;
        }
        if (incr > 0 && this.anyDependent) {
            this.getFramework().colorUpdated(this.baseType());
        }
        return incr;
    }

    public void updateColoring(ScalarValue value) {
        super.updateColoring(value);
        this.resetColors();
        if (this._updater.update(value, this.baseColors) > 0 && this.anyDependent) {
            this.getFramework().colorUpdated(this.baseType());
        }
    }

    public void updateColoring(SetValue value) {
        super.updateColoring(value);
        this.resetColors();
        if (this._updater.update(value, this.baseColors) > 0 && this.anyDependent) {
            this.getFramework().colorUpdated(this.baseType());
        }
    }

    public void updateColoring(FunctionValue value) {
        super.updateColoring(value);
        this.resetColors();
        if (this._updater.update(value, this.baseColors, this.rangeColors) > 0 && this.anyDependent) {
            this.getFramework().colorUpdated(this.baseType());
            this.getFramework().colorUpdated(this.rangeType());
        }
    }

    public void updateColoring(RelationValue value) {
        super.updateColoring(value);
        this.resetColors();
        if (this._updater.update(value, this.baseColors, this.rangeColors) > 0 && this.anyDependent) {
            this.getFramework().colorUpdated(this.baseType());
            this.getFramework().colorUpdated(this.rangeType());
        }
    }

    public int color(ScalarValue index) {
        return this.directColor(index);
    }

    int color(int index) {
        if (this.types == null) {
            return 0;
        }
        ScalarType st = this.rangeType();
        int i = 0;
        while (i < this.types.length) {
            if (this.types[i].equiv(st)) {
                return this.colorings[i][index];
            }
            ++i;
        }
        return 0;
    }

    protected int directColor(ScalarValue index) {
        if (this.types == null) {
            return 0;
        }
        ScalarType st = (ScalarType)index.getType();
        int i = 0;
        while (i < this.types.length) {
            if (this.types[i].equiv(st)) {
                return this.colorings[i][index.getValue()];
            }
            ++i;
        }
        return 0;
    }

    public int coloring(ScalarType domainType, int[] colors) {
        if (this.types == null) {
            int i = 0;
            while (i < colors.length) {
                colors[i] = 0;
                ++i;
            }
            return 1;
        }
        int i = 0;
        while (i < this.types.length) {
            if (this.types[i].equiv(domainType)) {
                int nc = 1;
                colors[0] = this.colorings[i][0];
                int j = 1;
                while (j < colors.length) {
                    colors[j] = this.colorings[i][j];
                    if (colors[j] != colors[j - 1]) {
                        ++nc;
                    }
                    ++j;
                }
                return nc;
            }
            ++i;
        }
        i = 0;
        while (i < colors.length) {
            colors[i] = 0;
            ++i;
        }
        return 1;
    }

    public int coloring(SetValue domain, int[] colors) {
        ScalarType domainType = ((SetType)domain.getType()).elemType();
        if (this.types == null) {
            int i = 0;
            while (i < colors.length) {
                colors[i] = 0;
                ++i;
            }
            return 1;
        }
        int i = 0;
        while (i < this.types.length) {
            if (this.types[i].equiv(domainType)) {
                int nc = 1;
                int x = 0;
                int j = 0;
                while (j < this.colorings[i].length) {
                    if (domain.hasElement(j)) {
                        colors[x] = this.colorings[i][j];
                        if (x > 0 && colors[x] != colors[x - 1]) {
                            ++nc;
                        }
                        ++x;
                    }
                    ++j;
                }
                return nc;
            }
            ++i;
        }
        i = 0;
        while (i < colors.length) {
            colors[i] = 0;
            ++i;
        }
        return 1;
    }
}

