/*
 * Decompiled with CFR 0.152.
 */
package ladybug.selenum.isomorph;

import java.util.Vector;
import ladybug.engine.FunctionValue;
import ladybug.engine.RelationValue;
import ladybug.engine.ScalarValue;
import ladybug.engine.Scope;
import ladybug.engine.SetValue;
import ladybug.engine.Value;
import ladybug.parse.RelationType;
import ladybug.parse.ScalarType;
import ladybug.parse.SetType;
import ladybug.selenum.isomorph.ColorPolicy;
import ladybug.selenum.isomorph.ColorUpdater;

public abstract class Coloring {
    protected static int _coloringIncrement = 0;
    protected ScalarType _baseType;
    protected SetValue _domain;
    protected SetValue _range;
    protected SetValue _shared;
    protected ScalarType _rangeType;
    protected Coloring _prevRelatedDomain;
    protected Coloring _prevRelatedRange;
    protected ColorUpdater _updater;
    protected ColorPolicy _policy;
    protected int _prevRelatedIncrement;
    protected Scope _scope;
    private Coloring _prevColor;
    private Value _value;

    protected Coloring(SetValue domain, Scope scope, Coloring prevColoring, ColorPolicy policy) {
        this._domain = domain;
        this._baseType = domain.elemType();
        this._scope = scope;
        this._prevColor = prevColoring;
        this._policy = policy;
        this._range = null;
        this._shared = null;
        this.checkRelatedDomain();
        this._prevRelatedRange = null;
    }

    protected Coloring(ScalarType type, Scope scope, Coloring prevColoring, ColorPolicy policy) {
        this(type.universe(scope), scope, prevColoring, policy);
    }

    protected Coloring(SetType stype, Scope scope, Coloring prevColoring, ColorPolicy policy) {
        this(stype.elemType().universe(scope), scope, prevColoring, policy);
    }

    protected Coloring(RelationType rtype, Scope scope, Coloring prevColoring, ColorPolicy policy) {
        this(rtype.domain().universe(scope), rtype.range().universe(scope), scope, prevColoring, policy);
    }

    protected Coloring(SetValue domain, SetValue range, Scope scope, Coloring prevColoring, ColorPolicy policy) {
        this._domain = domain;
        this._baseType = this._domain.elemType();
        this._scope = scope;
        this._prevColor = prevColoring;
        this._policy = policy;
        this._range = range;
        this._rangeType = this._range.elemType();
        if (this._rangeType.equiv(this._baseType)) {
            this._shared = new SetValue(new SetType(this._baseType), this.scope());
            this._range.union(this._domain, this._shared);
        } else {
            this._shared = null;
        }
        this.checkRelatedDomain();
        this.checkRelatedRange();
    }

    public Coloring extend(SetValue domain) {
        return this._policy.extend(this, domain);
    }

    public Coloring extend(SetValue domain, SetValue range) {
        return this._policy.extend(this, domain, range);
    }

    public ScalarType baseType() {
        return this._baseType;
    }

    public SetValue domain() {
        return this._domain;
    }

    public SetValue range() {
        return this._range;
    }

    public ScalarType rangeType() {
        return this._rangeType;
    }

    public SetValue shared() {
        return this._shared;
    }

    public Scope scope() {
        return this._scope;
    }

    public ColorUpdater updater() {
        return this._updater;
    }

    void updateNumColors(int addl) {
    }

    void updateNumRColors(int addl) {
    }

    abstract int[] getColors(ScalarType var1);

    abstract boolean colors(ScalarType var1);

    public Coloring findRelatedColoring(SetValue domain) {
        Coloring c = this;
        while (c != null) {
            if (c.colors(this.baseType())) {
                return c;
            }
            if (this._range != null && c.colors(this.rangeType())) {
                return c;
            }
            c = c._prevColor;
        }
        return null;
    }

    private void checkRelatedDomain() {
        this._prevRelatedDomain = null;
        this._prevRelatedIncrement = 0;
        int level = 0;
        Coloring c = this._prevColor;
        while (c != null) {
            if (c.colors(this.baseType())) {
                this._prevRelatedDomain = c;
                this._prevRelatedIncrement = level * _coloringIncrement;
                return;
            }
            ++level;
            c = c._prevColor;
        }
    }

    private void checkRelatedRange() {
        this._prevRelatedRange = null;
        this._prevRelatedIncrement = 0;
        int level = 0;
        Coloring c = this._prevColor;
        while (c != null) {
            if (c.colors(this.rangeType())) {
                this._prevRelatedRange = c;
                this._prevRelatedIncrement = level * _coloringIncrement;
                return;
            }
            ++level;
            c = c._prevColor;
        }
    }

    public abstract String dumpAllColors();

    public abstract String dumpColors();

    protected String dumpAddlColors(Vector others) {
        return "Unsupported";
    }

    public void resetDomain(SetValue domain) {
        this._domain = domain;
        if (this._shared != null) {
            this._domain.union(this._range, this._shared);
        }
        this.checkRelatedDomain();
    }

    public void resetRange(SetValue range) {
        this._range = range;
        if (this._shared != null) {
            this._domain.union(this._range, this._shared);
        }
        this.checkRelatedDomain();
    }

    public abstract void reset();

    public abstract int distinguish(ScalarValue var1);

    public abstract int distinguish(ScalarType var1, int var2);

    public abstract int distinguish(SetValue var1);

    public void updateColoring(ScalarValue value) {
        this._value = value;
    }

    public void updateColoring(SetValue value) {
        this._value = value;
    }

    public void updateColoring(FunctionValue value) {
        this._value = value;
    }

    public void updateColoring(RelationValue value) {
        this._value = value;
    }

    public abstract int color(ScalarValue var1);

    abstract int color(int var1);

    protected abstract int directColor(ScalarValue var1);

    public abstract int coloring(ScalarType var1, int[] var2);

    public abstract int coloring(SetValue var1, int[] var2);

    public void dependents(ScalarValue index, SetValue effects) {
        if (!this.baseType().includes(index.getType())) {
            if (this.getPrevColoring() == null) {
                effects.init();
            } else {
                this.getPrevColoring().dependents(index, effects);
            }
            return;
        }
        if (this._updater.independent()) {
            effects.init();
            return;
        }
        this._updater.dependents(index.getValue(), effects, this);
    }

    public void dependents(int index, SetValue effects) {
        if (this._updater.independent()) {
            effects.init();
            return;
        }
        this._updater.dependents(index, effects, this);
    }

    public int[][] permutes(ScalarValue index1, ScalarValue index2, SetValue range) {
        if (!this.baseType().includes(index1.getType()) || !this.baseType().includes(index2.getType())) {
            if (this.getPrevColoring() == null) {
                return null;
            }
            return this.getPrevColoring().permutes(index1, index2, range);
        }
        if (this.color(index1) != this.color(index2)) {
            return null;
        }
        if (this._updater.independent()) {
            return null;
        }
        return this._updater.permutes(index1.getValue(), range, this);
    }

    public int[][] permutes(int index1, int index2, SetValue effects) {
        if (this.color(index1) != this.color(index2)) {
            return null;
        }
        if (this._updater.independent()) {
            effects.init();
            return null;
        }
        return this._updater.permutes(index1, effects, this);
    }

    public Coloring getPrevColoring() {
        return this._prevColor;
    }

    public Value getValue() {
        return this._value;
    }

    protected void addValue(Value val) {
        this._value = val;
    }

    public Value[] getValues() {
        Value[] values;
        if (this._prevColor == null) {
            values = new Value[]{this._value};
        } else {
            Value[] prevValues = this._prevColor.getValues();
            values = new Value[prevValues.length + 1];
            int i = 0;
            while (i < prevValues.length) {
                values[i] = prevValues[i];
                ++i;
            }
            values[prevValues.length] = this._value;
        }
        return values;
    }
}

