/*
 * Decompiled with CFR 0.152.
 */
package ladybug.selenum.isomorph;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import ladybug.parse.ScalarType;
import ladybug.selenum.isomorph.ColorFrame;
import ladybug.selenum.isomorph.Coloring;

public class ColorFrameWork {
    private Coloring _baseColoring;
    private int numFrames;
    private Hashtable dependents;
    private Hashtable changes;
    private ColorFrame[] workList;
    private int endWorkList;

    public ColorFrameWork(Coloring baseColoring) {
        this._baseColoring = baseColoring;
        this.dependents = new Hashtable();
        this.changes = new Hashtable();
        this.numFrames = 0;
    }

    public void addFrame(ColorFrame frame) {
        ColorFrame cf;
        Enumeration iter;
        Vector frames;
        ++this.numFrames;
        ScalarType dtype = frame.dependsOnColoring();
        ScalarType ctype = frame.colorsType();
        if (this.changes.containsKey(dtype)) {
            frames = (Vector)this.changes.get(dtype);
            iter = frames.elements();
            while (iter.hasMoreElements()) {
                cf = (ColorFrame)iter.nextElement();
                cf.addDependent(frame);
            }
        }
        if (this.dependents.containsKey(ctype)) {
            frames = (Vector)this.dependents.get(ctype);
            iter = frames.elements();
            while (iter.hasMoreElements()) {
                cf = (ColorFrame)iter.nextElement();
                frame.addDependent(cf);
            }
        }
        if (this.dependents.containsKey(dtype)) {
            frames = (Vector)this.dependents.get(dtype);
        } else {
            frames = new Vector();
            this.dependents.put(dtype, frames);
        }
        frames.addElement(frame);
        if (this.changes.containsKey(ctype)) {
            frames = (Vector)this.changes.get(ctype);
        } else {
            frames = new Vector();
            this.changes.put(ctype, frames);
        }
    }

    public void colorUpdated(ScalarType baseType) {
        ColorFrame cf;
        this.clearWorkList();
        if (!this.dependents.containsKey(baseType)) {
            return;
        }
        Vector frames = (Vector)this.dependents.get(baseType);
        Enumeration iter = frames.elements();
        while (iter.hasMoreElements()) {
            cf = (ColorFrame)iter.nextElement();
            if (!cf.updateColoring()) continue;
            this.addToWorkList(cf.dependents());
        }
        while ((cf = this.nextWorkList()) != null) {
            if (!cf.updateColoring()) continue;
            this.addToWorkList(cf.dependents());
        }
    }

    private void addToWorkList(ColorFrame[] newFrames) {
        if (newFrames == null) {
            return;
        }
        int i = 0;
        while (i < newFrames.length) {
            block4: {
                int j = 0;
                while (j < this.endWorkList) {
                    if (this.workList[j] != newFrames[i]) {
                        ++j;
                        continue;
                    }
                    break block4;
                }
                this.workList[this.endWorkList] = newFrames[i];
                ++this.endWorkList;
            }
            ++i;
        }
    }

    private void clearWorkList() {
        if (this.workList == null) {
            this.workList = new ColorFrame[this.numFrames];
        }
        this.endWorkList = 0;
    }

    private ColorFrame nextWorkList() {
        if (this.endWorkList == 0) {
            return null;
        }
        return this.workList[--this.endWorkList];
    }
}

