/*
 * Decompiled with CFR 0.152.
 */
package ladybug.selenum.isomorph;

import ladybug.engine.FunctionValue;
import ladybug.engine.RelOrFuncValue;
import ladybug.engine.RelationValue;
import ladybug.parse.RelationType;
import ladybug.parse.ScalarType;
import ladybug.selenum.isomorph.ColorUpdater;
import ladybug.selenum.isomorph.Coloring;

public class ColorFrame {
    private ColorFrame[] depends;
    private RelOrFuncValue _value;
    private FunctionValue _fvalue;
    private RelationValue _rvalue;
    private ColorUpdater _updater;
    private Coloring _baseColoring;
    private RelationType rtype;
    private int[] colors;
    private int[] rcolors;
    private boolean _useDomain;
    private boolean isFunctional;

    public ColorFrame(RelOrFuncValue value, boolean useDomain, Coloring baseColoring, ColorUpdater updater) {
        this._useDomain = useDomain;
        this._baseColoring = baseColoring;
        this.depends = new ColorFrame[0];
        this.rtype = (RelationType)value.getType();
        this.isFunctional = this.rtype.isFunction();
        this._value = value;
        if (this.isFunctional) {
            this._fvalue = (FunctionValue)value;
        } else {
            this._rvalue = (RelationValue)value;
        }
        this._updater = updater;
        this.colors = baseColoring.getColors(this.rtype.domain());
        this.rcolors = baseColoring.getColors(this.rtype.range());
    }

    public ColorFrame[] dependents() {
        return this.depends;
    }

    public RelOrFuncValue getValue() {
        return this._value;
    }

    public boolean useDomain() {
        return this._useDomain;
    }

    public Coloring baseColoring() {
        return this._baseColoring;
    }

    public ScalarType colorsType() {
        if (this._useDomain) {
            return this.rtype.domain();
        }
        return this.rtype.range();
    }

    public ScalarType dependsOnColoring() {
        if (this._useDomain) {
            return this.rtype.range();
        }
        return this.rtype.domain();
    }

    public void addDependent(ColorFrame dependent) {
        int i = 0;
        while (i < this.depends.length) {
            if (this.depends[i] == dependent) {
                return;
            }
            ++i;
        }
        ColorFrame[] oldDepends = this.depends;
        this.depends = new ColorFrame[oldDepends.length + 1];
        this.depends[0] = dependent;
        i = 1;
        while (i < this.depends.length) {
            this.depends[i] = oldDepends[i - 1];
            ++i;
        }
    }

    public boolean updateColoring() {
        if (this.isFunctional) {
            return this._updater.update(this._fvalue, this.colors, this.rcolors) > 0;
        }
        return this._updater.update(this._rvalue, this.colors, this.rcolors) > 0;
    }
}

