/*
 * Decompiled with CFR 0.152.
 */
package ladybug.selenum.isomorph;

import ladybug.engine.FunctionValue;
import ladybug.engine.RelationValue;
import ladybug.engine.ScalarValue;
import ladybug.engine.SetValue;
import ladybug.selenum.isomorph.ColorUpdater;
import ladybug.selenum.isomorph.Coloring;

public class AtomicUpdater
extends ColorUpdater {
    private int _numElems;
    private int[] _elems;
    private int[] _coloredElems;
    private int _numRElems;
    private int[] _Relems;
    private int[] _coloredRElems;

    AtomicUpdater(Coloring base, SetValue domain) {
        super(base, domain);
        this.initDomain();
    }

    AtomicUpdater(Coloring base, SetValue domain, SetValue range) {
        super(base, domain, range);
        this.initDomain();
        this.initRange();
    }

    boolean independent() {
        return true;
    }

    void resetDomain(SetValue domain) {
        super.resetDomain(domain);
        this.initDomain();
    }

    private void initDomain() {
        this._numElems = this._domain.card();
        this._elems = new int[(int)this._base.baseType().numValues(this._base.scope())];
        this._coloredElems = new int[this._numElems];
        int i = 0;
        while (i < this._elems.length) {
            this._elems[i] = -1;
            ++i;
        }
        int i2 = 0;
        while (i2 < this._numElems) {
            this._coloredElems[i2] = this._domain.nthElement(i2 + 1);
            this._elems[this._domain.nthElement((int)(i2 + 1))] = i2;
            ++i2;
        }
    }

    void resetRange(SetValue range) {
        super.resetRange(range);
        this.initRange();
    }

    private void initRange() {
        this._numRElems = this._range.card();
        this._Relems = new int[(int)this._base.rangeType().numValues(this._base.scope())];
        this._coloredRElems = new int[this._numRElems];
        int i = 0;
        while (i < this._Relems.length) {
            this._Relems[i] = -1;
            ++i;
        }
        int i2 = 0;
        while (i2 < this._numRElems) {
            this._coloredRElems[i2] = this._range.nthElement(i2 + 1);
            this._Relems[this._range.nthElement((int)(i2 + 1))] = i2;
            ++i2;
        }
    }

    int update(ScalarValue value, int[] colors) {
        return this._base.distinguish(value);
    }

    int update(SetValue value, int[] colors) {
        return this._base.distinguish(value);
    }

    public int update(FunctionValue value, int[] colors, int[] rcolors) {
        int incr = 0;
        int index = 1;
        while (index < this._numElems) {
            if (colors[index] + incr == colors[index - 1] && (value.isMapped(this._coloredElems[index]) || value.isMapped(this._coloredElems[index - 1]))) {
                if (!value.isMapped(this._coloredElems[index]) || !value.isMapped(this._coloredElems[index - 1])) {
                    ++incr;
                } else if (value.mapsTo(this._coloredElems[index]) != value.mapsTo(this._coloredElems[index - 1])) {
                    ++incr;
                }
            }
            int n = index++;
            colors[n] = colors[n] + incr;
        }
        this._base.updateNumColors(incr);
        incr = 0;
        index = 1;
        while (index < this._numRElems) {
            if (rcolors[index] + incr == rcolors[index - 1]) {
                int j = 0;
                while (j < value.domainMax()) {
                    if (value.hasMapping(j, this._coloredRElems[index]) != value.hasMapping(j, this._coloredRElems[index - 1])) {
                        ++incr;
                        break;
                    }
                    ++j;
                }
            }
            int n = index++;
            rcolors[n] = rcolors[n] + incr;
        }
        this._base.updateNumRColors(incr);
        return incr;
    }

    int update(RelationValue value, int[] colors, int[] rcolors) {
        int incr = 0;
        int index = 1;
        while (index < this._numElems) {
            if (colors[index] + incr == colors[index - 1] && value.mapping(this._coloredElems[index]) != value.mapping(this._coloredElems[index - 1])) {
                ++incr;
            }
            int n = index++;
            colors[n] = colors[n] + incr;
        }
        this._base.updateNumColors(incr);
        int numChanges = incr;
        if (rcolors == null) {
            return numChanges;
        }
        incr = 0;
        index = 1;
        while (index < this._numElems) {
            if (rcolors[index] + incr == rcolors[index - 1]) {
                int j = 0;
                while (j < value.domainMax()) {
                    if (value.hasMapping(j, this._coloredRElems[index]) != value.hasMapping(j, this._coloredRElems[index - 1])) {
                        ++incr;
                        break;
                    }
                    ++j;
                }
            }
            int n = index++;
            rcolors[n] = rcolors[n] + incr;
        }
        this._base.updateNumRColors(incr);
        return numChanges += incr;
    }

    void dependents(ScalarValue index, SetValue effects, Coloring c) {
        effects.init();
    }

    void dependents(int index, SetValue effects, Coloring c) {
        effects.init();
    }

    int[][] permutes(ScalarValue index, SetValue range, Coloring c) {
        return null;
    }

    int[][] permutes(int index, SetValue range, Coloring c) {
        return null;
    }
}

