/*
 * Decompiled with CFR 0.152.
 */
package ladybug.selenum;

import ladybug.engine.EnumVars;
import ladybug.parse.VarEnumeration;
import ladybug.parse.Variable;
import ladybug.parse.VariableList;
import ladybug.selenum.ExecEnv;

public class VariableSet {
    private EnumVars enums;
    private int vset;

    public VariableSet(ExecEnv env, VariableList vars) {
        this(env);
        VarEnumeration e = vars.elements();
        while (e.hasMoreElements()) {
            Variable v = e.nextVar();
            this.unionInPlace(env.varSet(v));
        }
    }

    public VariableSet(ExecEnv env) {
        this.enums = env.getEnumVars();
        this.vset = 0;
    }

    public VariableSet(ExecEnv env, int index) {
        this(env);
        this.vset = 1 << index;
    }

    public void clear() {
        this.vset = 0;
    }

    public void univ() {
        this.vset = (1 << this.enums.numVars()) - 1;
    }

    public void univ(int highest) {
        if (highest >= 0) {
            this.vset = (1 << highest + 1) - 1;
        }
    }

    public VariableSet union(VariableSet other) {
        return new VariableSet(this.enums, this.vset | other.vset);
    }

    public void unionInPlace(VariableSet other) {
        this.vset |= other.vset;
    }

    public VariableSet remove(Variable v) {
        return new VariableSet(this.enums, this.vset & ~(1 << this.enums.findPosition(v)));
    }

    public VariableSet removeIndex(int i) {
        return new VariableSet(this.enums, this.vset & ~(1 << i));
    }

    public void removeIndexInPlace(int i) {
        this.vset &= ~(1 << i);
    }

    public Variable highest() {
        if (this.vset == 0) {
            return null;
        }
        int i = this.enums.numVars() - 1;
        int bit = 1 << i;
        while (i >= 0) {
            if ((this.vset & bit) != 0) {
                return this.enums.findVar(i);
            }
            --i;
            bit >>= 1;
        }
        return null;
    }

    public int highestIndex() {
        if (this.vset == 0) {
            return -1;
        }
        int i = this.enums.numVars() - 1;
        int bit = 1 << i;
        while (i >= 0) {
            if ((this.vset & bit) != 0) {
                return i;
            }
            --i;
            bit >>= 1;
        }
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean compare(VariableSet other) {
        if (this.vset == other.vset) {
            return true;
        }
        if (this.vset == 0) {
            return true;
        }
        if (other.vset == 0) {
            return false;
        }
        int i = this.enums.numVars() - 1;
        int v1 = this.vset;
        int v2 = other.vset;
        int bit = 1 << i;
        while (i >= 0) {
            if ((v1 & bit) != 0) {
                if ((v2 & bit) == 0) return false;
                v2 &= ~bit;
                if ((v1 &= ~bit) == 0) {
                    return true;
                }
                if (v2 == 0) {
                    return false;
                }
            } else if ((v2 & bit) != 0) {
                return true;
            }
            --i;
            bit >>= 1;
        }
        return true;
    }

    public String toString() {
        String s = "{";
        boolean first = true;
        int bits = this.vset;
        int i = 0;
        while (bits != 0) {
            if ((bits & 1) != 0) {
                Variable v = this.enums.findVar(i);
                if (first) {
                    first = false;
                } else {
                    s = String.valueOf(s) + ",";
                }
                s = String.valueOf(s) + " " + v.toString();
            }
            ++i;
            bits >>= 1;
        }
        return String.valueOf(s) + " }";
    }

    private VariableSet(EnumVars enms, int vars) {
        this.enums = enms;
        this.vset = vars;
    }
}

