/*
 * Decompiled with CFR 0.152.
 */
package ladybug.selenum;

import java.util.Enumeration;
import java.util.Vector;
import ladybug.parse.RelationType;
import ladybug.parse.Variable;
import ladybug.selenum.Computation;
import ladybug.selenum.ExecEnv;
import ladybug.selenum.FuncChainTest;
import ladybug.selenum.FuncFuncEqualsTest;
import ladybug.selenum.FuncFuncStrSubTest;
import ladybug.selenum.FuncFuncSubTest;
import ladybug.selenum.FuncInjTest;
import ladybug.selenum.FuncRelEqualsTest;
import ladybug.selenum.FuncRelStrSubTest;
import ladybug.selenum.FuncRelSubTest;
import ladybug.selenum.FuncSujTest;
import ladybug.selenum.FuncTotTest;
import ladybug.selenum.OneTest;
import ladybug.selenum.OrTest;
import ladybug.selenum.RelChainTest;
import ladybug.selenum.RelFuncStrSubTest;
import ladybug.selenum.RelFuncSubTest;
import ladybug.selenum.RelFuncTest;
import ladybug.selenum.RelInjTest;
import ladybug.selenum.RelRelEqualsTest;
import ladybug.selenum.RelRelStrSubTest;
import ladybug.selenum.RelRelSubTest;
import ladybug.selenum.RelSujTest;
import ladybug.selenum.RelTotTest;
import ladybug.selenum.ScalarEqualsTest;
import ladybug.selenum.ScalarLETest;
import ladybug.selenum.ScalarLTTest;
import ladybug.selenum.SelEnumSolver;
import ladybug.selenum.SetContainsTest;
import ladybug.selenum.SetEqualsTest;
import ladybug.selenum.SetStrSubTest;
import ladybug.selenum.SetSubTest;
import ladybug.selenum.TestCommand;
import ladybug.selenum.VariableSet;

public class Tester {
    static String linesep;
    private ExecEnv _env;
    private VariableSet vset;
    private TestCommand firstTest;
    private Variable highest;
    private Vector comments;
    private Tester[] ors;
    private VariableSet orVSet;
    private SelEnumSolver solver;
    private String failedComment;

    public Tester(ExecEnv env, VariableSet vars) {
        if (linesep == null && (linesep = System.getProperty("line.separator")) == null) {
            linesep = "\n";
        }
        this.solver = env.solver();
        this.highest = vars.highest();
        this.vset = this.highest != null ? vars.remove(this.highest) : new VariableSet(env);
        this._env = env;
        this.firstTest = null;
        this.comments = new Vector();
        this.failedComment = null;
        this.ors = null;
    }

    private Tester() {
        this.solver = null;
        this.comments = new Vector();
        this.failedComment = null;
        this.ors = null;
    }

    public VariableSet evaluate() {
        int i = 0;
        if (this.ors != null) {
            this.orVSet.clear();
            i = 0;
            while (i < this.ors.length) {
                VariableSet vs = this.ors[i].evaluate();
                if (vs == null) {
                    return null;
                }
                this.orVSet.unionInPlace(vs);
                ++i;
            }
            return this.orVSet;
        }
        TestCommand tc = this.firstTest;
        while (tc != null) {
            VariableSet vs = tc.test(this._env);
            if (this.solver.debugTests) {
                if (vs != null) {
                    this.failedComment = (String)this.comments.elementAt(i);
                }
                ++i;
            }
            if (vs != null) {
                return vs;
            }
            tc = tc.next;
        }
        return null;
    }

    String failedTest() {
        return this.failedComment;
    }

    public int highestIndex() {
        if (this.highest == null) {
            return -1;
        }
        return this._env.varIndex(this.highest);
    }

    public Tester and(Tester other) {
        TestCommand tc;
        String comment;
        Enumeration e;
        Tester t2 = new Tester();
        t2._env = this._env;
        t2.solver = this.solver;
        t2.highest = this.highest;
        t2.vset = this.vset.union(other.vset);
        t2.firstTest = null;
        if (this.ors != null) {
            t2.addTest(new OrTest(this.vset, this.ors, this._env), "Ors");
        } else if (this.firstTest != null) {
            e = this.comments.elements();
            comment = (String)e.nextElement();
            tc = this.firstTest.copy();
            while (tc != null) {
                if ((tc = t2.addTest(tc, comment)) == null) continue;
                tc = tc.copy();
                comment = (String)e.nextElement();
            }
        }
        if (other.ors != null) {
            t2.addTest(new OrTest(other.vset, other.ors, this._env), "Ors");
        } else if (other.firstTest != null) {
            e = other.comments.elements();
            comment = (String)e.nextElement();
            tc = other.firstTest.copy();
            while (tc != null) {
                if ((tc = t2.addTest(tc, comment)) == null) continue;
                tc = tc.copy();
                comment = (String)e.nextElement();
            }
        }
        return t2;
    }

    public Tester or(Tester other) {
        Tester t2 = new Tester();
        t2._env = this._env;
        t2.solver = this.solver;
        t2.highest = this.highest;
        t2.vset = this.vset.union(other.vset);
        t2.orVSet = new VariableSet(this._env);
        if (this.ors == null) {
            if (this.firstTest == null) {
                return other;
            }
            t2.ors = new Tester[2];
            t2.ors[0] = this;
            t2.ors[1] = other;
            return t2;
        }
        t2.ors = new Tester[this.ors.length + 1];
        int i = 0;
        while (i < this.ors.length) {
            t2.ors[i] = this.ors[i];
            ++i;
        }
        t2.ors[this.ors.length] = other;
        return t2;
    }

    public String toString() {
        return this.toString(2);
    }

    public String toString(int indent) {
        String s = "";
        String ind = "";
        int i = 0;
        while (i < indent) {
            ind = String.valueOf(ind) + " ";
            ++i;
        }
        if (this.ors != null) {
            i = 0;
            while (i < this.ors.length) {
                if (i > 0) {
                    s = String.valueOf(s) + ind + "OR" + linesep;
                }
                s = String.valueOf(s) + this.ors[i].toString(indent + 4);
                ++i;
            }
            return s;
        }
        TestCommand tc = this.firstTest;
        Enumeration e = this.comments.elements();
        while (tc != null) {
            String comment = (String)e.nextElement();
            s = String.valueOf(s) + ind + "// " + comment + linesep + ind + tc.toString();
            tc = tc.next;
        }
        return s;
    }

    void checkFunc(Computation comp, boolean neg, String comment) {
        RelationType rtype = (RelationType)comp.getValue().getType();
        if (!rtype.isFunction()) {
            this.addTest(new RelFuncTest(comp.getValue(), this.vset, neg), comment);
        }
    }

    void checkInj(Computation comp, boolean neg, String comment) {
        RelationType rtype = (RelationType)comp.getValue().getType();
        if (rtype.isFunction()) {
            this.addTest(new FuncInjTest(comp.getValue(), this.vset, neg), comment);
        } else {
            this.addTest(new RelInjTest(comp.getValue(), this.vset, neg), comment);
        }
    }

    void checkTotal(Computation comp, boolean neg, String comment) {
        RelationType rtype = (RelationType)comp.getValue().getType();
        if (rtype.isFunction()) {
            this.addTest(new FuncTotTest(comp.getValue(), this.vset, neg), comment);
        } else {
            this.addTest(new RelTotTest(comp.getValue(), this.vset, neg), comment);
        }
    }

    void checkSuj(Computation comp, boolean neg, String comment) {
        RelationType rtype = (RelationType)comp.getValue().getType();
        if (rtype.isFunction()) {
            this.addTest(new FuncSujTest(comp.getValue(), this.vset, neg), comment);
        } else {
            this.addTest(new RelSujTest(comp.getValue(), this.vset, neg), comment);
        }
    }

    void checkOne(Computation comp, boolean neg, String comment) {
        this.addTest(new OneTest(comp.getValue(), this.vset, neg), comment);
    }

    void checkChain(Computation comp, boolean neg, String comment) {
        RelationType rtype = (RelationType)comp.getValue().getType();
        if (rtype.isFunction()) {
            this.addTest(new FuncChainTest(comp.getValue(), this.vset, neg), comment);
        } else {
            this.addTest(new RelChainTest(comp.getValue(), this.vset, neg), comment);
        }
    }

    void checkRelSubset(Computation left, Computation right, boolean neg, String comment) {
        RelationType rtypel = (RelationType)left.getValue().getType();
        RelationType rtyper = (RelationType)right.getValue().getType();
        if (rtypel.isFunction()) {
            if (rtyper.isFunction()) {
                this.addTest(new FuncFuncSubTest(left.getValue(), right.getValue(), this.vset, neg), comment);
            } else {
                this.addTest(new FuncRelSubTest(left.getValue(), right.getValue(), this.vset, neg), comment);
            }
        } else if (rtyper.isFunction()) {
            this.addTest(new RelFuncSubTest(left.getValue(), right.getValue(), this.vset, neg), comment);
        } else {
            this.addTest(new RelRelSubTest(left.getValue(), right.getValue(), this.vset, neg), comment);
        }
    }

    void checkRelStrSubset(Computation left, Computation right, boolean neg, String comment) {
        RelationType rtypel = (RelationType)left.getValue().getType();
        RelationType rtyper = (RelationType)right.getValue().getType();
        if (rtypel.isFunction()) {
            if (rtyper.isFunction()) {
                this.addTest(new FuncFuncStrSubTest(left.getValue(), right.getValue(), this.vset, neg), comment);
            } else {
                this.addTest(new FuncRelStrSubTest(left.getValue(), right.getValue(), this.vset, neg), comment);
            }
        } else if (rtyper.isFunction()) {
            this.addTest(new RelFuncStrSubTest(left.getValue(), right.getValue(), this.vset, neg), comment);
        } else {
            this.addTest(new RelRelStrSubTest(left.getValue(), right.getValue(), this.vset, neg), comment);
        }
    }

    void checkRelEqual(Computation left, Computation right, boolean neg, String comment) {
        RelationType rtypel = (RelationType)left.getValue().getType();
        RelationType rtyper = (RelationType)right.getValue().getType();
        if (rtypel.isFunction()) {
            if (rtyper.isFunction()) {
                this.addTest(new FuncFuncEqualsTest(left.getValue(), right.getValue(), this.vset, neg), comment);
            } else {
                this.addTest(new FuncRelEqualsTest(left.getValue(), right.getValue(), this.vset, neg), comment);
            }
        } else if (rtyper.isFunction()) {
            this.addTest(new FuncRelEqualsTest(right.getValue(), left.getValue(), this.vset, neg), comment);
        } else {
            this.addTest(new RelRelEqualsTest(left.getValue(), right.getValue(), this.vset, neg), comment);
        }
    }

    void checkSetSubset(Computation left, Computation right, boolean neg, String comment) {
        this.addTest(new SetSubTest(left.getValue(), right.getValue(), this.vset, neg), comment);
    }

    void checkSetStrSubset(Computation left, Computation right, boolean neg, String comment) {
        this.addTest(new SetStrSubTest(left.getValue(), right.getValue(), this.vset, neg), comment);
    }

    void checkSetEqual(Computation left, Computation right, boolean neg, String comment) {
        this.addTest(new SetEqualsTest(left.getValue(), right.getValue(), this.vset, neg), comment);
    }

    void checkElement(Computation left, Computation right, boolean neg, String comment) {
        this.addTest(new SetContainsTest(left.getValue(), right.getValue(), this.vset, neg), comment);
    }

    void checkScalarEqual(Computation left, Computation right, boolean neg, String comment) {
        this.addTest(new ScalarEqualsTest(left.getValue(), right.getValue(), this.vset, neg), comment);
    }

    void checkLessThan(Computation left, Computation right, boolean neg, String comment) {
        this.addTest(new ScalarLTTest(left.getValue(), right.getValue(), this.vset, neg), comment);
    }

    void checkLTEqual(Computation left, Computation right, boolean neg, String comment) {
        this.addTest(new ScalarLETest(left.getValue(), right.getValue(), this.vset, neg), comment);
    }

    private TestCommand addTest(TestCommand tc, String comment) {
        TestCommand next = tc.next;
        tc.next = null;
        if (this.firstTest == null) {
            this.firstTest = tc;
            this.comments.addElement(comment);
            return next;
        }
        int i = 0;
        if (tc.vset.compare(this.firstTest.vset)) {
            tc.next = this.firstTest;
            this.firstTest = tc;
            this.comments.insertElementAt(comment, i);
            return next;
        }
        TestCommand tc2 = this.firstTest;
        ++i;
        while (tc2.next != null) {
            if (tc.vset.compare(tc2.next.vset)) {
                tc.next = tc2.next;
                tc2.next = tc;
                this.comments.insertElementAt(comment, i);
                return next;
            }
            tc2 = tc2.next;
            ++i;
        }
        tc2.next = tc;
        this.comments.insertElementAt(comment, i);
        return next;
    }
}

