/*
 * Decompiled with CFR 0.152.
 */
package ladybug.selenum;

import java.util.NoSuchElementException;
import ladybug.engine.FunctionValue;
import ladybug.engine.Scope;
import ladybug.engine.SetValue;
import ladybug.engine.Value;
import ladybug.parse.RelationType;
import ladybug.parse.ScalarType;
import ladybug.parse.SetType;
import ladybug.parse.Type;
import ladybug.parse.Variable;
import ladybug.selenum.Generator;
import ladybug.selenum.SetGenerator;
import ladybug.selenum.isomorph.Coloring;

public class SetIsoGenerator
extends Generator
implements SetGenerator {
    private Coloring _baseColoring;
    private Coloring _useColoring;
    private SetValue _domain;
    private SetValue _fullDomain;
    private SetValue val;
    private SetValue scratch;
    private SetValue result;
    private FunctionValue map;
    private int[] _colors;
    private int[] colorSizes;
    private int[] firstElem;
    private int nextIndex;
    private int maxIndex;
    private int domSize;
    private int numElems;
    private int _minCard;
    private int _maxCard;
    private int numColors;
    private boolean computed;
    private boolean mapResult;

    public SetIsoGenerator(SetValue value, Variable var, Type t, Scope scope, Coloring baseColoring) {
        super(var, t);
        ScalarType etype = ((SetType)t).elemType();
        this.nextIndex = 0;
        this.domSize = (int)etype.numValues(scope);
        this._domain = this._fullDomain = etype.universe(scope);
        this._colors = new int[this.domSize];
        this.colorSizes = new int[this.domSize];
        this.firstElem = new int[this.domSize];
        this.result = value;
        this.mapResult = false;
        this.numElems = this.domSize;
        this.maxIndex = this.domSize;
        this.map = new FunctionValue(new RelationType(etype, etype, true, true, false, false, false), this.domSize, this.domSize);
        this.scratch = new SetValue(new SetType(etype), scope);
        this.val = this.result;
        this._baseColoring = baseColoring;
        this._useColoring = this._baseColoring == null ? null : this._baseColoring.findRelatedColoring(this._domain);
        this._maxCard = -1;
        this._minCard = -1;
        this.terminate();
    }

    public void setValue(SetValue value) {
        this.result = value;
        if (!this.mapResult) {
            this.val = value;
        }
    }

    public void setDomain(SetValue dom) {
        this.numElems = dom.card();
        if (this.numElems == 0) {
            this.domSize = 0;
            this.mapResult = false;
            this._domain = null;
            this.val = this.result;
            this.reset();
            return;
        }
        this.domSize = dom.maxElem() + 1;
        if (this.domSize == this.numElems) {
            this.mapResult = false;
            this._domain = this._fullDomain;
            this.val = this.result;
        } else {
            this.mapResult = true;
            this._domain = dom;
            this.val = this.scratch;
            int i = 0;
            int j = 0;
            while (i < this.domSize) {
                if (dom.hasElement(i)) {
                    this.map.addMapping(j, i);
                    ++j;
                }
                ++i;
            }
        }
        if (this._coloring != null) {
            this._coloring.resetDomain(this._domain);
        }
        if (this._baseColoring != null) {
            this._useColoring = this._baseColoring.findRelatedColoring(this._domain);
        }
        this.reset();
    }

    public void setMinCard(int min) {
        this._minCard = min;
    }

    public void setMaxCard(int max) {
        this._maxCard = max;
    }

    public void reset() {
        this.nextIndex = 0;
        if (this.domSize == 0) {
            this.maxIndex = 1;
            return;
        }
        if (this._useColoring == null) {
            int i = 0;
            while (i < this.numElems) {
                this._colors[i] = 0;
                ++i;
            }
            this.maxIndex = this.numElems + 1;
            this.numColors = 1;
            this.colorSizes[0] = this.numElems;
            return;
        }
        this._useColoring.coloring(this._domain, this._colors);
        this.numColors = 1;
        this.colorSizes[0] = 1;
        this.firstElem[0] = 0;
        this.maxIndex = 1;
        int i = 1;
        while (i < this.numElems) {
            if (this._colors[i - 1] != this._colors[i]) {
                this.maxIndex *= this.colorSizes[this.numColors - 1] + 1;
                this.colorSizes[this.numColors] = 1;
                this.firstElem[this.numColors] = i;
                ++this.numColors;
            } else {
                int n = this.numColors - 1;
                this.colorSizes[n] = this.colorSizes[n] + 1;
            }
            ++i;
        }
        this.maxIndex *= this.colorSizes[this.numColors - 1] + 1;
        this.computed = false;
    }

    public void terminate() {
        this.nextIndex = this.maxIndex;
    }

    public boolean hasMoreElements() {
        return this.computeNextSet();
    }

    public Value nextValue() throws NoSuchElementException {
        return this.nextSet();
    }

    public SetValue nextSet() throws NoSuchElementException {
        if (!this.computeNextSet()) {
            throw new NoSuchElementException();
        }
        this.computed = false;
        if (this.mapResult) {
            this.map.image(this.val, this.result);
        }
        if (this._coloring != null) {
            this._coloring.updateColoring(this.result);
        }
        return this.result;
    }

    private boolean computeNextSet() {
        if (this.computed) {
            return true;
        }
        if (this.nextIndex == this.maxIndex) {
            return false;
        }
        int bits = this.nextIndex;
        this.val.init();
        int i = 0;
        while (bits != 0 && i < this.numColors) {
            int x = bits % (this.colorSizes[i] + 1);
            if (x != 0) {
                this.val.addBits((1 << x) - 1 << this.firstElem[i]);
            }
            bits /= this.colorSizes[i] + 1;
            ++i;
        }
        ++this.nextIndex;
        if (this._minCard > 0 && this.val.card() < this._minCard) {
            return this.computeNextSet();
        }
        if (this._maxCard >= 0 && this.val.card() > this._maxCard) {
            return this.computeNextSet();
        }
        this.computed = true;
        return true;
    }

    public double pctCompleted() {
        if (this.maxIndex == 0) {
            return 1.0;
        }
        return (double)this.nextIndex / (double)this.maxIndex;
    }

    public long totalValues() {
        return this.maxIndex;
    }

    public long totalGenValues() {
        if (this.maxIndex <= 0) {
            return 1L;
        }
        return this.maxIndex;
    }

    public long valuesGend() {
        return this.nextIndex;
    }
}

