/*
 * Decompiled with CFR 0.152.
 */
package ladybug.selenum;

import java.util.NoSuchElementException;
import ladybug.engine.FunctionValue;
import ladybug.engine.Scope;
import ladybug.engine.SetValue;
import ladybug.engine.Value;
import ladybug.parse.RelationType;
import ladybug.parse.ScalarType;
import ladybug.parse.SetType;
import ladybug.parse.Type;
import ladybug.parse.Variable;
import ladybug.selenum.Generator;
import ladybug.selenum.SetGenerator;

public class SetExhGenerator
extends Generator
implements SetGenerator {
    private SetValue val;
    private SetValue scratch;
    private SetValue result;
    private FunctionValue map;
    private int nextIndex;
    private int maxIndex;
    private int domSize;
    private int _minCard;
    private int _maxCard;
    private boolean mapResult;

    public SetExhGenerator(SetValue value, Variable var, Type type, Scope scope) {
        super(var, type);
        SetType st = (SetType)type;
        ScalarType sct = st.elemType();
        this.nextIndex = 0;
        this.domSize = (int)sct.numValues(scope);
        this.maxIndex = 1 << this.domSize;
        this.result = value;
        this.setTypeGenerated(new SetType(st.elemType()));
        this.mapResult = false;
        this.map = new FunctionValue(new RelationType(sct, sct, true, true, false, false, false), this.domSize, this.domSize);
        this.scratch = new SetValue(st, this.domSize);
        this.val = this.result;
        this._minCard = -1;
        this._maxCard = -1;
        this.terminate();
    }

    public void setValue(SetValue value) {
        this.result = value;
        if (!this.mapResult) {
            this.val = value;
        }
    }

    public void setDomain(SetValue dom) {
        if (this._coloring != null) {
            this._coloring.resetDomain(dom);
        }
        this.domSize = dom.card();
        int max = dom.maxElem() + 1;
        this.maxIndex = 1 << this.domSize;
        if (this.domSize == max) {
            this.mapResult = false;
            this.val = this.result;
        } else {
            this.val = this.scratch;
            this.mapResult = true;
            int i = 0;
            int j = 0;
            while (i < max) {
                if (dom.hasElement(i)) {
                    this.map.addMapping(j, i);
                    ++j;
                }
                ++i;
            }
        }
    }

    public void setMinCard(int min) {
        this._minCard = min;
    }

    public void setMaxCard(int max) {
        this._maxCard = max;
    }

    public void reset() {
        this.nextIndex = 0;
    }

    public void terminate() {
        this.nextIndex = this.maxIndex;
    }

    public boolean hasMoreElements() {
        return this.nextIndex < this.maxIndex;
    }

    public Value nextValue() throws NoSuchElementException {
        return this.nextSet();
    }

    public SetValue nextSet() throws NoSuchElementException {
        if (this.nextIndex == this.maxIndex) {
            throw new NoSuchElementException();
        }
        this.val.setBits(this.nextIndex);
        ++this.nextIndex;
        if (this.mapResult) {
            this.map.image(this.val, this.result);
        }
        if (this._minCard > 0 && this.val.card() < this._minCard) {
            return this.nextSet();
        }
        if (this._maxCard >= 0 && this.val.card() > this._maxCard) {
            return this.nextSet();
        }
        if (this._coloring != null) {
            this._coloring.updateColoring(this.result);
        }
        return this.result;
    }

    public double pctCompleted() {
        if (this.maxIndex == 0) {
            return 1.0;
        }
        return (double)this.nextIndex / (double)this.maxIndex;
    }

    public long totalValues() {
        return this.maxIndex;
    }

    public long totalGenValues() {
        if (this.maxIndex <= 0) {
            return 1L;
        }
        return this.maxIndex;
    }

    public long valuesGend() {
        return this.nextIndex;
    }
}

