/*
 * Decompiled with CFR 0.152.
 */
package ladybug.selenum;

import ladybug.engine.Assignment;
import ladybug.engine.DerivedVars;
import ladybug.engine.EnumVars;
import ladybug.engine.LadyBug;
import ladybug.engine.Solver;
import ladybug.engine.Value;
import ladybug.parse.Schema;
import ladybug.parse.VarEnumeration;
import ladybug.parse.Variable;
import ladybug.selenum.Computation;
import ladybug.selenum.ExecEnv;
import ladybug.selenum.Generator;
import ladybug.selenum.InvalidAssignment;
import ladybug.selenum.SelEnumSolver;
import ladybug.selenum.Tester;
import ladybug.selenum.VariableSet;

public class Search
extends Solver {
    private VariableSet[] vsets;
    private VariableSet vset;
    private SelEnumSolver _solver;
    private Schema _schema;
    private EnumVars enums;
    private DerivedVars derived;
    private Variable[] vars;
    private Value[] values;
    private int[] varLevel;
    private Generator[] generators;
    private Tester[] testers;
    private Computation[] comps;
    private Computation constants;
    private ExecEnv env;
    private int nextLevel;
    private int num_vars;
    private int all_vars;
    private int stop_level;
    int min_var_level = 0;
    int max_var_level = -1;
    private long[] casesGenerated;
    private long[] valuesGenerated;

    public Search(SelEnumSolver solver) {
        super(solver);
        Variable v;
        VarEnumeration ve;
        this._solver = solver;
        this._schema = solver.getFormulaSolver().getSchema();
        this.stop_level = -1;
        this.env = solver.getEnv();
        this.enums = this.env.getEnumVars();
        this.derived = solver.getFormulaSolver().getDerivedVars();
        this.generators = this.env.generators();
        this.testers = this.env.testers();
        this.comps = this.env.computations();
        this.constants = this.env.getConstantComps();
        this.all_vars = this.num_vars = this.enums.numVars();
        if (this.derived != null) {
            this.all_vars += this.derived.numDerived();
        }
        this.varLevel = new int[this.all_vars];
        this.vars = new Variable[this.all_vars];
        this.values = new Value[this.all_vars];
        this.valuesGenerated = this.env.valuesGenerated;
        this.casesGenerated = this.env.casesGenerated;
        int index = 0;
        if (this.derived != null) {
            ve = this.derived.derivedVars();
            while (ve.hasMoreElements()) {
                v = ve.nextVar();
                if (this.env.varIndex(v) >= 0) continue;
                this.vars[index] = v;
                this.varLevel[index] = -1;
                this.values[index] = this.env.getVarValue(v);
                ++index;
            }
        }
        int i = 0;
        while (i < this.num_vars) {
            Variable var;
            this.vars[index] = var = this.enums.findVar(i);
            this.varLevel[index] = i;
            this.values[index] = this.env.getVarValue(var);
            ++index;
            if (this.derived != null) {
                ve = this.derived.derivedVars();
                while (ve.hasMoreElements()) {
                    v = ve.nextVar();
                    int ix = this.env.varIndex(v);
                    if (ix != i) continue;
                    this.vars[index] = v;
                    this.varLevel[index] = i;
                    this.values[index] = this.env.getVarValue(v);
                    ++index;
                }
            }
            ++i;
        }
    }

    public void solve() {
        this._solver.reset();
        this.nextLevel = 0;
        this._solver.num_cases = 0L;
        this._solver.num_values = 0L;
        if (this._solver.useSC) {
            try {
                this.sc_init();
                while (this.sc_search()) {
                    if (this.returnAssignment()) {
                        --this.nextLevel;
                        continue;
                    }
                    break;
                }
            }
            catch (InvalidAssignment invalidAssignment) {}
        } else {
            this.simpleSearch();
        }
    }

    public double pctCompleted() {
        double comp = 1.0;
        int i = this.num_vars - 1;
        while (i >= 0) {
            double c = this.generators[i].pctCompleted();
            if (c <= 0.0) {
                c = 0.0;
            } else if (c > 1.0) {
                c = 1.0;
            }
            double incr = 1.0 / (double)this.generators[i].totalGenValues();
            comp = c - incr * (1.0 - comp);
            --i;
        }
        if (comp <= 0.0) {
            return 0.0;
        }
        if (comp > 1.0) {
            return 1.0;
        }
        return comp;
    }

    /*
     * Unable to fully structure code
     */
    private void simpleSearch() {
        try {
            if (this.constants == null) ** GOTO lbl15
            this.constants.evaluate();
            if (true) ** GOTO lbl15
        }
        catch (InvalidAssignment v0) {
            return;
        }
        do {
            if (this._solver.debugCases && this.nextLevel >= this.min_var_level && (this.max_var_level < 0 || this.max_var_level >= this.nextLevel)) {
                LadyBug.logMessage("New assignment " + String.valueOf(this._solver.num_partial_cases) + "." + String.valueOf(this.nextLevel));
                this.dumpAssignment();
            }
            ++this._solver.num_cases;
            ++this._solver.num_partial_cases;
            if (this.testsPass() && !this.returnAssignment()) break;
            --this.nextLevel;
lbl15:
            // 3 sources

        } while (this.nextPath());
    }

    private boolean nextPath() {
        boolean generatedAny = false;
        while (this.nextLevel >= 0) {
            if (!this.generators[this.nextLevel].hasMoreElements()) {
                if (generatedAny) {
                    ++this._solver.num_partial_cases;
                }
                --this.nextLevel;
                generatedAny = false;
                continue;
            }
            Value val = this.generators[this.nextLevel].nextValue();
            generatedAny = true;
            if (this._solver.debugValues && this.nextLevel >= this.min_var_level && (this.max_var_level < 0 || this.max_var_level >= this.nextLevel)) {
                LadyBug.logMessage("new value " + String.valueOf(this._solver.num_partial_cases) + "." + String.valueOf(this.nextLevel) + ": " + val.toString());
            }
            if (this._solver.debugColors && this._solver.useIsoElim && this.nextLevel >= this.min_var_level && (this.max_var_level < 0 || this.max_var_level >= this.nextLevel)) {
                LadyBug.logMessage(this.generators[this.nextLevel].getColoring().dumpColors());
            }
            ++this._solver.num_values;
            int n = this.nextLevel;
            this.valuesGenerated[n] = this.valuesGenerated[n] + 1L;
            int n2 = this.nextLevel;
            this.casesGenerated[n2] = this.casesGenerated[n2] + 1L;
            try {
                if (this.comps[this.nextLevel] != null) {
                    this.comps[this.nextLevel].evaluate();
                }
                ++this.nextLevel;
                if (this.nextLevel == this.num_vars) {
                    return true;
                }
                this.generators[this.nextLevel].reset();
            }
            catch (InvalidAssignment invalidAssignment) {}
        }
        return false;
    }

    private boolean testsPass() {
        int i = 0;
        while (i < this.num_vars) {
            if (this.testers[i] != null && this.testers[i].evaluate() != null) {
                if (this._solver.debugTests && this.nextLevel >= this.min_var_level && (this.max_var_level < 0 || this.max_var_level >= this.nextLevel)) {
                    LadyBug.logMessage("Failed test " + this.testers[i].failedTest());
                }
                return false;
            }
            ++i;
        }
        return true;
    }

    private void sc_init() throws InvalidAssignment {
        this.vsets = new VariableSet[this.num_vars];
        int i = 0;
        while (i < this.num_vars) {
            this.vsets[i] = new VariableSet(this.env);
            ++i;
        }
        this.vset = new VariableSet(this.env);
        if (this.constants != null) {
            this.constants.evaluate();
        }
    }

    private boolean sc_search() {
        VariableSet[] depends = this.env.getDepends();
        while (this.nextLevel >= 0) {
            if (this.generators[this.nextLevel].hasMoreElements()) {
                if (this.nextLevel == this.stop_level) {
                    this.debug_catcher();
                }
                Value val = this.generators[this.nextLevel].nextValue();
                if (this._solver.debugValues && this.nextLevel >= this.min_var_level && (this.max_var_level < 0 || this.max_var_level >= this.nextLevel)) {
                    LadyBug.logMessage("new value " + String.valueOf(this._solver.num_partial_cases) + "." + String.valueOf(this.nextLevel) + ": " + val.toString());
                }
                if (this._solver.debugColors && this._solver.useIsoElim && this.nextLevel >= this.min_var_level && (this.max_var_level < 0 || this.max_var_level >= this.nextLevel) && this.generators[this.nextLevel].getColoring() != null) {
                    LadyBug.logMessage(this.generators[this.nextLevel].getColoring().dumpColors());
                }
                ++this._solver.num_values;
                int n = this.nextLevel;
                this.valuesGenerated[n] = this.valuesGenerated[n] + 1L;
                try {
                    if (this.comps[this.nextLevel] != null) {
                        this.comps[this.nextLevel].evaluate();
                    }
                    if (this.testers[this.nextLevel] != null) {
                        VariableSet v2 = this.testers[this.nextLevel].evaluate();
                        if (v2 == null) {
                            int n2 = this.nextLevel++;
                            this.casesGenerated[n2] = this.casesGenerated[n2] + 1L;
                            if (this.nextLevel == this.num_vars) {
                                if (this._solver.debugCases && this.nextLevel >= this.min_var_level && (this.max_var_level < 0 || this.max_var_level >= this.nextLevel)) {
                                    LadyBug.logMessage("Found satisfying assignment" + String.valueOf(this._solver.num_partial_cases) + "." + String.valueOf(this.nextLevel));
                                    this.dumpAssignment();
                                }
                                if (this._solver.optimSC) {
                                    this.vsets[this.nextLevel - 1].univ(this.nextLevel - 2);
                                }
                                ++this._solver.num_cases;
                                ++this._solver.num_partial_cases;
                                return true;
                            }
                            this.generators[this.nextLevel].reset();
                            if (this._solver.optimSC) {
                                this.vsets[this.nextLevel].clear();
                                this.vsets[this.nextLevel].unionInPlace(depends[this.nextLevel]);
                            }
                            if (this.generators[this.nextLevel].hasMoreElements()) continue;
                            if (this._solver.debugValues && this.nextLevel >= this.min_var_level && (this.max_var_level < 0 || this.max_var_level >= this.nextLevel)) {
                                LadyBug.logMessage("No values for " + String.valueOf(this.nextLevel));
                            }
                            ++this._solver.num_partial_cases;
                            this.choosePrevLevel();
                            continue;
                        }
                        if (this._solver.optimSC) {
                            this.vsets[this.nextLevel].unionInPlace(v2);
                        }
                        if (this._solver.debugCases && this.nextLevel >= this.min_var_level && (this.max_var_level < 0 || this.max_var_level >= this.nextLevel)) {
                            if (this.nextLevel == this.num_vars - 1) {
                                LadyBug.logMessage("Assignment " + String.valueOf(this._solver.num_partial_cases) + "." + String.valueOf(this.nextLevel) + " failed");
                            } else {
                                LadyBug.logMessage("Short circuiting " + String.valueOf(this._solver.num_partial_cases) + "." + String.valueOf(this.nextLevel) + " to " + String.valueOf(this.nextLevel));
                            }
                            this.dumpAssignment();
                        }
                        if (this._solver.debugTests && this.nextLevel >= this.min_var_level && (this.max_var_level < 0 || this.max_var_level >= this.nextLevel)) {
                            LadyBug.logMessage("Failed test with " + v2.toString());
                            LadyBug.logMessage(this.testers[this.nextLevel].failedTest());
                        }
                        if (this.nextLevel == this.num_vars - 1) {
                            ++this._solver.num_cases;
                        }
                        ++this._solver.num_partial_cases;
                        continue;
                    }
                    int n3 = this.nextLevel++;
                    this.casesGenerated[n3] = this.casesGenerated[n3] + 1L;
                    if (this.nextLevel == this.num_vars) {
                        if (this._solver.debugCases && this.nextLevel >= this.min_var_level && (this.max_var_level < 0 || this.max_var_level >= this.nextLevel)) {
                            LadyBug.logMessage("Found satisfying assignment" + String.valueOf(this._solver.num_partial_cases) + "." + String.valueOf(this.nextLevel));
                            this.dumpAssignment();
                        }
                        if (this._solver.optimSC) {
                            this.vsets[this.nextLevel - 1].univ(this.nextLevel - 2);
                        }
                        ++this._solver.num_cases;
                        ++this._solver.num_partial_cases;
                        return true;
                    }
                    this.generators[this.nextLevel].reset();
                    if (this._solver.optimSC) {
                        this.vsets[this.nextLevel].clear();
                        this.vsets[this.nextLevel].unionInPlace(depends[this.nextLevel]);
                    }
                    if (this.generators[this.nextLevel].hasMoreElements()) continue;
                    if (this._solver.debugValues && this.nextLevel >= this.min_var_level && (this.max_var_level < 0 || this.max_var_level >= this.nextLevel)) {
                        LadyBug.logMessage("No values for " + String.valueOf(this.nextLevel));
                    }
                    ++this._solver.num_partial_cases;
                    this.choosePrevLevel();
                }
                catch (InvalidAssignment invalidAssignment) {
                    if (this._solver.debugCases && this.nextLevel >= this.min_var_level && (this.max_var_level < 0 || this.max_var_level >= this.nextLevel)) {
                        if (this.nextLevel == this.num_vars - 1) {
                            LadyBug.logMessage("Assignment " + String.valueOf(this._solver.num_partial_cases) + "." + String.valueOf(this.nextLevel) + " was invalid");
                        } else {
                            LadyBug.logMessage("Short circuiting invalid " + String.valueOf(this._solver.num_partial_cases) + "." + String.valueOf(this.nextLevel) + " to " + String.valueOf(this.nextLevel));
                        }
                        this.dumpAssignment();
                    }
                    ++this._solver.num_partial_cases;
                    if (this.nextLevel != this.num_vars - 1) continue;
                    ++this._solver.num_cases;
                }
                continue;
            }
            if (this._solver.debugValues && this.nextLevel >= this.min_var_level && (this.max_var_level < 0 || this.max_var_level >= this.nextLevel)) {
                LadyBug.logMessage("No more values for " + String.valueOf(this.nextLevel));
            }
            this.choosePrevLevel();
        }
        return false;
    }

    private void choosePrevLevel() {
        if (this._solver.optimSC) {
            this.vset.unionInPlace(this.vsets[this.nextLevel]);
            if (this._solver.debugCases && this.nextLevel >= this.min_var_level && (this.max_var_level < 0 || this.max_var_level >= this.nextLevel)) {
                LadyBug.logMessage("Choose next level from " + this.vset.toString());
            }
            int newLevel = this.vset.highestIndex();
            while (newLevel >= 0 && !this.generators[newLevel].hasMoreElements()) {
                this.vset.removeIndexInPlace(newLevel);
                if (newLevel >= 0) {
                    this.vset.unionInPlace(this.vsets[newLevel]);
                }
                newLevel = this.vset.highestIndex();
            }
            if (this._solver.debugCases && this.nextLevel >= this.min_var_level && (this.max_var_level < 0 || this.max_var_level >= this.nextLevel)) {
                LadyBug.logMessage("Short circuiting " + String.valueOf(this._solver.num_partial_cases) + "." + String.valueOf(this.nextLevel) + " to " + String.valueOf(newLevel));
            }
            while (--this.nextLevel > newLevel) {
                this.generators[this.nextLevel].terminate();
            }
            this.nextLevel = newLevel;
            if (this.nextLevel >= 0) {
                this.vsets[this.nextLevel].clear();
            }
        } else {
            --this.nextLevel;
        }
    }

    private boolean returnAssignment() {
        Assignment assign = new Assignment(this._schema);
        int i = 0;
        while (i < this.all_vars) {
            if (this.varLevel[i] >= this.nextLevel) break;
            assign.setValue(this.vars[i], this.values[i]);
            ++i;
        }
        return this._solver.foundSolution(assign);
    }

    private void dumpAssignment() {
        int i = 0;
        while (i < this.all_vars) {
            if (this.varLevel[i] > this.nextLevel) break;
            LadyBug.logMessage(String.valueOf(this.vars[i].toString()) + " = " + this.values[i].toString());
            ++i;
        }
    }

    private void debug_catcher() {
    }
}

