/*
 * Decompiled with CFR 0.152.
 */
package ladybug.selenum;

import java.util.NoSuchElementException;
import ladybug.engine.FunctionValue;
import ladybug.engine.ScalarValue;
import ladybug.engine.Scope;
import ladybug.engine.SetValue;
import ladybug.engine.Value;
import ladybug.engine.ValueError;
import ladybug.parse.RelationType;
import ladybug.parse.ScalarType;
import ladybug.parse.Type;
import ladybug.parse.Variable;
import ladybug.selenum.Generator;
import ladybug.selenum.ScalarGenerator;
import ladybug.selenum.isomorph.Coloring;

public class ScalarIsoGenerator
extends Generator
implements ScalarGenerator {
    private Coloring _baseColoring;
    private Coloring _useColoring;
    private SetValue _domain;
    private SetValue _fullDomain;
    private ScalarValue val;
    private ScalarValue scratch;
    private ScalarValue result;
    private FunctionValue map;
    private int[] _colors;
    private int _pvalue;
    private int nextIndex = 0;
    private int maxIndex;
    private int domSize;
    private int numElems;
    private boolean mapResult;

    public ScalarIsoGenerator(ScalarValue value, Variable var, Type t, Scope scope, Coloring baseColoring) {
        super(var, t);
        ScalarType type = (ScalarType)t;
        this.domSize = (int)type.numValues(scope);
        this._colors = new int[this.domSize];
        this.result = value;
        this.mapResult = false;
        this.numElems = this.domSize;
        this.maxIndex = this.domSize;
        this.map = new FunctionValue(new RelationType(type, type, true, true, false, false, false), this.domSize, this.domSize);
        this.scratch = new ScalarValue(type, scope);
        this.val = this.result;
        this._baseColoring = baseColoring;
        this._domain = this._fullDomain = type.universe(scope);
        this._useColoring = this._baseColoring == null ? null : this._baseColoring.findRelatedColoring(this._domain);
        this.terminate();
    }

    public void setValue(ScalarValue value) {
        this.result = value;
        if (!this.mapResult) {
            this.val = value;
        }
    }

    public void setDomain(SetValue dom) {
        this.numElems = dom.card();
        if (this.numElems == 0) {
            this.domSize = 0;
            this.mapResult = false;
            this._domain = null;
            this.val = this.result;
            this.reset();
            return;
        }
        this.domSize = dom.maxElem() + 1;
        if (this.domSize == this.numElems) {
            this.mapResult = false;
            this._domain = this._fullDomain;
            this.val = this.result;
        } else {
            this.mapResult = true;
            this._domain = dom;
            this.val = this.scratch;
            int i = 0;
            int j = 0;
            while (i < this.domSize) {
                if (dom.hasElement(i)) {
                    this.map.addMapping(j, i);
                    ++j;
                }
                ++i;
            }
        }
        this.reset();
        if (this._coloring != null) {
            this._coloring.resetDomain(this._domain);
        }
        if (this._baseColoring != null) {
            this._useColoring = this._baseColoring.findRelatedColoring(this._domain);
        }
    }

    public void reset() {
        this.nextIndex = 0;
        this._pvalue = -1;
        if (this.domSize == 0) {
            this.maxIndex = 0;
            return;
        }
        if (this._useColoring == null) {
            this.maxIndex = 1;
            return;
        }
        this._useColoring.coloring(this._domain, this._colors);
        this.maxIndex = 1;
        int i = 1;
        while (i < this.numElems) {
            if (this._colors[i - 1] != this._colors[i]) {
                ++this.maxIndex;
            }
            ++i;
        }
    }

    public void terminate() {
        this.nextIndex = this.maxIndex;
    }

    public boolean hasMoreElements() {
        return this.nextIndex < this.maxIndex;
    }

    public Value nextValue() throws NoSuchElementException {
        return this.nextScalar();
    }

    public ScalarValue nextScalar() throws NoSuchElementException {
        if (this.nextIndex == this.maxIndex) {
            throw new NoSuchElementException();
        }
        if (this.nextIndex == 0) {
            this.val.setAdjValue(0);
            this._pvalue = 0;
        } else {
            int i = this._pvalue + 1;
            while (i < this.domSize) {
                if (this._colors[i - 1] != this._colors[i]) {
                    this._pvalue = i;
                    this.val.setAdjValue(i);
                    break;
                }
                ++i;
            }
        }
        ++this.nextIndex;
        if (this.mapResult) {
            try {
                this.map.apply(this.val, this.result);
            }
            catch (ValueError valueError) {
                throw new NoSuchElementException();
            }
        }
        if (this._coloring != null) {
            this._coloring.updateColoring(this.result);
        }
        return this.result;
    }

    public double pctCompleted() {
        if (this.maxIndex == 0) {
            return 1.0;
        }
        return (double)this.nextIndex / (double)this.maxIndex;
    }

    public long totalValues() {
        return this.maxIndex;
    }

    public long totalGenValues() {
        if (this.maxIndex <= 0) {
            return 1L;
        }
        return this.maxIndex;
    }

    public long valuesGend() {
        return this.nextIndex;
    }
}

