/*
 * Decompiled with CFR 0.152.
 */
package ladybug.selenum;

import java.util.NoSuchElementException;
import ladybug.engine.FunctionValue;
import ladybug.engine.ScalarValue;
import ladybug.engine.Scope;
import ladybug.engine.SetValue;
import ladybug.engine.Value;
import ladybug.engine.ValueError;
import ladybug.parse.RelationType;
import ladybug.parse.ScalarType;
import ladybug.parse.Type;
import ladybug.parse.Variable;
import ladybug.selenum.Generator;
import ladybug.selenum.ScalarGenerator;

public class ScalarExhGenerator
extends Generator
implements ScalarGenerator {
    private ScalarValue val;
    private ScalarValue scratch;
    private ScalarValue result;
    private FunctionValue map;
    private int nextIndex;
    private int maxIndex;
    private int domSize;
    private boolean mapResult;

    public ScalarExhGenerator(ScalarValue value, Variable var, Type type, Scope scope) {
        super(var, type);
        ScalarType sct = (ScalarType)type;
        this.nextIndex = 0;
        this.maxIndex = (int)sct.numValues(scope);
        this.result = value;
        this.mapResult = false;
        this.domSize = this.maxIndex;
        this.map = new FunctionValue(new RelationType(sct, sct, true, true, false, false, false), this.domSize, this.domSize);
        this.scratch = new ScalarValue(sct, scope);
        this.val = this.result;
        this.terminate();
    }

    public void setValue(ScalarValue value) {
        this.result = value;
        if (!this.mapResult) {
            this.val = value;
        }
    }

    public void setDomain(SetValue dom) {
        if (this._coloring != null) {
            this._coloring.resetDomain(dom);
        }
        this.maxIndex = dom.card();
        this.domSize = dom.maxElem() + 1;
        if (this.domSize == this.maxIndex) {
            this.mapResult = false;
            this.val = this.result;
        } else {
            this.mapResult = true;
            this.val = this.scratch;
            int i = 0;
            int j = 0;
            while (i < this.domSize) {
                if (dom.hasElement(i)) {
                    this.map.addMapping(j, i);
                    ++j;
                }
                ++i;
            }
        }
    }

    public void reset() {
        this.nextIndex = 0;
    }

    public void terminate() {
        this.nextIndex = this.maxIndex;
    }

    public boolean hasMoreElements() {
        return this.nextIndex < this.maxIndex;
    }

    public Value nextValue() throws NoSuchElementException {
        return this.nextScalar();
    }

    public ScalarValue nextScalar() throws NoSuchElementException {
        if (this.nextIndex == this.maxIndex) {
            throw new NoSuchElementException();
        }
        this.val.setAdjValue(this.nextIndex);
        ++this.nextIndex;
        if (this.mapResult) {
            try {
                this.map.apply(this.val, this.result);
            }
            catch (ValueError valueError) {
                throw new NoSuchElementException();
            }
        }
        if (this._coloring != null) {
            this._coloring.updateColoring(this.result);
        }
        return this.result;
    }

    public double pctCompleted() {
        if (this.maxIndex == 0) {
            return 1.0;
        }
        return (double)this.nextIndex / (double)this.maxIndex;
    }

    public long totalValues() {
        return this.maxIndex;
    }

    public long totalGenValues() {
        if (this.maxIndex <= 0) {
            return 1L;
        }
        return this.maxIndex;
    }

    public long valuesGend() {
        return this.nextIndex;
    }
}

