/*
 * Decompiled with CFR 0.152.
 */
package ladybug.selenum;

import java.util.NoSuchElementException;
import ladybug.engine.ScalarValue;
import ladybug.engine.Scope;
import ladybug.engine.SetValue;
import ladybug.engine.Value;
import ladybug.parse.ScalarType;
import ladybug.parse.SetType;
import ladybug.parse.Type;
import ladybug.parse.Variable;
import ladybug.selenum.Generator;
import ladybug.selenum.ScalarGenerator;

public class ScalarBndGenerator
extends Generator
implements ScalarGenerator {
    private ScalarValue val;
    private boolean initialized;
    private int domSize;
    private long maxIndex;
    private SetValue forb;
    private SetValue domSet;
    private SetValue domEnum;
    private ScalarGenerator gen;

    public ScalarBndGenerator(ScalarValue value, Variable var, Type type, Scope scope, ScalarGenerator gen2, SetValue forbidden) {
        super(var, type);
        ScalarType sct = (ScalarType)type;
        SetType st = new SetType(sct);
        this.forb = forbidden;
        this.gen = gen2;
        this.initialized = false;
        this.domSize = (int)sct.numValues(scope);
        this.val = value;
        this.gen.setValue(value);
        this.setTypeGenerated(gen2.typeGenerated());
        this.maxIndex = this.gen.totalValues();
        this.domSet = new SetValue(st, this.domSize);
        this.domSet.fullSet();
        this.domEnum = new SetValue(st, this.domSize);
    }

    public void setValue(ScalarValue value) {
        this.val = value;
        this.gen.setValue(value);
    }

    public void setDomain(SetValue dom) {
        if (this._coloring != null) {
            this._coloring.resetDomain(dom);
        }
        this.domSet = dom;
        this.domSize = dom.maxElem() + 1;
    }

    public void reset() {
        this.initialized = false;
        this.gen.reset();
    }

    public void terminate() {
        this.gen.terminate();
    }

    public boolean hasMoreElements() {
        if (!this.initialized) {
            this.initializeBounds();
        }
        return this.gen.hasMoreElements();
    }

    public Value nextValue() throws NoSuchElementException {
        return this.nextScalar();
    }

    public ScalarValue nextScalar() throws NoSuchElementException {
        if (!this.initialized) {
            this.initializeBounds();
        }
        this.gen.nextScalar();
        if (this._coloring != null) {
            this._coloring.updateColoring(this.val);
        }
        return this.val;
    }

    public double pctCompleted() {
        return this.gen.pctCompleted();
    }

    public long totalValues() {
        return this.maxIndex;
    }

    public long totalGenValues() {
        return this.gen.totalGenValues();
    }

    public long valuesGend() {
        return this.gen.valuesGend();
    }

    private void initializeBounds() {
        this.initialized = true;
        if (this.forb != null) {
            this.domSet.diff(this.forb, this.domEnum);
            this.gen.setDomain(this.domEnum);
        }
        this.gen.reset();
    }
}

