/*
 * Decompiled with CFR 0.152.
 */
package ladybug.selenum;

import java.util.NoSuchElementException;
import ladybug.engine.FunctionValue;
import ladybug.engine.RelationValue;
import ladybug.engine.Scope;
import ladybug.engine.SetValue;
import ladybug.engine.Value;
import ladybug.parse.RelationType;
import ladybug.parse.ScalarType;
import ladybug.parse.SetType;
import ladybug.parse.Type;
import ladybug.parse.Variable;
import ladybug.selenum.Generator;
import ladybug.selenum.RelationGenerator;
import ladybug.selenum.SetGenerator;
import ladybug.selenum.SetIsoGenerator;
import ladybug.selenum.isomorph.Coloring;

public class RelIsoGenerator
extends Generator
implements RelationGenerator {
    private Coloring[] ranColors;
    private Coloring domainColoring;
    private Coloring _baseColoring;
    private ScalarType dtype;
    private ScalarType rtype;
    private SetValue _range;
    private SetValue _domain;
    private RelationValue val;
    private RelationValue scratch;
    private RelationValue result;
    private FunctionValue rangeMap;
    private SetValue genDomain;
    private SetValue restrRange;
    private SetGenerator domGen;
    private SetGenerator[] ranGens;
    private SetValue[] genRanges;
    private SetValue[] subRanges;
    private int[][] _dcolors;
    private int[][] _rcolors;
    private int[] _numColors;
    private int[] domElems;
    private long nextIndex;
    private long maxIndex;
    private int domSize;
    private int ranSize;
    private int numElems;
    private int numDomElems;
    private boolean mapResult;
    private boolean computed;
    private boolean sameTypes;

    public RelIsoGenerator(RelationValue value, Variable var, Type type, Scope scope, Coloring baseColoring) {
        super(var, type);
        this._baseColoring = baseColoring;
        RelationType rt = (RelationType)type;
        this.dtype = rt.domain();
        this._domain = this.dtype.universe(scope);
        this.rtype = rt.range();
        this._range = this.rtype.universe(scope);
        this.sameTypes = this.dtype.equiv(this.rtype);
        this.nextIndex = 0L;
        this.domSize = (int)this.dtype.numValues(scope);
        this.ranSize = (int)this.rtype.numValues(scope);
        this._rcolors = new int[this.domSize][this.ranSize];
        this._numColors = new int[this.domSize];
        this._dcolors = new int[this.domSize][this.domSize];
        this.domElems = new int[this.domSize];
        this.genDomain = new SetValue(new SetType(this.dtype), this.domSize);
        this.domGen = new SetIsoGenerator(this.genDomain, null, this.genDomain.getType(), scope, baseColoring);
        this.ranColors = new Coloring[this.domSize];
        this.ranGens = new SetGenerator[this.domSize];
        this.genRanges = new SetValue[this.domSize];
        this.domainColoring = baseColoring.extend(this._domain);
        SetType ranType = new SetType(this.rtype);
        this.subRanges = new SetValue[this.domSize];
        this.restrRange = new SetValue(new SetType(this.rtype), this.ranSize);
        int i = 0;
        while (i < this.domSize) {
            this.ranColors[i] = this.domainColoring.extend(this._domain, this._range);
            this.genRanges[i] = new SetValue(ranType, scope);
            this.subRanges[i] = new SetValue(ranType, scope);
            this.ranGens[i] = new SetIsoGenerator(this.genRanges[i], null, ranType, scope, this.ranColors[i]);
            this.ranGens[i].setMinCard(1);
            ++i;
        }
        this.result = value;
        this.mapResult = false;
        this.numElems = this.domSize;
        this.maxIndex = this.domSize;
        this.rangeMap = new FunctionValue(new RelationType(this.rtype, this.rtype, true, true, false, false, false), this.domSize, this.domSize);
        this.scratch = new RelationValue(new RelationType(this.dtype, this.rtype, false, false, false, false, false), this.domSize, this.ranSize);
        this.val = this.result;
        rt = new RelationType(this.dtype, this.rtype);
        this.setTypeGenerated(rt);
        this.terminate();
    }

    public void setValue(RelationValue value) {
        this.result = value;
        if (!this.mapResult) {
            this.val = value;
        }
    }

    public void setDomain(SetValue dom) {
        this.domGen.setDomain(dom);
        this._domain = dom;
        if (this._coloring != null) {
            this._coloring.getPrevColoring().resetDomain(dom);
        }
        this.reset();
    }

    public void setRange(SetValue ran) {
        int i = 0;
        while (i < this.domSize) {
            this.ranGens[i].setDomain(ran);
            ++i;
        }
        if (this._coloring != null) {
            this._coloring.resetDomain(ran);
        }
        this._range = ran;
        this.reset();
    }

    public void reset() {
        this.nextIndex = 0L;
        if (this.ranSize == 0) {
            this.maxIndex = 0L;
            return;
        }
        this.domainColoring.reset();
        this.domainColoring.coloring(this._domain, this._dcolors[0]);
        this._baseColoring.coloring(this._range, this._rcolors[0]);
        this.domGen.reset();
        this.domGen.nextSet();
        this.val.init();
        this.computed = true;
        this.nextIndex = 1L;
        this.numDomElems = 0;
        this.maxIndex = 1 << this.ranSize * this.domSize;
    }

    public void terminate() {
        this.nextIndex = this.maxIndex;
    }

    public boolean hasMoreElements() {
        if (this.computed) {
            return true;
        }
        if (this.nextIndex >= this.maxIndex) {
            return false;
        }
        return this.computeNextRelation();
    }

    public Value nextValue() throws NoSuchElementException {
        return this.nextRelation();
    }

    public RelationValue nextRelation() throws NoSuchElementException {
        if (!this.computed) {
            if (this.nextIndex == this.maxIndex) {
                throw new NoSuchElementException();
            }
            if (!this.computeNextRelation()) {
                throw new NoSuchElementException();
            }
        }
        this.computed = false;
        if (this._coloring != null) {
            this._coloring.updateColoring(this.result);
        }
        return this.result;
    }

    public boolean computeNextRelation() {
        if (this.computed) {
            return true;
        }
        if (this.chooseNewEdgeSet()) {
            ++this.nextIndex;
            this.computed = true;
            return true;
        }
        return this.chooseNewDomain();
    }

    public boolean chooseNewDomain() {
        if (!this.domGen.hasMoreElements()) {
            this.computed = false;
            return false;
        }
        this.genDomain = this.domGen.nextSet();
        this.numDomElems = 0;
        int i = 0;
        while (i < this.domSize) {
            if (this.genDomain.hasElement(i)) {
                this.domElems[this.numDomElems] = i;
                ++this.numDomElems;
            }
            ++i;
        }
        this.val.init();
        this.domainColoring.updateColoring(this.genDomain);
        this.domainColoring.coloring(this._domain, this._dcolors[0]);
        this.domainColoring.distinguish(this.dtype, this.domElems[0]);
        this.ranColors[0].reset();
        this.ranGens[0].reset();
        this.ranColors[0].coloring(this._range, this._rcolors[0]);
        if (!this.ranGens[0].hasMoreElements()) {
            this.computed = false;
            return false;
        }
        this.ranGens[0].nextSet();
        this.val.setMapping(this.domElems[0], this.genRanges[0].bits());
        i = 1;
        while (i < this.numDomElems) {
            this.domainColoring.updateColoring(this.genDomain);
            this.ranColors[i].updateColoring(this.val);
            this.ranColors[i].coloring(this._domain, this._dcolors[i]);
            this.domainColoring.distinguish(this.dtype, this.domElems[i]);
            this.ranColors[i].updateColoring(this.val);
            this.ranColors[i].coloring(this._range, this._rcolors[i]);
            if (this._dcolors[i - 1][this.domElems[i - 1]] == this._dcolors[i - 1][this.domElems[i]]) {
                this.ranGens[i].setMaxCard(this.genRanges[i - 1].card());
            } else {
                this.ranGens[i].setMaxCard(this.ranSize);
            }
            this.ranGens[i].reset();
            if (!this.ranGens[i].hasMoreElements()) {
                this.computed = false;
                return false;
            }
            this.ranGens[i].nextSet();
            this.val.setMapping(this.domElems[i], this.genRanges[i].bits());
            ++i;
        }
        ++this.nextIndex;
        this.computed = true;
        return true;
    }

    public boolean chooseNewEdgeSet() {
        if (this.numDomElems == 0) {
            return false;
        }
        int d = this.numDomElems - 1;
        block0: while (d < this.numDomElems) {
            this.val.setMapping(this.domElems[d], 0);
            do {
                if (!this.ranGens[d].hasMoreElements()) {
                    if (d <= 0) {
                        return false;
                    }
                    this.ranGens[d].reset();
                    --d;
                    continue block0;
                }
                this.ranGens[d].nextSet();
            } while (d != 0 && this._dcolors[d - 1][this.domElems[d]] == this._dcolors[d - 1][this.domElems[d - 1]] && RelIsoGenerator.preceeds(this.genRanges[d], this.genRanges[d - 1], this.sameTypes, this.domElems[d], this.domElems[d - 1]));
            this.val.setMapping(this.domElems[d], this.genRanges[d].bits());
            if (++d >= this.numDomElems) break;
            this.domainColoring.updateColoring(this.genDomain);
            this.ranColors[d].updateColoring(this.val);
            this.ranColors[d].coloring(this._domain, this._dcolors[d]);
            this.domainColoring.distinguish(this.dtype, this.domElems[d]);
            this.ranColors[d].updateColoring(this.val);
            this.ranColors[d].coloring(this._range, this._rcolors[d]);
            if (this._dcolors[d - 1][this.domElems[d - 1]] == this._dcolors[d - 1][this.domElems[d]]) {
                this.ranGens[d].setMaxCard(this.genRanges[d - 1].card());
            } else {
                this.ranGens[d].setMaxCard(this.ranSize);
            }
            this.ranGens[d].reset();
        }
        return true;
    }

    private static boolean preceeds(SetValue s1, SetValue s2, boolean sameTypes, int d1, int d2) {
        if (s1.card() > s2.card()) {
            return true;
        }
        if (s2.card() > s1.card()) {
            return false;
        }
        int i = 0;
        while (i <= s1.maxElem()) {
            if (sameTypes && i == d1) {
                if (s1.hasElement(i)) {
                    if (!s2.hasElement(d2)) {
                        return true;
                    }
                } else if (s2.hasElement(d2)) {
                    return false;
                }
                if (s2.hasElement(i)) {
                    if (!s1.hasElement(d2)) {
                        return false;
                    }
                } else if (s1.hasElement(d2)) {
                    return true;
                }
            } else if (!sameTypes || i != d2) {
                if (s1.hasElement(i)) {
                    if (!s2.hasElement(i)) {
                        return true;
                    }
                } else if (s2.hasElement(i)) {
                    return false;
                }
            }
            ++i;
        }
        return false;
    }

    private void computeRestr(int ix) {
        int j;
        if (this.genRanges[ix - 1].isEmpty()) {
            this.restrRange.init();
            return;
        }
        this.restrRange.fullSet();
        int startColor = 0;
        boolean hasColor = this.genRanges[ix - 1].hasElement(0);
        if (hasColor) {
            this.restrRange.removeElement(0);
        }
        int i = 1;
        while (i < this.ranSize) {
            if (this._rcolors[ix - 1][i] != this._rcolors[ix - 1][i - 1]) {
                if (!hasColor) {
                    j = startColor;
                    while (j < i) {
                        this.restrRange.removeElement(j);
                        ++j;
                    }
                }
                startColor = i;
                hasColor = false;
            }
            if (this.genRanges[ix - 1].hasElement(i)) {
                hasColor = true;
            }
            if (hasColor) {
                this.restrRange.removeElement(i);
            }
            ++i;
        }
        if (!hasColor) {
            j = startColor;
            while (j < this.ranSize) {
                this.restrRange.removeElement(j);
                ++j;
            }
        }
    }

    public double pctCompleted() {
        if (this.maxIndex == 0L) {
            return 1.0;
        }
        return (double)this.nextIndex / (double)this.maxIndex;
    }

    public long totalValues() {
        return this.maxIndex;
    }

    public long totalGenValues() {
        if (this.maxIndex <= 0L) {
            return 1L;
        }
        return this.maxIndex;
    }

    public long valuesGend() {
        return this.nextIndex;
    }
}

