/*
 * Decompiled with CFR 0.152.
 */
package ladybug.selenum;

import java.util.NoSuchElementException;
import ladybug.engine.RelationValue;
import ladybug.engine.Scope;
import ladybug.engine.SetValue;
import ladybug.engine.Value;
import ladybug.parse.RelationType;
import ladybug.parse.SetType;
import ladybug.parse.Type;
import ladybug.parse.Variable;
import ladybug.selenum.Generator;
import ladybug.selenum.RelationGenerator;

public class RelBndGenerator
extends Generator
implements RelationGenerator {
    private RelationValue val;
    private boolean initialized;
    private long maxIndex;
    private int domSize;
    private SetValue domSet;
    private SetValue domEnum;
    private int ranSize;
    private SetValue ranSet;
    private SetValue ranEnum;
    private SetValue rForb;
    private SetValue dForb;
    private RelationGenerator gen;

    public RelBndGenerator(RelationValue value, Variable var, Type type, Scope scope, RelationGenerator gen2, SetValue domForbidden, SetValue ranForbidden) {
        super(var, type);
        RelationType rt = (RelationType)type;
        this.dForb = domForbidden;
        this.rForb = ranForbidden;
        this.gen = gen2;
        this.initialized = false;
        this.domSize = (int)rt.domain().numValues(scope);
        this.domSet = new SetValue(new SetType(rt.domain()), this.domSize);
        this.domSet.fullSet();
        this.domEnum = new SetValue(new SetType(rt.domain()), this.domSize);
        this.ranSize = (int)rt.range().numValues(scope);
        this.ranSet = new SetValue(new SetType(rt.range()), this.ranSize);
        this.ranSet.fullSet();
        this.ranEnum = new SetValue(new SetType(rt.range()), this.ranSize);
        this.val = value;
        this.gen.setValue(value);
        this.setTypeGenerated(gen2.typeGenerated());
        this.maxIndex = this.gen.totalValues();
    }

    public void setValue(RelationValue value) {
        this.gen.setValue(value);
        this.val = value;
    }

    public void setDomain(SetValue dom) {
        if (this._coloring != null) {
            this._coloring.getPrevColoring().resetDomain(dom);
        }
        this.domSet = dom;
        this.domSize = this.domSet.maxElem() + 1;
    }

    public void setRange(SetValue ran) {
        if (this._coloring != null) {
            this._coloring.resetDomain(ran);
        }
        this.ranSet = ran;
        this.ranSize = ran.maxElem() + 1;
    }

    public void reset() {
        this.initialized = false;
        this.gen.reset();
    }

    public void terminate() {
        this.gen.terminate();
    }

    public boolean hasMoreElements() {
        if (!this.initialized) {
            this.initializeBounds();
        }
        return this.gen.hasMoreElements();
    }

    public Value nextValue() throws NoSuchElementException {
        return this.nextRelation();
    }

    public RelationValue nextRelation() throws NoSuchElementException {
        if (!this.initialized) {
            this.initializeBounds();
        }
        this.gen.nextRelation();
        if (this._coloring != null) {
            this._coloring.updateColoring(this.val);
        }
        return this.val;
    }

    public double pctCompleted() {
        return this.gen.pctCompleted();
    }

    public long totalValues() {
        return this.maxIndex;
    }

    public long totalGenValues() {
        return this.gen.totalGenValues();
    }

    public long valuesGend() {
        return this.gen.valuesGend();
    }

    private void initializeBounds() {
        this.initialized = true;
        if (this.dForb != null) {
            this.domSet.diff(this.dForb, this.domEnum);
            this.gen.setDomain(this.domEnum);
        }
        if (this.rForb != null) {
            this.ranSet.diff(this.rForb, this.ranEnum);
            this.gen.setRange(this.ranEnum);
        }
        this.gen.reset();
    }
}

