/*
 * Decompiled with CFR 0.152.
 */
package ladybug.selenum;

import java.util.Enumeration;
import java.util.Vector;
import ladybug.engine.DerivedVars;
import ladybug.engine.EnumVars;
import ladybug.engine.Scope;
import ladybug.engine.VarOrder;
import ladybug.parse.Tree;
import ladybug.parse.VarEnumeration;
import ladybug.parse.Variable;
import ladybug.parse.VariableList;
import ladybug.selenum.OCVarOrder;
import ladybug.selenum.OrderConstraint;

public class OrderConstraintList {
    private Vector _constraints = new Vector();

    public void addConstraint(OrderConstraint oc) {
        this._constraints.addElement(oc);
    }

    public void removeConstraint(OrderConstraint oc) {
        this._constraints.removeElement(oc);
    }

    public Enumeration constraints() {
        return this._constraints.elements();
    }

    public void merge(OrderConstraintList ocl) {
        Enumeration e = ocl.constraints();
        while (e.hasMoreElements()) {
            OrderConstraint oc = (OrderConstraint)e.nextElement();
            this.addConstraint(oc);
        }
    }

    public VarOrder computeOrdering(EnumVars enums, DerivedVars derived, Scope scope) {
        VariableList vars = new VariableList();
        double numCases = enums.numValues(scope);
        Enumeration e = this.constraints();
        while (e.hasMoreElements()) {
            double savings;
            OrderConstraint oc = (OrderConstraint)e.nextElement();
            if (oc.reduction() == 1.0) continue;
            Variable var = oc.baseVar();
            if (derived != null && derived.isDerived(var)) continue;
            VariableList pred = oc.predecessors();
            if (derived != null) {
                pred = derived.extractVars(pred);
            }
            if (!oc.reducesSelf() && pred.size() == enums.numVars() - 1) continue;
            double possibles = oc.reducesSelf() ? 1.0 : (double)var.getType().numValues(scope);
            VarEnumeration ve = pred.elements();
            while (ve.hasMoreElements()) {
                Variable pvar = ve.nextVar();
                possibles *= (double)pvar.getType().numValues(scope);
            }
            double remainingCases = numCases / possibles;
            double cumulative = savings = remainingCases / oc.reduction();
            if (vars.contains(var)) {
                vars.setTag(var, new Double(cumulative += ((Double)vars.tag(var)).doubleValue()));
            } else {
                vars.addVar(var, new Double(cumulative));
            }
            ve = pred.elements();
            savings *= numCases;
            while (ve.hasMoreElements()) {
                Variable pvar = ve.nextVar();
                cumulative = savings;
                if (vars.contains(pvar)) {
                    vars.setTag(pvar, new Double(cumulative += ((Double)vars.tag(pvar)).doubleValue()));
                    continue;
                }
                vars.addVar(pvar, new Double(cumulative));
            }
        }
        return new OCVarOrder(vars, this, enums, derived);
    }

    public String toString() {
        Enumeration e = this.constraints();
        String s = "Order Constraints" + Tree.linesep();
        while (e.hasMoreElements()) {
            s = String.valueOf(s) + "  " + e.nextElement().toString() + Tree.linesep();
        }
        return s;
    }

    boolean preferences(Variable[] varlist, int first, int second, DerivedVars derived) {
        double weight = 1.0;
        Enumeration e = this.constraints();
        block0: while (e.hasMoreElements()) {
            int i;
            Variable v;
            VarEnumeration ve;
            VariableList pred;
            OrderConstraint oc = (OrderConstraint)e.nextElement();
            if (oc.baseVar() == varlist[first]) {
                pred = oc.predecessors();
                if (derived != null) {
                    pred = derived.extractVars(pred);
                }
                if (!pred.contains(varlist[second])) continue;
                ve = pred.elements();
                block1: while (ve.hasMoreElements()) {
                    v = ve.nextVar();
                    if (v == varlist[second]) continue;
                    i = 0;
                    while (i < first) {
                        if (varlist[i] == v) continue block1;
                        ++i;
                    }
                    continue block0;
                }
                weight *= oc.reduction();
                continue;
            }
            if (oc.baseVar() != varlist[second]) continue;
            pred = oc.predecessors();
            if (derived != null) {
                pred = derived.extractVars(pred);
            }
            if (!pred.contains(varlist[first])) continue;
            ve = pred.elements();
            block3: while (ve.hasMoreElements()) {
                v = ve.nextVar();
                if (v == varlist[first]) continue;
                i = 0;
                while (i < second) {
                    if (varlist[i] == v) continue block3;
                    ++i;
                }
                continue block0;
            }
            weight /= oc.reduction();
        }
        return weight < 1.0;
    }
}

