/*
 * Decompiled with CFR 0.152.
 */
package ladybug.selenum;

import ladybug.parse.Variable;
import ladybug.parse.VariableList;

public class OrderConstraint {
    private Variable _base;
    private VariableList _pred;
    private double _reduct;
    private boolean _self;

    public OrderConstraint(Variable var, VariableList predecessors, double reductionFactor, boolean reducesSelf) {
        this._base = var;
        this._pred = predecessors.copy();
        this._reduct = reductionFactor;
        this._self = reducesSelf;
    }

    public OrderConstraint copy() {
        return new OrderConstraint(this._base, this._pred, this._reduct, this._self);
    }

    public Variable baseVar() {
        return this._base;
    }

    public VariableList predecessors() {
        return this._pred;
    }

    public double reduction() {
        return this._reduct;
    }

    public boolean reducesSelf() {
        return this._self;
    }

    public String toString() {
        return String.valueOf(this._base.getName()) + " : " + String.valueOf(this._reduct) + (this._self ? "+ if after " : " if after ") + this._pred.toString();
    }
}

