/*
 * Decompiled with CFR 0.152.
 */
package ladybug.selenum;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Vector;
import ladybug.engine.FunctionValue;
import ladybug.engine.LadyBug;
import ladybug.engine.RelationValue;
import ladybug.engine.Scope;
import ladybug.engine.SetValue;
import ladybug.engine.Value;
import ladybug.engine.ValueError;
import ladybug.parse.GivenType;
import ladybug.parse.ParseError;
import ladybug.parse.RelationType;
import ladybug.parse.ScalarType;
import ladybug.parse.SetType;
import ladybug.parse.SourceLoc;
import ladybug.parse.Tree;
import ladybug.parse.TypeList;
import ladybug.parse.Variable;
import ladybug.parse.VariableList;
import ladybug.selenum.ChainExhGenerator;
import ladybug.selenum.ChainIsoGenerator;
import ladybug.selenum.ColorMapper;
import ladybug.selenum.DegreeMapper;
import ladybug.selenum.FuncBijExhGenerator;
import ladybug.selenum.FuncExhGenerator;
import ladybug.selenum.FuncIsoGenerator;
import ladybug.selenum.FunctionGenerator;
import ladybug.selenum.RelExhGenerator;
import ladybug.selenum.RelIsoGenerator;
import ladybug.selenum.RelationGenerator;
import ladybug.selenum.SetExhGenerator;
import ladybug.selenum.SetGenerator;
import ladybug.selenum.SetIsoGenerator;
import ladybug.selenum.isomorph.AtomicPolicy;
import ladybug.selenum.isomorph.ColorPolicy;
import ladybug.selenum.isomorph.Coloring;
import ladybug.selenum.isomorph.GlobalAtomicPolicy;
import ladybug.selenum.isomorph.StructuralPolicy;

public class IsoTester {
    static boolean showMappings = false;
    static boolean showIsoFree = false;
    static boolean countDups = true;
    static PrintStream outFile = System.out;
    static Vector allColors = new Vector();
    static SetValue dom1;
    static SetValue dom2;
    static SetValue ran1;
    static SetValue ran2;
    static SetValue[] dsets1;
    static SetValue[] rsets1;
    static SetValue[] dsets2;
    static SetValue[] rsets2;
    static int maxBound;
    static int totalValues;
    static int totalMissing;
    static int totalColors;
    static int totalIsos;

    /*
     * Unable to fully structure code
     */
    public static boolean areIsomorphs(FunctionValue fv1, FunctionValue fv2, Scope scope, Coloring coloring) {
        block14: {
            rt = (RelationType)fv1.getType();
            fv2.range(IsoTester.ran2);
            fv1.range(IsoTester.ran1);
            if (IsoTester.ran1.card() != IsoTester.ran2.card()) {
                return false;
            }
            fv2.domain(IsoTester.dom2);
            fv1.domain(IsoTester.dom1);
            if (IsoTester.dom1.card() != IsoTester.dom2.card()) {
                return false;
            }
            if (IsoTester.showMappings) {
                IsoTester.outFile.println("Testing isomorphism of");
                IsoTester.outFile.println(fv1.toString());
                IsoTester.outFile.println(fv2.toString());
            }
            genLeft = IsoTester.findBijGen(scope, rt.domain(), coloring);
            genRight = null;
            rightMap = null;
            scr1 = new FunctionValue(rt, scope);
            scr2 = new FunctionValue(rt, scope);
            sameTypes = false;
            if (rt.domain() == rt.range()) {
                sameTypes = true;
                rightMap = new FunctionValue(rt, scope);
            } else {
                genLeft.setDomain(IsoTester.dom2);
                genLeft.setRange(IsoTester.dom1);
                genRight = IsoTester.findBijGen(scope, rt.range(), coloring);
                genRight.setDomain(IsoTester.ran1);
                genRight.setRange(IsoTester.ran2);
            }
            genLeft.reset();
            if (!sameTypes) ** GOTO lbl63
            while (genLeft.hasMoreElements()) {
                leftMap = genLeft.nextFunction();
                if (IsoTester.showMappings) {
                    IsoTester.outFile.println("Mapping lhs: " + leftMap.toString());
                }
                leftMap.compose(fv1, scr1);
                scr1.domain(IsoTester.dom1);
                if (!IsoTester.dom1.equals(IsoTester.dom2)) continue;
                try {
                    leftMap.transpose(rightMap);
                }
                catch (ValueError v0) {
                    continue;
                }
                if (IsoTester.showMappings) {
                    IsoTester.outFile.println("Mapping rhs: " + rightMap.toString());
                }
                scr1.compose(rightMap, scr2);
                if (!scr2.equals(fv2)) continue;
                return true;
            }
            break block14;
lbl-1000:
            // 1 sources

            {
                leftMap = genLeft.nextFunction();
                if (IsoTester.showMappings) {
                    IsoTester.outFile.println("Mapping lhs: " + leftMap.toString());
                }
                leftMap.compose(fv1, scr1);
                scr1.domain(IsoTester.dom1);
                if (!IsoTester.dom1.equals(IsoTester.dom2)) continue;
                genRight.reset();
                while (genRight.hasMoreElements()) {
                    rightMap = genRight.nextFunction();
                    if (IsoTester.showMappings) {
                        IsoTester.outFile.println("Mapping rhs: " + rightMap.toString());
                    }
                    scr1.compose(rightMap, scr2);
                    if (!scr2.equals(fv2)) continue;
                    return true;
                }
lbl63:
                // 3 sources

                ** while (genLeft.hasMoreElements())
            }
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean areIsomorphs(RelationValue fv1, RelationValue fv2, Scope scope, Coloring coloring) {
        block28: {
            rt = (RelationType)fv1.getType();
            fv2.range(IsoTester.ran2);
            fv1.range(IsoTester.ran1);
            if (IsoTester.ran1.card() != IsoTester.ran2.card()) {
                return false;
            }
            fv2.domain(IsoTester.dom2);
            fv1.domain(IsoTester.dom1);
            if (IsoTester.dom1.card() != IsoTester.dom2.card()) {
                return false;
            }
            i = 1;
            while (i <= IsoTester.dom1.card()) {
                IsoTester.rsets1[i - 1].init();
                IsoTester.rsets2[i - 1].init();
                ++i;
            }
            i = 1;
            while (i <= IsoTester.ran1.card()) {
                IsoTester.dsets1[i - 1].init();
                IsoTester.dsets2[i - 1].init();
                ++i;
            }
            i = 0;
            while (i < IsoTester.maxBound) {
                degree = fv1.ddegree(i);
                if (degree > 0) {
                    IsoTester.dsets1[degree - 1].addElement(i);
                }
                if ((degree = fv2.ddegree(i)) > 0) {
                    IsoTester.dsets2[degree - 1].addElement(i);
                }
                if ((degree = fv1.rdegree(i)) > 0) {
                    IsoTester.rsets1[degree - 1].addElement(i);
                }
                if ((degree = fv2.rdegree(i)) > 0) {
                    IsoTester.rsets2[degree - 1].addElement(i);
                }
                ++i;
            }
            i = 0;
            while (i < IsoTester.ran1.card()) {
                if (IsoTester.dsets1[i].card() != IsoTester.dsets2[i].card()) {
                    return false;
                }
                ++i;
            }
            i = 0;
            while (i < IsoTester.dom1.card()) {
                if (IsoTester.rsets1[i].card() != IsoTester.rsets2[i].card()) {
                    return false;
                }
                ++i;
            }
            if (IsoTester.showMappings) {
                IsoTester.outFile.println("Testing isomorphism of");
                IsoTester.outFile.println(fv1.toString());
                IsoTester.outFile.println(fv2.toString());
            }
            if ((genLeft = IsoTester.findBijGen(scope, rt.domain(), coloring, IsoTester.dsets2, IsoTester.dsets1, IsoTester.ran1.card())) == null) {
                return false;
            }
            genRight = null;
            rightMap = null;
            scr1 = new RelationValue(rt, scope);
            scr2 = new RelationValue(rt, scope);
            sameTypes = false;
            if (rt.domain() == rt.range()) {
                sameTypes = true;
                rightMap = new FunctionValue(rt, scope);
            } else {
                genLeft.setDomain(IsoTester.dom2);
                genLeft.setRange(IsoTester.dom1);
                genRight = IsoTester.findBijGen(scope, rt.range(), coloring, IsoTester.rsets1, IsoTester.rsets2, IsoTester.dom1.card());
                if (genRight == null) {
                    return false;
                }
                genRight.setDomain(IsoTester.ran1);
                genRight.setRange(IsoTester.ran2);
            }
            genLeft.reset();
            if (!sameTypes) ** GOTO lbl105
            while (genLeft.hasMoreElements()) {
                leftMap = genLeft.nextFunction();
                if (IsoTester.showMappings) {
                    IsoTester.outFile.println("Mapping lhs: " + leftMap.toString());
                }
                leftMap.compose(fv1, scr1);
                scr1.domain(IsoTester.dom1);
                if (!IsoTester.dom1.equals(IsoTester.dom2)) continue;
                try {
                    leftMap.transpose(rightMap);
                }
                catch (ValueError v0) {
                    continue;
                }
                if (IsoTester.showMappings) {
                    IsoTester.outFile.println("Mapping rhs: " + rightMap.toString());
                }
                scr1.compose(rightMap, scr2);
                if (IsoTester.showMappings) {
                    IsoTester.outFile.println("Yields " + scr2.toString());
                }
                if (!scr2.equals(fv2)) continue;
                return true;
            }
            break block28;
lbl-1000:
            // 1 sources

            {
                leftMap = genLeft.nextFunction();
                if (IsoTester.showMappings) {
                    IsoTester.outFile.println("Mapping lhs: " + leftMap.toString());
                }
                leftMap.compose(fv1, scr1);
                scr1.domain(IsoTester.dom1);
                if (!IsoTester.dom1.equals(IsoTester.dom2)) continue;
                genRight.reset();
                while (genRight.hasMoreElements()) {
                    rightMap = genRight.nextFunction();
                    if (IsoTester.showMappings) {
                        IsoTester.outFile.println("Mapping rhs: " + rightMap.toString());
                    }
                    scr1.compose(rightMap, scr2);
                    if (!scr2.equals(fv2)) continue;
                    return true;
                }
lbl105:
                // 3 sources

                ** while (genLeft.hasMoreElements())
            }
        }
        return false;
    }

    public static boolean areIsomorphs(SetValue sv1, SetValue sv2, Scope scope, Coloring coloring) {
        SetType st = (SetType)sv1.getType();
        if (sv1.card() != sv1.card()) {
            return false;
        }
        if (showMappings) {
            outFile.println("Testing isomorphism of");
            outFile.println(sv1.toString());
            outFile.println(sv2.toString());
        }
        FunctionGenerator genMap = IsoTester.findBijGen(scope, st.elemType(), coloring);
        genMap.reset();
        SetValue scr1 = new SetValue(st, scope);
        while (genMap.hasMoreElements()) {
            FunctionValue map = genMap.nextFunction();
            if (showMappings) {
                outFile.println("Mapping with " + map.toString());
            }
            map.image(sv1, scr1);
            if (!scr1.equals(sv2)) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        try {
            Value baseValue;
            Value isoValue;
            Coloring baseColoring;
            RelationType rt;
            TypeList tl = new TypeList();
            GivenType typeA = new GivenType("A");
            typeA.setPrefix("a");
            tl.addType(typeA);
            GivenType typeB = new GivenType("B");
            typeB.setPrefix("b");
            tl.addType(typeB);
            LadyBug.init();
            Scope scope = new Scope(tl);
            maxBound = 3;
            Variable var = new Variable("x", null, null, SourceLoc.noLoc);
            VariableList vars = new VariableList(var);
            boolean doFuncs = false;
            boolean doSets = false;
            boolean doRels = false;
            boolean doChains = false;
            boolean sameTypes = false;
            boolean totals = false;
            boolean checkAll = true;
            showIsoFree = false;
            showMappings = false;
            countDups = true;
            int i = 1;
            while (i < args.length) {
                if (args[i].substring(0, 1).equals("#")) {
                    String tname = args[i].substring(1, 2);
                    GivenType t = tname.equals("A") ? typeA : typeB;
                    int value = Integer.valueOf(args[i].substring(2));
                    if (value > maxBound) {
                        maxBound = value;
                    }
                    scope.setBound(t, value);
                }
                ++i;
            }
            ColorPolicy policy = null;
            int i2 = 1;
            while (i2 < args.length) {
                if (args[i2].equals("atom")) {
                    policy = new AtomicPolicy(scope);
                    break;
                }
                if (args[i2].equals("str")) {
                    policy = new StructuralPolicy(scope);
                    break;
                }
                if (args[i2].equals("global")) {
                    policy = new GlobalAtomicPolicy(scope);
                    break;
                }
                ++i2;
            }
            if (policy == null) {
                policy = new StructuralPolicy(scope);
            }
            if (args.length == 0) {
                rt = new RelationType(typeA, typeB, true, false, false, false, false);
                baseColoring = policy.createColoring(typeA.universe(scope)).extend(typeB.universe(scope));
                var.setType(rt);
                isoValue = new FunctionValue(rt, scope);
                baseValue = new FunctionValue(rt, scope);
                doFuncs = true;
            } else if (args[0].equals("A->B") || args[0].equals("A-B")) {
                rt = new RelationType(typeA, typeB, true, false, false, false, false);
                baseColoring = policy.createColoring(typeA.universe(scope)).extend(typeB.universe(scope));
                var.setType(rt);
                isoValue = new FunctionValue(rt, scope);
                baseValue = new FunctionValue(rt, scope);
                doFuncs = true;
            } else if (args[0].equals("A->A") || args[0].equals("A-A")) {
                rt = new RelationType(typeA, typeA, true, false, false, false, false);
                baseColoring = policy.createColoring(typeA.universe(scope));
                var.setType(rt);
                baseValue = new FunctionValue(rt, scope);
                isoValue = new FunctionValue(rt, scope);
                sameTypes = true;
                doFuncs = true;
            } else if (args[0].equals("A<->B") || args[0].equals("A=B")) {
                rt = new RelationType(typeA, typeB, false, false, false, false, false);
                baseColoring = policy.createColoring(typeA.universe(scope)).extend(typeB.universe(scope));
                var.setType(rt);
                isoValue = new RelationValue(rt, scope);
                baseValue = new RelationValue(rt, scope);
                doRels = true;
            } else if (args[0].equals("A<->A") || args[0].equals("A=A")) {
                rt = new RelationType(typeA, typeA, false, false, false, false, false);
                baseColoring = policy.createColoring(typeA.universe(scope));
                var.setType(rt);
                baseValue = new RelationValue(rt, scope);
                isoValue = new RelationValue(rt, scope);
                sameTypes = true;
                doRels = true;
            } else if (args[0].equals("setA")) {
                SetType st = new SetType(typeA);
                baseColoring = policy.createColoring(st.elemType().universe(scope));
                var.setType(st);
                baseValue = new SetValue(st, scope);
                isoValue = new SetValue(st, scope);
                doSets = true;
            } else if (args[0].equals("chainA")) {
                rt = new RelationType(typeA, typeA, true, false, false, false, false);
                baseColoring = policy.createColoring(typeA.universe(scope));
                var.setType(rt);
                baseValue = new FunctionValue(rt, scope);
                ((FunctionValue)baseValue).markChain();
                isoValue = new FunctionValue(rt, scope);
                ((FunctionValue)isoValue).markChain();
                sameTypes = true;
                doChains = true;
            } else {
                System.out.println("Unsupported type: " + args[0]);
                return;
            }
            String colorA = null;
            String colorB = null;
            int i3 = 1;
            while (i3 < args.length) {
                if (args[i3].equals("out")) {
                    outFile = new PrintStream(new FileOutputStream(new File(args[++i3])));
                } else if (args[i3].equals("noChecks")) {
                    checkAll = false;
                } else if (args[i3].equals("total")) {
                    totals = true;
                } else if (args[i3].equals("showMaps")) {
                    showMappings = true;
                } else if (args[i3].equals("showIso")) {
                    showIsoFree = true;
                } else if (args[i3].equals("noCountDups")) {
                    countDups = false;
                } else if (!(args[i3].substring(0, 1).equals("#") || args[i3].equals("atom") || args[i3].equals("str") || args[i3].equals("global"))) {
                    if (args[i3].equals("color")) {
                        if (args[++i3].equals("A")) {
                            colorA = args[++i3];
                        } else {
                            colorB = args[++i3];
                        }
                    } else {
                        System.out.println("Unsupported option: " + args[i3]);
                    }
                }
                ++i3;
            }
            SetType dtype = new SetType(typeA);
            SetType rtype = sameTypes ? new SetType(typeA) : new SetType(typeB);
            dom1 = new SetValue(dtype, scope);
            dom2 = new SetValue(dtype, scope);
            ran1 = new SetValue(rtype, scope);
            ran2 = new SetValue(rtype, scope);
            dsets1 = new SetValue[maxBound];
            rsets1 = new SetValue[maxBound];
            dsets2 = new SetValue[maxBound];
            rsets2 = new SetValue[maxBound];
            int i4 = 0;
            while (i4 < maxBound) {
                IsoTester.dsets1[i4] = new SetValue(dtype, scope);
                IsoTester.dsets2[i4] = new SetValue(dtype, scope);
                IsoTester.rsets1[i4] = new SetValue(rtype, scope);
                IsoTester.rsets2[i4] = new SetValue(rtype, scope);
                ++i4;
            }
            outFile.println("Testing " + (doFuncs ? "functions" : (doSets ? "sets" : (doRels ? "rels" : "??"))));
            outFile.println("For " + scope.toString());
            totalValues = 0;
            totalIsos = 0;
            totalMissing = 0;
            totalColors = 0;
            if (doFuncs) {
                FuncIsoGenerator isoGen = new FuncIsoGenerator((FunctionValue)isoValue, var, var.getType(), scope, baseColoring);
                FuncExhGenerator baseGen = new FuncExhGenerator((FunctionValue)baseValue, var, var.getType(), scope);
                if (sameTypes) {
                    String[] colors = colorA == null ? IsoTester.allColorings(typeA, scope) : new String[]{colorA};
                    int i5 = 0;
                    while (i5 < colors.length) {
                        ++totalColors;
                        IsoTester.setColoring(baseColoring, typeA, scope, colors[i5]);
                        System.err.println("Checking " + baseColoring.dumpColors());
                        outFile.println("with " + baseColoring.dumpColors());
                        IsoTester.testGenerator(isoGen, baseGen, scope, baseColoring, checkAll);
                        outFile.println();
                        ++i5;
                    }
                } else {
                    String[] colorsA = colorA == null ? IsoTester.allColorings(typeA, scope) : new String[]{colorA};
                    String[] colorsB = colorB == null ? IsoTester.allColorings(typeB, scope) : new String[]{colorB};
                    int i6 = 0;
                    while (i6 < colorsA.length) {
                        int j = 0;
                        while (j < colorsB.length) {
                            ++totalColors;
                            IsoTester.setColoring(baseColoring, typeA, scope, colorsA[i6]);
                            IsoTester.setColoring(baseColoring, typeB, scope, colorsB[j]);
                            System.err.println("Checking " + baseColoring.dumpColors());
                            outFile.println("with " + baseColoring.dumpAllColors());
                            IsoTester.testGenerator(isoGen, baseGen, scope, baseColoring, checkAll);
                            outFile.println();
                            ++j;
                        }
                        ++i6;
                    }
                }
            } else if (doRels) {
                RelIsoGenerator isoGen = new RelIsoGenerator((RelationValue)isoValue, var, var.getType(), scope, baseColoring);
                RelExhGenerator baseGen = new RelExhGenerator((RelationValue)baseValue, var, var.getType(), scope);
                if (sameTypes) {
                    String[] colors = colorA == null ? IsoTester.allColorings(typeA, scope) : new String[]{colorA};
                    int i7 = 0;
                    while (i7 < colors.length) {
                        ++totalColors;
                        IsoTester.setColoring(baseColoring, typeA, scope, colors[i7]);
                        System.err.println("Checking " + baseColoring.dumpColors());
                        outFile.println("with " + baseColoring.dumpColors());
                        IsoTester.testGenerator(isoGen, baseGen, scope, baseColoring, checkAll);
                        outFile.println();
                        ++i7;
                    }
                } else {
                    String[] colorsA = colorA == null ? IsoTester.allColorings(typeA, scope) : new String[]{colorA};
                    String[] colorsB = colorB == null ? IsoTester.allColorings(typeB, scope) : new String[]{colorB};
                    int i8 = 0;
                    while (i8 < colorsA.length) {
                        int j = 0;
                        while (j < colorsB.length) {
                            ++totalColors;
                            IsoTester.setColoring(baseColoring, typeA, scope, colorsA[i8]);
                            IsoTester.setColoring(baseColoring, typeB, scope, colorsB[j]);
                            System.err.println("Checking " + baseColoring.dumpColors());
                            outFile.println("with " + baseColoring.dumpAllColors());
                            IsoTester.testGenerator(isoGen, baseGen, scope, baseColoring, checkAll);
                            outFile.println();
                            ++j;
                        }
                        ++i8;
                    }
                }
            } else if (doChains) {
                ChainIsoGenerator isoGen = new ChainIsoGenerator((FunctionValue)isoValue, var, var.getType(), scope, baseColoring);
                ChainExhGenerator baseGen = new ChainExhGenerator((FunctionValue)baseValue, var, var.getType(), scope);
                String[] colors = colorA == null ? IsoTester.allColorings(typeA, scope) : new String[]{colorA};
                int i9 = 0;
                while (i9 < colors.length) {
                    ++totalColors;
                    IsoTester.setColoring(baseColoring, typeA, scope, colors[i9]);
                    System.err.println("Checking " + baseColoring.dumpColors());
                    outFile.println("with " + baseColoring.dumpColors());
                    IsoTester.testGenerator(isoGen, baseGen, scope, baseColoring, checkAll);
                    outFile.println();
                    ++i9;
                }
            } else if (doSets) {
                SetIsoGenerator isoGen = new SetIsoGenerator((SetValue)isoValue, var, var.getType(), scope, baseColoring);
                SetExhGenerator baseGen = new SetExhGenerator((SetValue)baseValue, var, var.getType(), scope);
                String[] colors = colorA == null ? IsoTester.allColorings(typeA, scope) : new String[]{colorA};
                int i10 = 0;
                while (i10 < colors.length) {
                    ++totalColors;
                    IsoTester.setColoring(baseColoring, typeA, scope, colors[i10]);
                    System.err.println("Checking " + baseColoring.dumpColors());
                    outFile.println("with " + baseColoring.dumpColors());
                    IsoTester.testGenerator(isoGen, baseGen, scope, baseColoring, checkAll);
                    outFile.println();
                    ++i10;
                }
            }
            if (totals) {
                System.out.println(String.valueOf(String.valueOf(totalColors)) + " colors generated");
                System.out.println("  " + String.valueOf(totalValues) + " values (" + String.valueOf((double)totalValues / (double)totalColors) + ")");
                System.out.println("  " + String.valueOf(totalIsos) + " isofree values (" + String.valueOf((double)totalIsos / (double)totalColors) + ")");
                System.out.println("  " + String.valueOf(totalValues - totalIsos) + " dup values (" + String.valueOf(((double)totalValues - (double)totalIsos) / (double)totalColors) + ")");
                System.out.println("        efficiency = " + String.valueOf((double)totalIsos / (double)totalValues));
                if (checkAll) {
                    System.out.println("  " + String.valueOf(totalMissing) + " missing values (" + String.valueOf((double)totalMissing / (double)totalColors) + ")");
                }
            }
            System.out.println("Finished test");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void testGenerator(FunctionGenerator isoFree, FunctionGenerator baseLine, Scope scope, Coloring coloring, boolean checkAll) {
        RelationType rt = (RelationType)isoFree.typeGenerated();
        SetValue dom = new SetValue(new SetType(rt.domain()), scope);
        SetValue ran = new SetValue(new SetType(rt.range()), scope);
        Vector[][] isoFunctions = new Vector[(int)rt.domain().numValues(scope) + 1][(int)rt.range().numValues(scope) + 1];
        int d = 0;
        while ((long)d <= rt.domain().numValues(scope)) {
            int r = 0;
            while ((long)r <= rt.range().numValues(scope)) {
                if (r <= d) {
                    isoFunctions[d][r] = new Vector();
                }
                ++r;
            }
            ++d;
        }
        FunctionValue[] isoFreeValues = IsoTester.isoFreeSet(isoFree, scope, true, coloring, isoFunctions);
        outFile.println("Found " + String.valueOf(isoFreeValues.length) + " isomorph-free values");
        totalIsos += isoFreeValues.length;
        if (!checkAll) {
            return;
        }
        baseLine.reset();
        int numUnmatched = 0;
        block2: while (baseLine.hasMoreElements()) {
            FunctionValue fv = baseLine.nextFunction();
            fv.domain(dom);
            int d2 = dom.card();
            fv.range(ran);
            int r = ran.card();
            Enumeration fe = isoFunctions[d2][r].elements();
            while (fe.hasMoreElements()) {
                FunctionValue fv2 = (FunctionValue)fe.nextElement();
                if (IsoTester.areIsomorphs(fv, fv2, scope, coloring)) continue block2;
            }
            outFile.println("unmatched function " + fv.toString());
            ++numUnmatched;
        }
        if (numUnmatched > 0) {
            outFile.println("Found " + String.valueOf(numUnmatched) + " unmatched values");
            totalMissing += numUnmatched;
        }
    }

    private static FunctionValue[] isoFreeSet(FunctionGenerator gen, Scope scope, boolean reportDups, Coloring coloring, Vector[][] isoFunctions) {
        gen.reset();
        int max = (int)gen.totalGenValues();
        FunctionValue[] isoFree = new FunctionValue[max];
        int numIsoFree = 0;
        RelationType rt = (RelationType)gen.typeGenerated();
        SetValue dom = new SetValue(new SetType(rt.domain()), scope);
        SetValue ran = new SetValue(new SetType(rt.range()), scope);
        int numDups = 0;
        block0: while (gen.hasMoreElements()) {
            FunctionValue fv = gen.nextFunction();
            fv.domain(dom);
            int d = dom.card();
            fv.range(ran);
            int r = ran.card();
            ++totalValues;
            Enumeration fe = isoFunctions[d][r].elements();
            while (fe.hasMoreElements()) {
                FunctionValue fv2 = (FunctionValue)fe.nextElement();
                if (!IsoTester.areIsomorphs(fv, fv2, scope, coloring)) continue;
                if (reportDups) {
                    outFile.println("Isomorphic function discovered");
                    outFile.println(IsoTester.merge(fv.toString(), fv2.toString()));
                }
                if (!countDups) continue block0;
                ++numDups;
                continue block0;
            }
            if (showIsoFree) {
                outFile.println(fv.toString());
            }
            fv = (FunctionValue)fv.copy();
            isoFree[numIsoFree++] = fv;
            isoFunctions[d][r].insertElementAt(fv, 0);
        }
        if (countDups && numDups > 0) {
            outFile.println(String.valueOf(String.valueOf(numDups)) + " duplicates discovered");
        }
        if (numIsoFree == max) {
            return isoFree;
        }
        FunctionValue[] justFree = new FunctionValue[numIsoFree];
        int i = 0;
        while (i < numIsoFree) {
            justFree[i] = isoFree[i];
            ++i;
        }
        return justFree;
    }

    public static void testGenerator(RelationGenerator isoFree, RelationGenerator baseLine, Scope scope, Coloring coloring, boolean checkAll) {
        RelationType rt = (RelationType)isoFree.typeGenerated();
        Vector[] isoRels = new Vector[1 + (int)rt.domain().numValues(scope) * (int)rt.range().numValues(scope) + 1];
        int e = (int)rt.domain().numValues(scope) * (int)rt.range().numValues(scope);
        while (e >= 0) {
            isoRels[e] = new Vector();
            --e;
        }
        RelationValue[] isoFreeValues = IsoTester.isoFreeSet(isoFree, scope, true, coloring, isoRels);
        outFile.println("Found " + String.valueOf(isoFreeValues.length) + " isomorph-free values");
        totalIsos += isoFreeValues.length;
        if (!checkAll) {
            return;
        }
        baseLine.reset();
        int numUnmatched = 0;
        block1: while (baseLine.hasMoreElements()) {
            RelationValue rv = baseLine.nextRelation();
            int e2 = rv.card();
            Enumeration re = isoRels[e2].elements();
            while (re.hasMoreElements()) {
                RelationValue rv2 = (RelationValue)re.nextElement();
                if (IsoTester.areIsomorphs(rv, rv2, scope, coloring)) continue block1;
            }
            outFile.println("unmatched function " + rv.toString());
            ++numUnmatched;
        }
        if (numUnmatched > 0) {
            outFile.println("Found " + String.valueOf(numUnmatched) + " unmatched values");
            totalMissing += numUnmatched;
        }
    }

    private static RelationValue[] isoFreeSet(RelationGenerator gen, Scope scope, boolean reportDups, Coloring coloring, Vector[] isoRels) {
        gen.reset();
        int max = (int)gen.totalGenValues();
        RelationValue[] isoFree = new RelationValue[max];
        int numIsoFree = 0;
        RelationType rt = (RelationType)gen.typeGenerated();
        int numDups = 0;
        block0: while (gen.hasMoreElements()) {
            RelationValue rv = gen.nextRelation();
            int e = rv.card();
            ++totalValues;
            Enumeration re = isoRels[e].elements();
            while (re.hasMoreElements()) {
                RelationValue rv2 = (RelationValue)re.nextElement();
                if (!IsoTester.areIsomorphs(rv, rv2, scope, coloring)) continue;
                if (reportDups) {
                    outFile.println("Isomorphic relation discovered");
                    outFile.println(IsoTester.merge(rv.toString(), rv2.toString()));
                }
                if (!countDups) continue block0;
                ++numDups;
                continue block0;
            }
            if (showIsoFree) {
                outFile.println(rv.toString());
            }
            rv = (RelationValue)rv.copy();
            isoFree[numIsoFree++] = rv;
            isoRels[e].insertElementAt(rv, 0);
        }
        if (countDups && numDups > 0) {
            outFile.println(String.valueOf(String.valueOf(numDups)) + " duplicates discovered");
        }
        if (numIsoFree == max) {
            return isoFree;
        }
        RelationValue[] justFree = new RelationValue[numIsoFree];
        int i = 0;
        while (i < numIsoFree) {
            justFree[i] = isoFree[i];
            ++i;
        }
        return justFree;
    }

    public static void testGenerator(SetGenerator isoFree, SetGenerator baseLine, Scope scope, Coloring coloring, boolean checkAll) {
        SetValue[] isoFreeValues = IsoTester.isoFreeSet(isoFree, scope, true, coloring);
        outFile.println("Found " + String.valueOf(isoFreeValues.length) + " isomorph-free values");
        totalIsos += isoFreeValues.length;
        if (!checkAll) {
            return;
        }
        baseLine.reset();
        int numUnmatched = 0;
        block0: while (baseLine.hasMoreElements()) {
            SetValue sv = baseLine.nextSet();
            int i = 0;
            while (i < isoFreeValues.length) {
                if (IsoTester.areIsomorphs(sv, isoFreeValues[i], scope, coloring)) continue block0;
                ++i;
            }
            outFile.println("unmatched function " + sv.toString());
            ++numUnmatched;
        }
        if (numUnmatched > 0) {
            outFile.println("Found " + String.valueOf(numUnmatched) + " unmatched values");
            totalMissing += numUnmatched;
        }
    }

    private static SetValue[] isoFreeSet(SetGenerator gen, Scope scope, boolean reportDups, Coloring coloring) {
        int i;
        gen.reset();
        int max = (int)gen.totalGenValues();
        SetValue[] isoFree = new SetValue[max];
        int numIsoFree = 0;
        int numDups = 0;
        block0: while (gen.hasMoreElements()) {
            SetValue sv = gen.nextSet();
            ++totalValues;
            i = 0;
            while (i < numIsoFree) {
                if (IsoTester.areIsomorphs(sv, isoFree[i], scope, coloring)) {
                    if (reportDups) {
                        outFile.println("Isomorphic function discovered");
                        outFile.println(IsoTester.merge(sv.toString(), isoFree[i].toString()));
                    }
                    if (!countDups) continue block0;
                    ++numDups;
                    continue block0;
                }
                ++i;
            }
            if (showIsoFree) {
                outFile.println(sv.toString());
            }
            isoFree[numIsoFree++] = (SetValue)sv.copy();
        }
        if (countDups && numDups > 0) {
            outFile.println(String.valueOf(String.valueOf(numDups)) + " duplicates discovered");
        }
        if (numIsoFree == max) {
            return isoFree;
        }
        SetValue[] justFree = new SetValue[numIsoFree];
        i = 0;
        while (i < numIsoFree) {
            justFree[i] = isoFree[i];
            ++i;
        }
        return justFree;
    }

    private static FunctionGenerator findBijGen(Scope scope, ScalarType elemType, Coloring coloring) {
        RelationType rt = new RelationType(elemType, elemType, true, true, true, true, false);
        FunctionValue map = new FunctionValue(rt, scope);
        Variable v = null;
        try {
            v = new Variable("x", rt, null, SourceLoc.noLoc);
        }
        catch (ParseError parseError) {}
        int[] colors = new int[(int)elemType.numValues(scope)];
        coloring.coloring(elemType.universe(scope), colors);
        int numColors = 1;
        int i = 1;
        while (i < map.domainMax()) {
            if (colors[i] != colors[i - 1]) {
                ++numColors;
            }
            ++i;
        }
        if (numColors == 1) {
            return new FuncBijExhGenerator(map, v, v.getType(), scope);
        }
        return new ColorMapper(map, v, scope, colors, numColors);
    }

    private static FunctionGenerator findBijGen(Scope scope, ScalarType elemType, Coloring coloring, SetValue[] sets1, SetValue[] sets2, int max) {
        RelationType rt = new RelationType(elemType, elemType, true, true, true, true, false);
        FunctionValue map = new FunctionValue(rt, scope);
        Variable v = null;
        try {
            v = new Variable("x", rt, null, SourceLoc.noLoc);
        }
        catch (ParseError parseError) {}
        int[] colors1 = new int[(int)elemType.numValues(scope)];
        int[] colors2 = new int[(int)elemType.numValues(scope)];
        coloring.coloring(elemType.universe(scope), colors1);
        coloring.coloring(elemType.universe(scope), colors2);
        int i = 0;
        while (i < colors1.length) {
            int n = i;
            colors1[n] = colors1[n] * (max + 1);
            int n2 = i;
            colors2[n2] = colors2[n2] * (max + 1);
            int j = 0;
            while (j < max) {
                if (sets1[j].hasElement(i)) {
                    int n3 = i;
                    colors1[n3] = colors1[n3] + (j + 1);
                }
                if (sets2[j].hasElement(i)) {
                    int n4 = i;
                    colors2[n4] = colors2[n4] + (j + 1);
                }
                ++j;
            }
            ++i;
        }
        int numColors1 = 1;
        int numColors2 = 1;
        int i2 = 1;
        while (i2 < map.domainMax()) {
            int j = 0;
            while (j < i2) {
                if (colors1[j] == colors1[i2]) break;
                ++j;
            }
            if (j == i2) {
                ++numColors1;
            }
            j = 0;
            while (j < i2) {
                if (colors2[j] == colors2[i2]) break;
                ++j;
            }
            if (j == i2) {
                ++numColors2;
            }
            ++i2;
        }
        if (numColors1 != numColors2) {
            return null;
        }
        if (numColors1 == 1) {
            return new FuncBijExhGenerator(map, v, v.getType(), scope);
        }
        DegreeMapper fg = new DegreeMapper(map, v, scope, colors1, colors2, numColors1);
        return fg;
    }

    private static String[] allColorings(ScalarType t, Scope scope) {
        return IsoTester.allColorings((int)t.numValues(scope));
    }

    private static String[] allColorings(int max) {
        if (max < 1) {
            return null;
        }
        if (max <= allColors.size()) {
            return (String[])allColors.elementAt(max - 1);
        }
        if (max == 1) {
            String[] newColorings = new String[]{"0"};
            allColors.insertElementAt(newColorings, max - 1);
            return newColorings;
        }
        String[] prevColorings = IsoTester.allColorings(max - 1);
        String[] newColorings = new String[prevColorings.length * 2];
        int i = 0;
        while (i < prevColorings.length) {
            String str = prevColorings[i];
            int color = Integer.valueOf(str.substring(max - 2));
            newColorings[i * 2] = String.valueOf(str) + String.valueOf(color);
            newColorings[i * 2 + 1] = String.valueOf(str) + String.valueOf(color + 1);
            ++i;
        }
        allColors.insertElementAt(newColorings, max - 1);
        return newColorings;
    }

    private static void setColoring(Coloring baseColoring, ScalarType t, Scope scope, String coloringString) {
        SetValue sv = new SetValue(new SetType(t), scope);
        Coloring c = baseColoring;
        while (!c.baseType().equiv(t) && c.getPrevColoring() != null) {
            c = c.getPrevColoring();
        }
        c.reset();
        sv.init();
        sv.addElement(0);
        int j = 1;
        while (j < coloringString.length()) {
            if (coloringString.charAt(j - 1) != coloringString.charAt(j)) {
                c.distinguish(sv);
                sv.init();
            }
            sv.addElement(j);
            ++j;
        }
        c.distinguish(sv);
    }

    private static String merge(String s1, String s2) {
        int next;
        int maxlen = 0;
        int tabsize = 6;
        String s = "";
        String blanks = "                               ";
        int i1 = 0;
        while ((next = s1.indexOf(Tree.linesep(), i1)) >= 0) {
            if (next - i1 > maxlen) {
                maxlen = next - i1;
            }
            i1 = next + Tree.linesep().length();
        }
        if (s1.length() - i1 > maxlen) {
            maxlen = s1.length() - i1;
        }
        i1 = 0;
        int i2 = 0;
        while (i1 < s1.length() && i2 < s2.length()) {
            next = s1.indexOf(Tree.linesep(), i1);
            if (next >= 0) {
                s = String.valueOf(s) + s1.substring(i1, next);
                s = String.valueOf(s) + blanks.substring(0, maxlen - (next - i1) + tabsize);
                i1 = next + Tree.linesep().length();
            } else {
                s = String.valueOf(s) + s1.substring(i1);
                s = String.valueOf(s) + blanks.substring(0, maxlen - (s1.length() - i1) + tabsize);
                i1 = s1.length();
            }
            next = s2.indexOf(Tree.linesep(), i2);
            if (next >= 0) {
                s = String.valueOf(s) + s2.substring(i2, next);
                s = String.valueOf(s) + Tree.linesep();
                i2 = next + Tree.linesep().length();
                continue;
            }
            s = String.valueOf(s) + s2.substring(i2);
            s = String.valueOf(s) + Tree.linesep();
            i2 = s2.length();
        }
        if (i1 < s1.length()) {
            s = String.valueOf(s) + s1.substring(i1);
        } else if (i2 < s2.length()) {
            while ((next = s2.indexOf(Tree.linesep(), i2)) >= 0) {
                s = String.valueOf(s) + blanks.substring(0, maxlen + tabsize);
                s = String.valueOf(s) + s2.substring(i2, next) + Tree.linesep();
                i2 = next + Tree.linesep().length();
            }
            s = String.valueOf(s) + blanks.substring(0, maxlen + tabsize);
            s = String.valueOf(s) + s2.substring(i2) + Tree.linesep();
        }
        return s;
    }
}

