/*
 * Decompiled with CFR 0.152.
 */
package ladybug.selenum;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Vector;
import ladybug.engine.FunctionValue;
import ladybug.engine.LadyBug;
import ladybug.engine.RelationValue;
import ladybug.engine.ScalarValue;
import ladybug.engine.Scope;
import ladybug.engine.SetValue;
import ladybug.engine.Value;
import ladybug.parse.GivenType;
import ladybug.parse.RelationType;
import ladybug.parse.ScalarType;
import ladybug.parse.SetType;
import ladybug.parse.SourceLoc;
import ladybug.parse.TypeList;
import ladybug.parse.Variable;
import ladybug.parse.VariableList;
import ladybug.selenum.ChainIsoGenerator;
import ladybug.selenum.FuncIsoGenerator;
import ladybug.selenum.Generator;
import ladybug.selenum.RelIsoGenerator;
import ladybug.selenum.ScalarIsoGenerator;
import ladybug.selenum.SetIsoGenerator;
import ladybug.selenum.isomorph.AtomicPolicy;
import ladybug.selenum.isomorph.ColorPolicy;
import ladybug.selenum.isomorph.Coloring;
import ladybug.selenum.isomorph.GlobalAtomicPolicy;
import ladybug.selenum.isomorph.StructuralPolicy;

public class IsoEffects {
    static boolean showValues = false;
    static boolean showDetails = false;
    static PrintStream outFile = System.out;
    static Vector allColors = new Vector();

    public static void main(String[] args) {
        try {
            SetType st;
            Value isoValue;
            Coloring finalColoring;
            Coloring baseColoring;
            RelationType rt;
            TypeList tl = new TypeList();
            GivenType typeA = new GivenType("A");
            typeA.setPrefix("a");
            tl.addType(typeA);
            GivenType typeB = new GivenType("B");
            typeB.setPrefix("b");
            tl.addType(typeB);
            LadyBug.init();
            Scope scope = new Scope(tl);
            Variable var = new Variable("x", null, null, SourceLoc.noLoc);
            VariableList vars = new VariableList(var);
            boolean doFuncs = false;
            boolean doSets = false;
            boolean doRels = false;
            boolean doChains = false;
            boolean doScalars = false;
            boolean sameTypes = false;
            int i = 1;
            while (i < args.length) {
                if (args[i].substring(0, 1).equals("#")) {
                    String tname = args[i].substring(1, 2);
                    GivenType t = tname.equals("A") ? typeA : typeB;
                    scope.setBound(t, Integer.valueOf(args[i].substring(2)));
                }
                ++i;
            }
            ColorPolicy policy = null;
            int i2 = 1;
            while (i2 < args.length) {
                if (args[i2].equals("atom")) {
                    policy = new AtomicPolicy(scope);
                    break;
                }
                if (args[i2].equals("str")) {
                    policy = new StructuralPolicy(scope);
                    break;
                }
                if (args[i2].equals("global")) {
                    policy = new GlobalAtomicPolicy(scope);
                    break;
                }
                ++i2;
            }
            if (policy == null) {
                policy = new StructuralPolicy(scope);
            }
            if (args.length == 0) {
                rt = new RelationType(typeA, typeB, true, false, false, false, false);
                baseColoring = policy.createColoring(typeA.universe(scope)).extend(typeB.universe(scope));
                finalColoring = baseColoring.extend(typeA.universe(scope), typeB.universe(scope));
                var.setType(rt);
                isoValue = new FunctionValue(rt, scope);
                doFuncs = true;
            } else if (args[0].equals("A->B") || args[0].equals("A-B")) {
                rt = new RelationType(typeA, typeB, true, false, false, false, false);
                baseColoring = policy.createColoring(typeA.universe(scope)).extend(typeB.universe(scope));
                finalColoring = baseColoring.extend(typeA.universe(scope), typeB.universe(scope));
                var.setType(rt);
                isoValue = new FunctionValue(rt, scope);
                doFuncs = true;
            } else if (args[0].equals("A->A") || args[0].equals("A-A")) {
                rt = new RelationType(typeA, typeA, true, false, false, false, false);
                baseColoring = policy.createColoring(typeA.universe(scope));
                finalColoring = baseColoring.extend(typeA.universe(scope), typeA.universe(scope));
                var.setType(rt);
                isoValue = new FunctionValue(rt, scope);
                sameTypes = true;
                doFuncs = true;
            } else if (args[0].equals("A<->B") || args[0].equals("A=B")) {
                rt = new RelationType(typeA, typeB, false, false, false, false, false);
                baseColoring = policy.createColoring(typeA.universe(scope)).extend(typeB.universe(scope));
                finalColoring = baseColoring.extend(typeA.universe(scope), typeB.universe(scope));
                var.setType(rt);
                isoValue = new RelationValue(rt, scope);
                doRels = true;
            } else if (args[0].equals("A<->A") || args[0].equals("A=A")) {
                rt = new RelationType(typeA, typeA, false, false, false, false, false);
                baseColoring = policy.createColoring(typeA.universe(scope));
                finalColoring = baseColoring.extend(typeA.universe(scope), typeA.universe(scope));
                var.setType(rt);
                isoValue = new RelationValue(rt, scope);
                sameTypes = true;
                doRels = true;
            } else if (args[0].equals("setA")) {
                st = new SetType(typeA);
                baseColoring = policy.createColoring(st.elemType().universe(scope));
                finalColoring = baseColoring.extend(typeA.universe(scope));
                var.setType(st);
                isoValue = new SetValue(st, scope);
                doSets = true;
            } else if (args[0].equals("scalarA")) {
                st = new SetType(typeA);
                baseColoring = policy.createColoring(typeA.universe(scope));
                finalColoring = baseColoring.extend(typeA.universe(scope));
                var.setType(typeA);
                isoValue = new ScalarValue((ScalarType)typeA, scope);
                doScalars = true;
            } else if (args[0].equals("chainA")) {
                rt = new RelationType(typeA, typeA, true, false, false, false, false);
                baseColoring = policy.createColoring(typeA.universe(scope));
                finalColoring = baseColoring.extend(typeA.universe(scope), typeA.universe(scope));
                var.setType(rt);
                isoValue = new FunctionValue(rt, scope);
                ((FunctionValue)isoValue).markChain();
                sameTypes = true;
                doChains = true;
            } else {
                System.out.println("Unsupported type: " + args[0]);
                return;
            }
            String colorA = null;
            String colorB = null;
            int i3 = 1;
            while (i3 < args.length) {
                if (args[i3].equals("out")) {
                    outFile = new PrintStream(new FileOutputStream(new File(args[++i3])));
                } else if (!args[i3].substring(0, 1).equals("#")) {
                    if (args[i3].equals("values")) {
                        showValues = true;
                    } else if (args[i3].equals("details")) {
                        showDetails = true;
                    } else if (!(args[i3].equals("atom") || args[i3].equals("str") || args[i3].equals("global"))) {
                        if (args[i3].equals("color")) {
                            if (args[++i3].equals("A")) {
                                colorA = args[++i3];
                            } else {
                                colorB = args[++i3];
                            }
                        } else {
                            System.out.println("Unsupported option: " + args[i3]);
                        }
                    }
                }
                ++i3;
            }
            System.out.println("Testing " + (doFuncs ? "functions" : (doSets ? "sets" : (doRels ? "rels" : (doScalars ? "scalars" : "??")))));
            outFile.println("For " + scope.toString());
            int sizeA = (int)typeA.numValues(scope);
            int sizeB = (int)typeB.numValues(scope);
            long[] singleNext = new long[sizeA];
            long[][] doubleNextA = new long[sizeA][sizeB];
            long[][] doubleNextB = new long[sizeB][sizeA];
            int[] singleValues = new int[sizeA];
            int[][] doubleValuesA = new int[sizeA][sizeB];
            int[][] doubleValuesB = new int[sizeB][sizeA];
            int[] singleCases = new int[sizeA];
            int[][] doubleCasesA = new int[sizeA][sizeB];
            int[][] doubleCasesB = new int[sizeB][sizeA];
            if (doFuncs) {
                FuncIsoGenerator isoGen = new FuncIsoGenerator((FunctionValue)isoValue, var, var.getType(), scope, baseColoring);
                isoGen.setColoring(finalColoring);
                if (sameTypes) {
                    String[] colors = colorA == null ? IsoEffects.allColorings(typeA, scope) : new String[]{colorA};
                    int i4 = 0;
                    while (i4 < colors.length) {
                        IsoEffects.setColoring(baseColoring, typeA, scope, colors[i4]);
                        if (showDetails) {
                            outFile.println("with " + baseColoring.dumpColors());
                        }
                        IsoEffects.evalIso(typeA, isoGen, scope, baseColoring, finalColoring, singleNext, singleValues, singleCases);
                        if (showDetails) {
                            outFile.println();
                        }
                        ++i4;
                    }
                    outFile.println("Initial colors\tFinal colors\tNum values");
                    int j = 0;
                    while (j < sizeA) {
                        outFile.println(String.valueOf(String.valueOf(j + 1)) + "\t" + String.valueOf((double)singleNext[j] / (double)singleValues[j]) + "\t" + String.valueOf((double)singleValues[j] / (double)singleCases[j]));
                        ++j;
                    }
                    outFile.println();
                } else {
                    int k;
                    int j;
                    String[] colorsA = colorA == null ? IsoEffects.allColorings(typeA, scope) : new String[]{colorA};
                    String[] colorsB = colorB == null ? IsoEffects.allColorings(typeB, scope) : new String[]{colorB};
                    int i5 = 0;
                    while (i5 < colorsA.length) {
                        j = 0;
                        while (j < colorsB.length) {
                            IsoEffects.setColoring(baseColoring, typeA, scope, colorsA[i5]);
                            IsoEffects.setColoring(baseColoring, typeB, scope, colorsB[j]);
                            if (showDetails) {
                                outFile.println("with " + baseColoring.dumpColors());
                            }
                            IsoEffects.evalIso(typeA, typeB, isoGen, scope, baseColoring, finalColoring, doubleNextA, doubleValuesA, doubleCasesA);
                            IsoEffects.evalIso(typeB, typeA, isoGen, scope, baseColoring, finalColoring, doubleNextB, doubleValuesB, doubleCasesB);
                            if (showDetails) {
                                outFile.println();
                            }
                            ++j;
                        }
                        ++i5;
                    }
                    outFile.println("Domain:");
                    outFile.println("Initial colors\t\tFinal colors\tNum values");
                    j = 0;
                    while (j < sizeA) {
                        k = 0;
                        while (k < sizeB) {
                            outFile.println(String.valueOf(String.valueOf(j + 1)) + "x" + String.valueOf(k + 1) + "\t" + String.valueOf((double)doubleNextA[j][k] / (double)doubleValuesA[j][k]) + "\t" + String.valueOf((double)doubleValuesA[j][k] / (double)doubleCasesA[j][k]));
                            ++k;
                        }
                        ++j;
                    }
                    outFile.println("Range:");
                    outFile.println("Initial colors\t\tFinal colors\tNum values");
                    k = 0;
                    while (k < sizeA) {
                        int j2 = 0;
                        while (j2 < sizeB) {
                            outFile.println(String.valueOf(String.valueOf(k + 1)) + "x" + String.valueOf(j2 + 1) + "\t" + String.valueOf((double)doubleNextB[j2][k] / (double)doubleValuesB[j2][k]) + "\t" + String.valueOf((double)doubleValuesB[j2][k] / (double)doubleCasesB[j2][k]));
                            ++j2;
                        }
                        ++k;
                    }
                    outFile.println();
                }
            } else if (doRels) {
                RelIsoGenerator isoGen = new RelIsoGenerator((RelationValue)isoValue, var, var.getType(), scope, baseColoring);
                isoGen.setColoring(finalColoring);
                if (sameTypes) {
                    String[] colors = colorA == null ? IsoEffects.allColorings(typeA, scope) : new String[]{colorA};
                    int i6 = 0;
                    while (i6 < colors.length) {
                        IsoEffects.setColoring(baseColoring, typeA, scope, colors[i6]);
                        if (showDetails) {
                            outFile.println("with " + baseColoring.dumpColors());
                        }
                        IsoEffects.evalIso(typeA, isoGen, scope, baseColoring, finalColoring, singleNext, singleValues, singleCases);
                        if (showDetails) {
                            outFile.println();
                        }
                        ++i6;
                    }
                    outFile.println("Initial colors\tFinal colors\tNum values");
                    int j = 0;
                    while (j < sizeA) {
                        outFile.println(String.valueOf(String.valueOf(j + 1)) + "\t" + String.valueOf((double)singleNext[j] / (double)singleValues[j]) + "\t" + String.valueOf((double)singleValues[j] / (double)singleCases[j]));
                        ++j;
                    }
                    outFile.println();
                } else {
                    int j;
                    String[] colorsA = colorA == null ? IsoEffects.allColorings(typeA, scope) : new String[]{colorA};
                    String[] colorsB = colorB == null ? IsoEffects.allColorings(typeB, scope) : new String[]{colorB};
                    int i7 = 0;
                    while (i7 < colorsA.length) {
                        int j3 = 0;
                        while (j3 < colorsB.length) {
                            IsoEffects.setColoring(baseColoring, typeA, scope, colorsA[i7]);
                            IsoEffects.setColoring(baseColoring, typeB, scope, colorsB[j3]);
                            if (showDetails) {
                                outFile.println("with " + baseColoring.dumpColors());
                            }
                            IsoEffects.evalIso(typeA, typeB, isoGen, scope, baseColoring, finalColoring, doubleNextA, doubleValuesA, doubleCasesA);
                            IsoEffects.evalIso(typeB, typeA, isoGen, scope, baseColoring, finalColoring, doubleNextB, doubleValuesB, doubleCasesB);
                            if (showDetails) {
                                outFile.println();
                            }
                            ++j3;
                        }
                        ++i7;
                    }
                    outFile.println("Domain:");
                    outFile.println("Initial colors\t\tFinal colors\tNum values");
                    int k = 0;
                    while (k < sizeA) {
                        j = 0;
                        while (j < sizeB) {
                            outFile.println(String.valueOf(String.valueOf(k + 1)) + "x" + String.valueOf(j + 1) + "\t" + String.valueOf((double)doubleNextA[j][k] / (double)doubleValuesA[j][k]) + "\t" + String.valueOf((double)doubleValuesA[j][k] / (double)doubleCasesA[j][k]));
                            ++j;
                        }
                        ++k;
                    }
                    outFile.println("Range:");
                    outFile.println("Initial colors\t\tFinal colors\tNum values");
                    j = 0;
                    while (j < sizeB) {
                        int k2 = 0;
                        while (k2 < sizeA) {
                            outFile.println(String.valueOf(String.valueOf(k2 + 1)) + "x" + String.valueOf(j + 1) + "\t" + String.valueOf((double)doubleNextB[j][k2] / (double)doubleValuesB[j][k2]) + "\t" + String.valueOf((double)doubleValuesB[j][k2] / (double)doubleCasesB[j][k2]));
                            ++k2;
                        }
                        ++j;
                    }
                    outFile.println();
                }
            } else if (doChains) {
                ChainIsoGenerator isoGen = new ChainIsoGenerator((FunctionValue)isoValue, var, var.getType(), scope, baseColoring);
                isoGen.setColoring(finalColoring);
                String[] colors = colorA == null ? IsoEffects.allColorings(typeA, scope) : new String[]{colorA};
                int i8 = 0;
                while (i8 < colors.length) {
                    IsoEffects.setColoring(baseColoring, typeA, scope, colors[i8]);
                    if (showDetails) {
                        outFile.println("with " + baseColoring.dumpColors());
                    }
                    IsoEffects.evalIso(typeA, isoGen, scope, baseColoring, finalColoring, singleNext, singleValues, singleCases);
                    if (showDetails) {
                        outFile.println();
                    }
                    ++i8;
                }
                outFile.println("Initial colors\tFinal colors\tNum values");
                int j = 0;
                while (j < sizeA) {
                    outFile.println(String.valueOf(String.valueOf(j + 1)) + "\t" + String.valueOf((double)singleNext[j] / (double)singleValues[j]) + "\t" + String.valueOf((double)singleValues[j] / (double)singleCases[j]));
                    ++j;
                }
                outFile.println();
            } else if (doSets) {
                SetIsoGenerator isoGen = new SetIsoGenerator((SetValue)isoValue, var, var.getType(), scope, baseColoring);
                isoGen.setColoring(finalColoring);
                String[] colors = colorA == null ? IsoEffects.allColorings(typeA, scope) : new String[]{colorA};
                int i9 = 0;
                while (i9 < colors.length) {
                    IsoEffects.setColoring(baseColoring, typeA, scope, colors[i9]);
                    if (showDetails) {
                        outFile.println("with " + baseColoring.dumpColors());
                    }
                    IsoEffects.evalIso(typeA, isoGen, scope, baseColoring, finalColoring, singleNext, singleValues, singleCases);
                    if (showDetails) {
                        outFile.println();
                    }
                    ++i9;
                }
                outFile.println("Initial colors\tFinal colors\tNum values");
                int j = 0;
                while (j < sizeA) {
                    outFile.println(String.valueOf(String.valueOf(j + 1)) + "\t" + String.valueOf((double)singleNext[j] / (double)singleValues[j]) + "\t" + String.valueOf((double)singleValues[j] / (double)singleCases[j]));
                    ++j;
                }
                outFile.println();
            } else if (doScalars) {
                ScalarIsoGenerator isoGen = new ScalarIsoGenerator((ScalarValue)isoValue, var, var.getType(), scope, baseColoring);
                isoGen.setColoring(finalColoring);
                String[] colors = colorA == null ? IsoEffects.allColorings(typeA, scope) : new String[]{colorA};
                int i10 = 0;
                while (i10 < colors.length) {
                    IsoEffects.setColoring(baseColoring, typeA, scope, colors[i10]);
                    if (showDetails) {
                        outFile.println("with " + baseColoring.dumpColors());
                    }
                    IsoEffects.evalIso(typeA, isoGen, scope, baseColoring, finalColoring, singleNext, singleValues, singleCases);
                    if (showDetails) {
                        outFile.println();
                    }
                    ++i10;
                }
                outFile.println("Initial colors\tFinal colors\tNum values");
                int j = 0;
                while (j < sizeA) {
                    outFile.println(String.valueOf(String.valueOf(j + 1)) + "\t" + String.valueOf((double)singleNext[j] / (double)singleValues[j]) + "\t" + String.valueOf((double)singleValues[j] / (double)singleCases[j]));
                    ++j;
                }
                outFile.println();
            }
            System.out.println("Finished test");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void evalIso(ScalarType checkType, Generator isoFree, Scope scope, Coloring preColoring, Coloring postColoring, long[] postColors, int[] numValues, int[] cases) {
        int size = (int)checkType.numValues(scope);
        int[] colors = new int[size];
        int preColors = 1;
        preColoring.coloring(checkType, colors);
        int i = 1;
        while (i < size) {
            if (colors[i] != colors[i - 1]) {
                ++preColors;
            }
            ++i;
        }
        int n = 0;
        int ncolors = 0;
        isoFree.reset();
        while (isoFree.hasMoreElements()) {
            Value val = isoFree.nextValue();
            if (showValues) {
                outFile.println(val.toString());
            }
            ++n;
            postColoring.coloring(checkType, colors);
            int nc = 1;
            i = 1;
            while (i < size) {
                if (colors[i] != colors[i - 1]) {
                    ++nc;
                }
                ++i;
            }
            ncolors += nc;
        }
        int n2 = preColors - 1;
        postColors[n2] = postColors[n2] + (long)ncolors;
        int n3 = preColors - 1;
        numValues[n3] = numValues[n3] + n;
        int n4 = preColors - 1;
        cases[n4] = cases[n4] + 1;
        if (!showDetails) {
            return;
        }
        outFile.println("For type " + checkType.toString());
        outFile.println("  Number of initial colors = " + String.valueOf(preColors));
        outFile.println("  Number of values = " + String.valueOf(n));
        outFile.println("  Average number of final colors = " + String.valueOf((float)ncolors / (float)n));
    }

    public static void evalIso(ScalarType checkType, ScalarType otherType, Generator isoFree, Scope scope, Coloring preColoring, Coloring postColoring, long[][] postColors, int[][] numValues, int[][] cases) {
        int size = (int)checkType.numValues(scope);
        int otherSize = (int)checkType.numValues(scope);
        int[] colors = new int[size];
        int[] otherColors = new int[size];
        int preColors = 1;
        int preColors2 = 1;
        preColoring.coloring(checkType, colors);
        int i = 1;
        while (i < size) {
            if (colors[i] != colors[i - 1]) {
                ++preColors;
            }
            ++i;
        }
        preColoring.coloring(otherType, otherColors);
        i = 1;
        while (i < otherSize) {
            if (otherColors[i] != otherColors[i - 1]) {
                ++preColors2;
            }
            ++i;
        }
        int n = 0;
        int ncolors = 0;
        isoFree.reset();
        while (isoFree.hasMoreElements()) {
            Value val = isoFree.nextValue();
            if (showValues) {
                outFile.println(val.toString());
            }
            ++n;
            postColoring.coloring(checkType, colors);
            int nc = 1;
            i = 1;
            while (i < size) {
                if (colors[i] != colors[i - 1]) {
                    ++nc;
                }
                ++i;
            }
            ncolors += nc;
        }
        long[] lArray = postColors[preColors - 1];
        int n2 = preColors2 - 1;
        lArray[n2] = lArray[n2] + (long)ncolors;
        int[] nArray = numValues[preColors - 1];
        int n3 = preColors2 - 1;
        nArray[n3] = nArray[n3] + n;
        int[] nArray2 = cases[preColors - 1];
        int n4 = preColors2 - 1;
        nArray2[n4] = nArray2[n4] + 1;
        if (!showDetails) {
            return;
        }
        outFile.println("For type " + checkType.toString());
        outFile.println("  Number of initial colors = " + String.valueOf(preColors));
        outFile.println("  Number of values = " + String.valueOf(n));
        outFile.println("  Average number of final colors = " + String.valueOf((float)ncolors / (float)n));
    }

    private static String[] allColorings(ScalarType t, Scope scope) {
        return IsoEffects.allColorings((int)t.numValues(scope));
    }

    private static String[] allColorings(int max) {
        if (max < 1) {
            return null;
        }
        if (max <= allColors.size()) {
            return (String[])allColors.elementAt(max - 1);
        }
        if (max == 1) {
            String[] newColorings = new String[]{"0"};
            allColors.insertElementAt(newColorings, max - 1);
            return newColorings;
        }
        String[] prevColorings = IsoEffects.allColorings(max - 1);
        String[] newColorings = new String[prevColorings.length * 2];
        int i = 0;
        while (i < prevColorings.length) {
            String str = prevColorings[i];
            int color = Integer.valueOf(str.substring(max - 2));
            newColorings[i * 2] = String.valueOf(str) + String.valueOf(color);
            newColorings[i * 2 + 1] = String.valueOf(str) + String.valueOf(color + 1);
            ++i;
        }
        allColors.insertElementAt(newColorings, max - 1);
        return newColorings;
    }

    private static void setColoring(Coloring baseColoring, ScalarType t, Scope scope, String coloringString) {
        SetValue sv = new SetValue(new SetType(t), scope);
        Coloring c = baseColoring;
        while (!c.baseType().equiv(t) && c.getPrevColoring() != null) {
            c = c.getPrevColoring();
        }
        c.reset();
        sv.init();
        sv.addElement(0);
        int j = 1;
        while (j < coloringString.length()) {
            if (coloringString.charAt(j - 1) != coloringString.charAt(j)) {
                c.distinguish(sv);
                sv.init();
            }
            sv.addElement(j);
            ++j;
        }
        c.distinguish(sv);
    }
}

