/*
 * Decompiled with CFR 0.152.
 */
package ladybug.selenum;

import java.util.NoSuchElementException;
import ladybug.engine.FunctionValue;
import ladybug.engine.Scope;
import ladybug.engine.SetValue;
import ladybug.engine.Value;
import ladybug.parse.RelationType;
import ladybug.parse.ScalarType;
import ladybug.parse.Type;
import ladybug.parse.Variable;
import ladybug.selenum.FunctionGenerator;
import ladybug.selenum.Generator;

public final class FuncTotExhGenerator
extends Generator
implements FunctionGenerator {
    private FunctionValue valScratch;
    private FunctionValue domScratch;
    private FunctionValue ranScratch;
    private FunctionValue val;
    private FunctionValue domResult;
    private FunctionValue ranSource;
    private FunctionValue result;
    private int nextIndex = 0;
    private int maxIndex;
    private int domSize;
    private int ranSize;
    private FunctionValue domMap;
    private FunctionValue ranMap;
    private boolean mapDomain;
    private boolean mapRange;

    public FuncTotExhGenerator(FunctionValue value, Variable var, Type type, Scope scope) {
        super(var, type);
        this.result = value;
        RelationType rt = (RelationType)type;
        ScalarType dtype = rt.domain();
        ScalarType rtype = rt.range();
        this.domSize = (int)dtype.numValues(scope);
        this.ranSize = (int)rtype.numValues(scope);
        this.mapDomain = false;
        this.mapRange = false;
        this.domMap = new FunctionValue(new RelationType(dtype, dtype, true, true, false, false, false), this.domSize, this.domSize);
        this.ranMap = new FunctionValue(new RelationType(rtype, rtype, true, true, false, false, false), this.ranSize, this.ranSize);
        this.val = this.result;
        this.domScratch = new FunctionValue(rt, this.domSize, this.ranSize);
        this.ranScratch = new FunctionValue(rt, this.domSize, this.ranSize);
        this.valScratch = new FunctionValue(rt, this.domSize, this.ranSize);
        this.computeMax();
        rt = new RelationType(dtype, rtype);
        rt.setFunction(true);
        rt.setTotal(true);
        this.setTypeGenerated(rt);
        this.terminate();
    }

    public void reset() {
        this.nextIndex = 0;
    }

    public void terminate() {
        this.nextIndex = this.maxIndex;
    }

    public boolean hasMoreElements() {
        return this.nextIndex < this.maxIndex;
    }

    public Value nextValue() throws NoSuchElementException {
        return this.nextFunction();
    }

    public FunctionValue nextFunction() throws NoSuchElementException {
        if (this.nextIndex == this.maxIndex) {
            throw new NoSuchElementException();
        }
        int bits = this.nextIndex;
        this.val.init();
        int i = 0;
        while (i < this.domSize) {
            int to = bits % this.ranSize;
            this.val.addMapping(i, to);
            bits /= this.ranSize;
            ++i;
        }
        ++this.nextIndex;
        if (this.mapDomain) {
            this.domMap.compose(this.val, this.domResult);
        }
        if (this.mapRange) {
            this.ranSource.compose(this.ranMap, this.result);
        }
        if (this._coloring != null) {
            this._coloring.updateColoring(this.result);
        }
        return this.result;
    }

    public void setValue(FunctionValue value) {
        this.result = value;
        if (!this.mapRange) {
            if (this.mapDomain) {
                this.domResult = this.result;
            } else {
                this.val = value;
            }
        }
    }

    public void setDomain(SetValue dom) {
        if (this._coloring != null) {
            this._coloring.getPrevColoring().resetDomain(dom);
        }
        this.domSize = dom.card();
        int maxe = dom.maxElem() + 1;
        if (this.domSize < maxe) {
            this.mapDomain = true;
            this.val = this.valScratch;
            if (this.mapRange) {
                this.domResult = this.domScratch;
                this.ranSource = this.domScratch;
            } else {
                this.domResult = this.result;
            }
            this.domMap.init();
            int i = 0;
            int j = 0;
            while (i < maxe) {
                if (dom.hasElement(i)) {
                    this.domMap.addMapping(i, j);
                    ++j;
                }
                ++i;
            }
        } else if (this.mapDomain) {
            this.mapDomain = false;
            if (this.mapRange) {
                this.ranSource = this.val;
            } else {
                this.val = this.result;
            }
        }
        this.computeMax();
    }

    public void setRange(SetValue ran) {
        if (this._coloring != null) {
            this._coloring.resetDomain(ran);
        }
        this.ranSize = ran.card();
        int maxe = ran.maxElem() + 1;
        if (this.ranSize < maxe) {
            this.mapRange = true;
            this.val = this.valScratch;
            if (this.mapDomain) {
                this.ranSource = this.domScratch;
                this.domResult = this.domScratch;
            } else {
                this.ranSource = this.val;
            }
            this.ranMap.init();
            int i = 0;
            int j = 0;
            while (i < maxe) {
                if (ran.hasElement(i)) {
                    this.ranMap.addMapping(j, i);
                    ++j;
                }
                ++i;
            }
        } else if (this.mapRange) {
            this.mapRange = false;
            if (this.mapDomain) {
                this.domResult = this.result;
            } else {
                this.val = this.result;
            }
        }
        this.computeMax();
    }

    public double pctCompleted() {
        if (this.maxIndex == 0) {
            return 1.0;
        }
        return (double)this.nextIndex / (double)this.maxIndex;
    }

    public long totalValues() {
        return this.maxIndex;
    }

    public long totalGenValues() {
        if (this.maxIndex == 0) {
            return 1L;
        }
        return this.maxIndex;
    }

    public long valuesGend() {
        return this.nextIndex;
    }

    private void computeMax() {
        this.maxIndex = (int)Generator.pow(this.ranSize, this.domSize);
    }
}

