/*
 * Decompiled with CFR 0.152.
 */
package ladybug.selenum;

import java.util.NoSuchElementException;
import ladybug.engine.FunctionValue;
import ladybug.engine.Scope;
import ladybug.engine.SetValue;
import ladybug.engine.Value;
import ladybug.parse.RelationType;
import ladybug.parse.ScalarType;
import ladybug.parse.Type;
import ladybug.parse.Variable;
import ladybug.selenum.FunctionGenerator;
import ladybug.selenum.Generator;
import ladybug.selenum.isomorph.Coloring;

public class FuncIsoTotGenerator
extends Generator
implements FunctionGenerator {
    private Coloring rangeColoring;
    private ScalarType dtype;
    private ScalarType rtype;
    private SetValue _range;
    private SetValue _fullRange;
    private SetValue _domain;
    private FunctionValue val;
    private FunctionValue scratch;
    private FunctionValue result;
    private FunctionValue rangeMap;
    private int[] _dcolors;
    private int[][] _rcolors;
    private int[] _numColors;
    private int[] _edgesGenerated;
    private int[] domElems;
    private long nextIndex;
    private long maxIndex;
    private int domSize;
    private int ranSize;
    private int numElems;
    private int numDomElems;
    private boolean mapResult;
    private boolean hasDomain;

    public FuncIsoTotGenerator(FunctionValue value, Variable var, Type type, Scope scope, Coloring baseColoring) {
        super(var, type);
        RelationType rt = (RelationType)type;
        this.dtype = rt.domain();
        this.rtype = rt.range();
        this.nextIndex = 0L;
        this.domSize = (int)this.dtype.numValues(scope);
        this._domain = this.dtype.universe(scope);
        this.ranSize = (int)this.rtype.numValues(scope);
        this._range = this._fullRange = this.rtype.universe(scope);
        this._rcolors = new int[this.domSize][this.ranSize];
        this._numColors = new int[this.domSize];
        this._edgesGenerated = new int[this.domSize];
        this._dcolors = new int[this.domSize];
        this.domElems = new int[this.domSize];
        int i = 0;
        while (i < this.domSize) {
            this.domElems[i] = i;
            ++i;
        }
        this.numDomElems = this.domSize;
        this.result = value;
        this.mapResult = false;
        this.numElems = this.domSize;
        this.maxIndex = this.domSize;
        this.rangeMap = new FunctionValue(new RelationType(this.rtype, this.rtype, true, true, false, false, false), this.domSize, this.domSize);
        this.scratch = new FunctionValue(new RelationType(this.dtype, this.rtype, true, false, false, false, false), this.domSize, this.ranSize);
        this.val = this.result;
        this.rangeColoring = baseColoring.extend(this._domain, this._fullRange);
        rt = new RelationType(this.dtype, this.rtype);
        rt.setFunction(true);
        rt.setTotal(true);
        this.setTypeGenerated(rt);
        this.terminate();
    }

    public void setValue(FunctionValue value) {
        this.result = value;
        if (!this.mapResult) {
            this.val = value;
        }
    }

    public void setDomain(SetValue dom) {
        this._domain = dom;
        int i = 0;
        int j = 0;
        while (i < this.domSize) {
            if (this._domain.hasElement(i)) {
                this.domElems[j++] = i;
            }
            ++i;
        }
        if (this._coloring != null) {
            this._coloring.getPrevColoring().resetDomain(this._domain);
        }
        this.reset();
    }

    public void setRange(SetValue ran) {
        this.numElems = ran.card();
        if (this.numElems == 0) {
            this.ranSize = 0;
            this.mapResult = false;
            this._range = null;
            this.val = this.result;
            this.reset();
            return;
        }
        this.ranSize = ran.maxElem() + 1;
        if (this.ranSize == this.numElems) {
            this.mapResult = false;
            this._range = this._fullRange;
            this.val = this.result;
        } else {
            this.mapResult = true;
            this._range = ran;
            this.val = this.scratch;
            int i = 0;
            int j = 0;
            while (i < this.domSize) {
                if (ran.hasElement(i)) {
                    this.rangeMap.addMapping(j, i);
                    ++j;
                }
                ++i;
            }
        }
        if (this._coloring != null) {
            this._coloring.resetDomain(this._range);
        }
        this.reset();
    }

    public void reset() {
        this.rangeColoring.reset();
        this.rangeColoring.coloring(this._domain, this._dcolors);
        this.nextIndex = 0L;
        if (this.ranSize == 0) {
            this.maxIndex = 0L;
            return;
        }
        this.rangeColoring.distinguish(this.dtype, this.domElems[0]);
        this.rangeColoring.reset();
        this._numColors[0] = this.rangeColoring.coloring(this._range, this._rcolors[0]);
        this.maxIndex = Generator.pow(this.ranSize, this.domSize);
    }

    public void terminate() {
        this.nextIndex = this.maxIndex;
    }

    public boolean hasMoreElements() {
        return this.nextIndex < this.maxIndex;
    }

    public Value nextValue() throws NoSuchElementException {
        return this.nextFunction();
    }

    public FunctionValue nextFunction() throws NoSuchElementException {
        if (this.nextIndex == this.maxIndex) {
            throw new NoSuchElementException();
        }
        if (this.nextIndex == 0L) {
            boolean hasMoreEdges = false;
            this.val.init();
            this.val.addMapping(this.domElems[0], 0);
            this._edgesGenerated[0] = 1;
            if (this._numColors[0] > 1) {
                hasMoreEdges = true;
            }
            int edge = 1;
            while (edge < this.numDomElems) {
                if (this.mapResult) {
                    this.val.compose(this.rangeMap, this.result);
                }
                this.rangeColoring.updateColoring(this.result);
                this.rangeColoring.distinguish(this.dtype, this.domElems[edge]);
                this._numColors[edge] = this.rangeColoring.coloring(this._range, this._rcolors[edge]);
                this.val.addMapping(this.domElems[edge], 0);
                this._edgesGenerated[edge] = 1;
                if (this._numColors[edge] > 1) {
                    hasMoreEdges = true;
                }
                ++edge;
            }
            ++this.nextIndex;
            if (this.mapResult) {
                this.val.compose(this.rangeMap, this.result);
            }
            if (this._coloring != null) {
                this._coloring.updateColoring(this.result);
            }
            if (!hasMoreEdges) {
                this.maxIndex = this.nextIndex;
            }
            return this.result;
        }
        for (int edge = this.numDomElems - 1; edge >= 0; --edge) {
            int prev = this.val.mapsTo(this.domElems[edge]);
            this.val.removeMapping(this.domElems[edge], prev);
            if (this._edgesGenerated[edge] >= this._numColors[edge]) {
                continue;
            }
            int i = prev + 1;
            while (i < this.numElems) {
                if (this._rcolors[edge][i - 1] != this._rcolors[edge][i]) break;
                ++i;
            }
            this.val.addMapping(this.domElems[edge], i);
            int n = edge++;
            this._edgesGenerated[n] = this._edgesGenerated[n] + 1;
            int to = i;
            while (edge < this.numDomElems) {
                if (this.mapResult) {
                    this.val.compose(this.rangeMap, this.result);
                }
                this.rangeColoring.updateColoring(this.result);
                this.rangeColoring.distinguish(this.dtype, this.domElems[edge]);
                this._numColors[edge] = this.rangeColoring.coloring(this._range, this._rcolors[edge]);
                if (this._dcolors[this.domElems[edge]] != this._dcolors[this.domElems[edge - 1]]) {
                    to = 0;
                    this._edgesGenerated[edge] = 1;
                } else {
                    this._edgesGenerated[edge] = this._edgesGenerated[edge - 1];
                }
                this.val.addMapping(this.domElems[edge], to);
                ++edge;
            }
            ++this.nextIndex;
            if (this.mapResult) {
                this.val.compose(this.rangeMap, this.result);
            }
            if (this._coloring != null) {
                this._coloring.updateColoring(this.result);
            }
            boolean hasMoreEdges = false;
            i = 0;
            while (i < this.numDomElems) {
                if (this._edgesGenerated[i] < this._numColors[i]) {
                    hasMoreEdges = true;
                    break;
                }
                ++i;
            }
            if (!hasMoreEdges) {
                this.maxIndex = this.nextIndex;
            }
            return this.result;
        }
        throw new NoSuchElementException();
    }

    public double pctCompleted() {
        if (this.maxIndex == 0L) {
            return 1.0;
        }
        return (double)this.nextIndex / (double)this.maxIndex;
    }

    public long totalValues() {
        return this.maxIndex;
    }

    public long totalGenValues() {
        if (this.maxIndex <= 0L) {
            return 1L;
        }
        return this.maxIndex;
    }

    public long valuesGend() {
        return this.nextIndex;
    }
}

