/*
 * Decompiled with CFR 0.152.
 */
package ladybug.selenum;

import java.util.NoSuchElementException;
import ladybug.engine.FunctionValue;
import ladybug.engine.Scope;
import ladybug.engine.SetValue;
import ladybug.engine.ValueError;
import ladybug.parse.RelationType;
import ladybug.parse.SetType;
import ladybug.parse.Type;
import ladybug.parse.Variable;
import ladybug.selenum.FuncBijExhGenerator;
import ladybug.selenum.FunctionGenerator;
import ladybug.selenum.isomorph.Coloring;

class DegreeMapper
implements FunctionGenerator {
    private int numColors;
    private boolean first;
    private boolean[] empty;
    private boolean noMaps;
    private boolean allEmpty;
    private RelationType rt;
    private FunctionGenerator[] gens;
    private FunctionValue[] vals;
    private FunctionValue[] unions;
    private SetValue[] domains;
    private SetValue[] domainsUsed;
    private SetValue[] ranges;
    private SetValue[] rangesUsed;
    private SetValue scratch;
    private SetValue domSet;
    private SetValue ranSet;

    DegreeMapper(FunctionValue functionValue, Variable variable, Scope scope, int[] nArray, int[] nArray2, int n) {
        this.numColors = n;
        this.gens = new FunctionGenerator[this.numColors];
        this.vals = new FunctionValue[this.numColors];
        this.unions = new FunctionValue[this.numColors];
        this.empty = new boolean[this.numColors];
        this.domains = new SetValue[this.numColors];
        this.ranges = new SetValue[this.numColors];
        this.domainsUsed = new SetValue[this.numColors];
        this.rangesUsed = new SetValue[this.numColors];
        this.rt = (RelationType)variable.getType();
        SetType setType = new SetType(this.rt.domain());
        this.domSet = new SetValue(setType, scope);
        this.domSet.fullSet();
        this.ranSet = new SetValue(setType, scope);
        this.ranSet.fullSet();
        this.scratch = new SetValue(setType, scope);
        this.noMaps = false;
        this.allEmpty = false;
        this.scratch.init();
        int n2 = 0;
        int n3 = 0;
        while (n2 < nArray.length) {
            if (!this.scratch.hasElement(n2)) {
                this.domains[n3] = new SetValue(setType, scope);
                this.domains[n3].addElement(n2);
                this.scratch.addElement(n2);
                int n4 = n2 + 1;
                while (n4 < nArray.length) {
                    if (nArray[n2] == nArray[n4]) {
                        this.domains[n3].addElement(n4);
                        this.scratch.addElement(n4);
                    }
                    ++n4;
                }
                this.ranges[n3] = new SetValue(setType, scope);
                n4 = 0;
                while (n4 < nArray.length) {
                    if (nArray[n2] == nArray2[n4]) {
                        this.ranges[n3].addElement(n4);
                    }
                    ++n4;
                }
                if (this.domains[n3].card() != this.ranges[n3].card()) {
                    this.noMaps = true;
                }
                this.rangesUsed[n3] = new SetValue(setType, scope);
                this.domainsUsed[n3] = new SetValue(setType, scope);
                this.vals[n3] = new FunctionValue(this.rt, scope);
                this.unions[n3] = this.vals[n3];
                this.gens[n3] = new FuncBijExhGenerator(this.vals[n3], variable, variable.getType(), scope);
                this.empty[n3] = false;
                this.gens[n3].setDomain(this.domains[n3]);
                this.gens[n3].setRange(this.ranges[n3]);
                this.domainsUsed[n3].init(this.domains[n3]);
                this.rangesUsed[n3].init(this.ranges[n3]);
                ++n3;
            }
            ++n2;
        }
        this.unions[this.numColors - 1] = functionValue;
        this.reset();
    }

    public void reset() {
        if (this.noMaps) {
            return;
        }
        this.first = true;
        int n = 0;
        while (n < this.numColors) {
            this.gens[n].reset();
            ++n;
        }
    }

    public void terminate() {
        if (this.noMaps) {
            return;
        }
        this.first = false;
        int n = 0;
        while (n < this.numColors) {
            this.gens[n].terminate();
            ++n;
        }
    }

    public boolean hasMoreElements() {
        if (this.noMaps) {
            return false;
        }
        if (this.allEmpty && !this.first) {
            return false;
        }
        int n = 0;
        while (n < this.numColors) {
            if (this.gens[n].hasMoreElements()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public FunctionValue nextFunction() throws NoSuchElementException {
        if (this.noMaps) {
            throw new NoSuchElementException();
        }
        if (this.allEmpty) {
            if (!this.first) {
                throw new NoSuchElementException();
            }
            this.first = false;
            this.unions[this.numColors - 1].init();
            return this.unions[this.numColors - 1];
        }
        if (this.first) {
            int n = 0;
            while (n < this.numColors) {
                if (!this.gens[n].hasMoreElements()) {
                    this.terminate();
                    throw new NoSuchElementException();
                }
                this.gens[n].nextFunction();
                if (n > 0) {
                    try {
                        this.vals[n].union(this.unions[n - 1], this.unions[n]);
                    }
                    catch (ValueError valueError) {}
                }
                ++n;
            }
            this.first = false;
            return this.unions[this.numColors - 1];
        }
        int n = this.numColors - 1;
        while (n < this.numColors) {
            if (!this.gens[n].hasMoreElements()) {
                if (n == 0) {
                    throw new NoSuchElementException();
                }
                n -= 2;
            } else {
                this.gens[n].nextFunction();
                if (n > 0) {
                    try {
                        this.unions[n - 1].union(this.vals[n], this.unions[n]);
                    }
                    catch (ValueError valueError) {}
                }
                if (n + 1 < this.numColors) {
                    this.gens[n + 1].reset();
                }
            }
            ++n;
        }
        return this.unions[this.numColors - 1];
    }

    public void setColoring(Coloring coloring) {
    }

    public void setValue(FunctionValue functionValue) {
        this.unions[this.numColors - 1] = functionValue;
    }

    public void setDomain(SetValue setValue) {
        this.allEmpty = true;
        this.noMaps = false;
        int n = 0;
        while (n < this.numColors) {
            setValue.intersect(this.domains[n], this.domainsUsed[n]);
            this.gens[n].setDomain(this.domainsUsed[n]);
            if (this.domainsUsed[n].card() == 0 && this.rangesUsed[n].card() == 0) {
                this.empty[n] = true;
            } else if (this.rangesUsed[n].card() != this.domainsUsed[n].card()) {
                this.noMaps = true;
            } else {
                this.empty[n] = false;
                this.allEmpty = false;
            }
            ++n;
        }
        this.domSet.init(setValue);
    }

    public void setRange(SetValue setValue) {
        this.allEmpty = true;
        this.noMaps = false;
        int n = 0;
        while (n < this.numColors) {
            setValue.intersect(this.ranges[n], this.rangesUsed[n]);
            this.gens[n].setRange(this.rangesUsed[n]);
            if (this.domainsUsed[n].card() == 0 && this.rangesUsed[n].card() == 0) {
                this.empty[n] = true;
            } else if (this.rangesUsed[n].card() != this.domainsUsed[n].card()) {
                this.noMaps = true;
            } else {
                this.empty[n] = false;
                this.allEmpty = false;
            }
            ++n;
        }
        this.ranSet.init(setValue);
    }

    public double pctCompleted() {
        return 0.0;
    }

    public long totalValues() {
        return 0L;
    }

    public long totalGenValues() {
        return 0L;
    }

    public long valuesGend() {
        return 0L;
    }

    public Type typeGenerated() {
        return this.rt;
    }
}

