/*
 * Decompiled with CFR 0.152.
 */
package ladybug.selenum;

import java.util.NoSuchElementException;
import ladybug.engine.FunctionValue;
import ladybug.engine.Scope;
import ladybug.engine.SetValue;
import ladybug.engine.ValueError;
import ladybug.parse.RelationType;
import ladybug.parse.SetType;
import ladybug.parse.Type;
import ladybug.parse.Variable;
import ladybug.selenum.FuncBijExhGenerator;
import ladybug.selenum.FunctionGenerator;
import ladybug.selenum.isomorph.Coloring;

class ColorMapper
implements FunctionGenerator {
    private int _numColors;
    private boolean first;
    private boolean[] empty;
    private boolean noMaps;
    private boolean allEmpty;
    private RelationType rt;
    private FunctionGenerator[] gens;
    private FunctionValue[] vals;
    private FunctionValue[] unions;
    private SetValue[] domains;
    private SetValue[] domainsUsed;
    private SetValue[] rangeUsed;
    private SetValue scratch;
    private SetValue domSet;
    private SetValue ranSet;

    ColorMapper(FunctionValue functionValue, Variable variable, Scope scope, int[] nArray, int n) {
        this.gens = new FunctionGenerator[n];
        this.vals = new FunctionValue[n];
        this.unions = new FunctionValue[n];
        this.empty = new boolean[n];
        this.domains = new SetValue[n];
        this.domainsUsed = new SetValue[n];
        this.rangeUsed = new SetValue[n];
        this._numColors = n;
        this.rt = (RelationType)variable.getType();
        SetType setType = new SetType(this.rt.domain());
        this.domSet = new SetValue(setType, scope);
        this.domSet.fullSet();
        this.ranSet = new SetValue(setType, scope);
        this.ranSet.fullSet();
        this.scratch = new SetValue(setType, scope);
        int n2 = 0;
        int n3 = 0;
        while (n2 < nArray.length) {
            if (n2 == 0) {
                this.domains[n3] = new SetValue(setType, scope);
                this.domains[n3].addElement(n2);
                this.domainsUsed[n3] = new SetValue(setType, scope);
                this.rangeUsed[n3] = new SetValue(setType, scope);
                this.vals[n3] = new FunctionValue(this.rt, scope);
                this.unions[n3] = this.vals[n3];
                this.gens[n3] = new FuncBijExhGenerator(this.vals[n3], variable, variable.getType(), scope);
                this.empty[n3] = false;
            } else if (nArray[n2 - 1] != nArray[n2]) {
                this.gens[n3].setDomain(this.domains[n3]);
                this.gens[n3].setRange(this.domains[n3]);
                this.domainsUsed[n3].init(this.domains[n3]);
                this.rangeUsed[n3].init(this.domains[n3]);
                this.domains[++n3] = new SetValue(setType, scope);
                this.domains[n3].addElement(n2);
                this.domainsUsed[n3] = new SetValue(setType, scope);
                this.rangeUsed[n3] = new SetValue(setType, scope);
                this.vals[n3] = new FunctionValue(this.rt, scope);
                this.unions[n3] = new FunctionValue(this.rt, scope);
                this.gens[n3] = new FuncBijExhGenerator(this.vals[n3], variable, variable.getType(), scope);
                this.empty[n3] = false;
            } else {
                this.domains[n3].addElement(n2);
            }
            ++n2;
        }
        this.gens[n3].setDomain(this.domains[n3]);
        this.gens[n3].setRange(this.domains[n3]);
        this.domainsUsed[n3].init(this.domains[n3]);
        this.rangeUsed[n3].init(this.domains[n3]);
        this.unions[n3] = functionValue;
        this.noMaps = false;
        this.allEmpty = false;
        this.reset();
    }

    public void reset() {
        this.first = true;
        int n = 0;
        while (n < this._numColors) {
            this.gens[n].reset();
            ++n;
        }
    }

    public void terminate() {
        this.first = false;
        int n = 0;
        while (n < this._numColors) {
            this.gens[n].terminate();
            ++n;
        }
    }

    public boolean hasMoreElements() {
        if (this.noMaps) {
            return false;
        }
        if (this.allEmpty && !this.first) {
            return false;
        }
        int n = 0;
        while (n < this._numColors) {
            if (this.gens[n].hasMoreElements()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public FunctionValue nextFunction() throws NoSuchElementException {
        if (this.noMaps) {
            throw new NoSuchElementException();
        }
        if (this.allEmpty) {
            if (!this.first) {
                throw new NoSuchElementException();
            }
            this.first = false;
            this.unions[this._numColors - 1].init();
            return this.unions[this._numColors - 1];
        }
        if (this.first) {
            int n = 0;
            while (n < this._numColors) {
                if (this.empty[n]) {
                    this.vals[n].init();
                } else {
                    if (!this.gens[n].hasMoreElements()) {
                        this.terminate();
                        throw new NoSuchElementException();
                    }
                    this.gens[n].nextFunction();
                }
                if (n > 0) {
                    try {
                        this.vals[n].union(this.unions[n - 1], this.unions[n]);
                    }
                    catch (ValueError valueError) {}
                }
                ++n;
            }
            this.first = false;
            return this.unions[this._numColors - 1];
        }
        int n = this._numColors - 1;
        while (n < this._numColors) {
            if (!this.gens[n].hasMoreElements()) {
                if (n == 0) {
                    throw new NoSuchElementException();
                }
                n -= 2;
            } else {
                this.gens[n].nextFunction();
                if (n > 0) {
                    try {
                        this.unions[n - 1].union(this.vals[n], this.unions[n]);
                    }
                    catch (ValueError valueError) {}
                }
                if (n + 1 < this._numColors) {
                    this.gens[n + 1].reset();
                }
            }
            ++n;
        }
        return this.unions[this._numColors - 1];
    }

    public void setColoring(Coloring coloring) {
    }

    public void setValue(FunctionValue functionValue) {
        this.unions[this._numColors - 1] = functionValue;
    }

    public void setDomain(SetValue setValue) {
        this.allEmpty = true;
        this.noMaps = false;
        int n = 0;
        while (n < this._numColors) {
            setValue.intersect(this.domains[n], this.domainsUsed[n]);
            this.gens[n].setDomain(this.domainsUsed[n]);
            if (this.domainsUsed[n].card() == 0 && this.rangeUsed[n].card() == 0) {
                this.empty[n] = true;
            } else if (this.rangeUsed[n].card() != this.domainsUsed[n].card()) {
                this.noMaps = true;
            } else {
                this.empty[n] = false;
                this.allEmpty = false;
            }
            ++n;
        }
        this.domSet.init(setValue);
    }

    public void setRange(SetValue setValue) {
        this.allEmpty = true;
        this.noMaps = false;
        int n = 0;
        while (n < this._numColors) {
            setValue.intersect(this.domains[n], this.rangeUsed[n]);
            this.gens[n].setRange(this.rangeUsed[n]);
            if (this.domainsUsed[n].card() == 0 && this.rangeUsed[n].card() == 0) {
                this.empty[n] = true;
            } else if (this.rangeUsed[n].card() != this.domainsUsed[n].card()) {
                this.noMaps = true;
            } else {
                this.empty[n] = false;
                this.allEmpty = false;
            }
            ++n;
        }
        this.ranSet.init(setValue);
    }

    public double pctCompleted() {
        return 0.0;
    }

    public long totalValues() {
        return 0L;
    }

    public long totalGenValues() {
        return 0L;
    }

    public long valuesGend() {
        return 0L;
    }

    public Type typeGenerated() {
        return this.rt;
    }
}

