/*
 * Decompiled with CFR 0.152.
 */
package ladybug.selenum;

import java.util.NoSuchElementException;
import ladybug.engine.FunctionValue;
import ladybug.engine.Scope;
import ladybug.engine.SetValue;
import ladybug.engine.Value;
import ladybug.parse.ChainType;
import ladybug.parse.RelationType;
import ladybug.parse.SetType;
import ladybug.parse.Type;
import ladybug.parse.Variable;
import ladybug.selenum.FunctionGenerator;
import ladybug.selenum.Generator;

public class ChainTotExhGenerator
extends Generator
implements FunctionGenerator {
    private FunctionValue valScratch;
    private FunctionValue val;
    private FunctionValue result;
    private SetValue setScratch;
    private int nextIndex = 0;
    private int maxIndex;
    private int domSize;
    private FunctionValue domMap;
    private boolean mapDomain;

    public ChainTotExhGenerator(FunctionValue value, Variable var, Type type, Scope scope) {
        super(var, type);
        this.result = value;
        value.markChain();
        RelationType rt = (RelationType)type;
        this.domSize = (int)rt.domain().numValues(scope);
        this.mapDomain = false;
        this.domMap = new FunctionValue(new RelationType(rt.domain(), rt.domain(), true, true, false, false, false), this.domSize, this.domSize);
        this.val = this.result;
        this.valScratch = new FunctionValue(rt, this.domSize, this.domSize);
        this.setScratch = new SetValue(new SetType(rt.domain()), this.domSize);
        this.computeMax();
        rt = new ChainType(rt.domain(), true);
        this.setTypeGenerated(rt);
        this.terminate();
    }

    public void reset() {
        this.nextIndex = 0;
    }

    public void terminate() {
        this.nextIndex = this.maxIndex;
    }

    public boolean hasMoreElements() {
        return this.nextIndex < this.maxIndex;
    }

    public Value nextValue() throws NoSuchElementException {
        return this.nextFunction();
    }

    public FunctionValue nextFunction() throws NoSuchElementException {
        if (this.nextIndex == this.maxIndex) {
            throw new NoSuchElementException();
        }
        this.val.init();
        int prev = this.nextIndex % this.domSize;
        int bits = this.nextIndex / this.domSize;
        int size = this.domSize - 1;
        this.setScratch.init();
        this.val.markHead(prev);
        block0: while (size > 0) {
            this.setScratch.addElement(prev);
            int x = bits % size;
            bits /= size;
            --size;
            int i = 0;
            while (i < this.domSize) {
                if (!this.setScratch.hasElement(i)) {
                    if (x == 0) {
                        this.val.addMapping(prev, i);
                        prev = i;
                        continue block0;
                    }
                    --x;
                }
                ++i;
            }
        }
        this.val.addMapping(prev, prev);
        this.val.markTail(prev);
        if (this.mapDomain) {
            this.domMap.compose(this.val, this.result);
        }
        ++this.nextIndex;
        if (this._coloring != null) {
            this._coloring.updateColoring(this.result);
        }
        return this.result;
    }

    public void setValue(FunctionValue value) {
        this.result = value;
        if (!this.mapDomain) {
            this.val = value;
        }
    }

    public void setDomain(SetValue dom) {
        this.domSize = dom.card();
        int maxe = dom.maxElem() + 1;
        if (this.domSize < maxe) {
            this.mapDomain = true;
            this.val = this.valScratch;
            this.domMap.init();
            int i = 0;
            int j = 0;
            while (i < maxe) {
                if (dom.hasElement(i)) {
                    this.domMap.addMapping(i, j);
                    ++j;
                }
                ++i;
            }
        } else if (this.mapDomain) {
            this.mapDomain = false;
            this.val = this.result;
        }
        if (this._coloring != null) {
            this._coloring.getPrevColoring().resetDomain(dom);
            this._coloring.resetDomain(dom);
        }
        this.computeMax();
    }

    public void setRange(SetValue ran) {
        this.setDomain(ran);
    }

    public double pctCompleted() {
        if (this.maxIndex == 0) {
            return 1.0;
        }
        return (double)this.nextIndex / (double)this.maxIndex;
    }

    public long totalValues() {
        return this.maxIndex;
    }

    public long totalGenValues() {
        if (this.maxIndex == 0) {
            return 1L;
        }
        return this.maxIndex;
    }

    public long valuesGend() {
        return this.nextIndex;
    }

    private void computeMax() {
        int prod = 1;
        int i = this.domSize;
        while (i > 1) {
            prod *= i;
            --i;
        }
        this.maxIndex = prod;
    }
}

