/*
 * Decompiled with CFR 0.152.
 */
package ladybug.selenum;

import java.util.NoSuchElementException;
import ladybug.engine.FunctionValue;
import ladybug.engine.Scope;
import ladybug.engine.SetValue;
import ladybug.engine.Value;
import ladybug.parse.ChainType;
import ladybug.parse.RelationType;
import ladybug.parse.ScalarType;
import ladybug.parse.SetType;
import ladybug.parse.Type;
import ladybug.parse.Variable;
import ladybug.selenum.FunctionGenerator;
import ladybug.selenum.Generator;
import ladybug.selenum.isomorph.Coloring;

public class ChainIsoGenerator
extends Generator
implements FunctionGenerator {
    private FunctionValue result;
    private ScalarType _dcolorType;
    private Coloring _domColoring;
    private SetValue _ranSet;
    private SetValue _domSet;
    private int nextIndex = 0;
    private int maxIndex;
    private int domSize;
    private int[] domElems;
    private int[] colors;
    private int[] firstElem;
    private int[] nextElem;
    private int[] numElems;
    private int[] colorsUsed;
    private int numColors;
    private boolean mapDomain;
    private boolean computed;
    private boolean checkRange;

    public ChainIsoGenerator(FunctionValue value, Variable var, Type type, Scope scope, Coloring baseColoring) {
        super(var, type);
        this.result = value;
        value.markChain();
        RelationType rt = (RelationType)type;
        this._domColoring = baseColoring;
        this._dcolorType = rt.domain();
        this.domSize = (int)this._dcolorType.numValues(scope);
        this.colors = new int[this.domSize];
        this.colorsUsed = new int[this.domSize];
        this.domElems = new int[this.domSize];
        this.numElems = new int[this.domSize];
        this.firstElem = new int[this.domSize];
        this.nextElem = new int[this.domSize];
        this.mapDomain = false;
        this.numColors = 1;
        this.numElems[0] = this.domSize;
        this.firstElem[0] = 0;
        this._ranSet = new SetValue(new SetType(rt.domain()), this.domSize);
        this._ranSet.fullSet();
        this._domSet = new SetValue(new SetType(rt.domain()), this.domSize);
        this._domSet.fullSet();
        this.checkRange = false;
        this.computeMax();
        rt = new ChainType(rt.domain());
        this.setTypeGenerated(rt);
        this.terminate();
    }

    public void reset() {
        this.nextIndex = 0;
        if (this.domSize == 0) {
            return;
        }
        this.numColors = this._domColoring.coloring(this._domSet, this.colors);
        this.firstElem[this.colors[0]] = 0;
        this.nextElem[this.colors[0]] = 0;
        this.numElems[this.colors[0]] = 1;
        this.colorsUsed[0] = this.colors[0];
        int i = 1;
        int nc = 1;
        while (i < this.domSize) {
            if (this.colors[i] == this.colors[i - 1]) {
                int n = this.colors[i];
                this.numElems[n] = this.numElems[n] + 1;
            } else {
                this.firstElem[this.colors[i]] = i;
                this.nextElem[this.colors[i]] = i;
                this.numElems[this.colors[i]] = 1;
                this.colorsUsed[nc] = this.colors[i];
                ++nc;
            }
            ++i;
        }
        this.computeMax();
        this.computed = false;
    }

    public void terminate() {
        this.nextIndex = this.maxIndex;
        this.computed = false;
    }

    public boolean hasMoreElements() {
        if (this.nextIndex >= this.maxIndex) {
            return false;
        }
        return this.computeNextChain();
    }

    public Value nextValue() throws NoSuchElementException {
        return this.nextFunction();
    }

    public FunctionValue nextFunction() throws NoSuchElementException {
        if (this.nextIndex == this.maxIndex) {
            throw new NoSuchElementException();
        }
        if (!this.computeNextChain()) {
            throw new NoSuchElementException();
        }
        ++this.nextIndex;
        this.computed = false;
        if (this._coloring != null) {
            this._coloring.updateColoring(this.result);
        }
        return this.result;
    }

    private boolean computeNextChain() {
        if (this.nextIndex >= this.maxIndex) {
            return false;
        }
        if (this.computed) {
            return true;
        }
        this.result.init();
        if (this.nextIndex > 0) {
            if (this.nextIndex <= this.numColors) {
                int color = this.colorsUsed[this.nextIndex - 1];
                int elem = this.firstElem[color];
                if (this.mapDomain) {
                    elem = this.domElems[elem];
                }
                if (this.checkRange && !this._ranSet.hasElement(elem)) {
                    this.computed = false;
                    ++this.nextIndex;
                    return this.computeNextChain();
                }
                this.result.markHead(elem);
                this.result.markTail(elem);
                this.result.addMapping(elem, elem);
            } else {
                int i = 0;
                while (i < this.numColors) {
                    this.nextElem[i] = this.firstElem[i];
                    ++i;
                }
                int color = this.colorsUsed[(this.nextIndex - 1) % this.numColors];
                int prev = this.firstElem[color];
                int bits = (this.nextIndex - 1) / this.numColors;
                int size = this.numColors;
                this.nextElem[color] = this.numElems[color] == 1 ? -1 : prev + 1;
                int prevElem = prev;
                if (this.mapDomain) {
                    prevElem = this.domElems[prev];
                }
                this.result.markHead(prevElem);
                while (bits > 0) {
                    int x = (bits - 1) % size;
                    bits = (bits - 1) / size;
                    color = this.colorsUsed[x];
                    int elem = this.nextElem[color];
                    if (elem == -1) {
                        ++this.nextIndex;
                        this.computed = false;
                        return this.computeNextChain();
                    }
                    this.nextElem[color] = elem + 1 < this.domSize && this.colors[elem + 1] == color ? elem + 1 : -1;
                    if (this.mapDomain) {
                        elem = this.domElems[elem];
                    }
                    if (this.checkRange && !this._ranSet.hasElement(elem)) {
                        this.computed = false;
                        ++this.nextIndex;
                        return this.computeNextChain();
                    }
                    this.result.addMapping(prevElem, elem);
                    prevElem = elem;
                }
                this.result.addMapping(prevElem, prevElem);
                this.result.markTail(prevElem);
            }
        }
        this.computed = true;
        return true;
    }

    public void setValue(FunctionValue value) {
        this.result = value;
    }

    public void setDomain(SetValue dom) {
        this._domSet.init(dom);
        this.domSize = dom.card();
        int maxe = dom.maxElem() + 1;
        if (this.domSize < maxe) {
            this.mapDomain = true;
            int i = 0;
            int j = 0;
            while (i < maxe) {
                if (dom.hasElement(i)) {
                    this.domElems[j++] = i;
                }
                ++i;
            }
        } else if (this.mapDomain) {
            this.mapDomain = false;
        }
        this.checkRange = this._ranSet.contains(this._domSet) ^ true;
        if (this._coloring != null) {
            this._coloring.getPrevColoring().resetDomain(dom);
            this._coloring.resetDomain(dom);
        }
        this.computeMax();
        this.terminate();
    }

    public void setRange(SetValue ran) {
        this._ranSet.init(ran);
        this.checkRange = this._ranSet.contains(this._domSet) ^ true;
        if (this._coloring != null) {
            this._coloring.resetDomain(ran);
        }
        this.terminate();
    }

    public double pctCompleted() {
        if (this.maxIndex == 0) {
            return 1.0;
        }
        return (double)this.nextIndex / (double)this.maxIndex;
    }

    public long totalValues() {
        return this.maxIndex;
    }

    public long totalGenValues() {
        if (this.maxIndex == 0) {
            return 1L;
        }
        return this.maxIndex;
    }

    public long valuesGend() {
        return this.nextIndex;
    }

    private void computeMax() {
        int sum = 1;
        this.maxIndex = 1;
        int i = this.domSize;
        while (i > 0) {
            this.maxIndex += (sum *= this.numColors);
            --i;
        }
    }
}

