/*
 * Decompiled with CFR 0.152.
 */
package ladybug.selenum;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Vector;
import ladybug.engine.FunctionValue;
import ladybug.engine.LadyBug;
import ladybug.engine.RelOrFuncValue;
import ladybug.engine.RelationValue;
import ladybug.engine.Scope;
import ladybug.engine.SetValue;
import ladybug.engine.Value;
import ladybug.engine.ValueError;
import ladybug.parse.GivenType;
import ladybug.parse.ParseError;
import ladybug.parse.RelationType;
import ladybug.parse.ScalarType;
import ladybug.parse.SetType;
import ladybug.parse.SourceLoc;
import ladybug.parse.Tree;
import ladybug.parse.TypeList;
import ladybug.parse.Variable;
import ladybug.parse.VariableList;
import ladybug.selenum.ChainIsoGenerator;
import ladybug.selenum.ColorMapper;
import ladybug.selenum.DegreeMapper;
import ladybug.selenum.FuncBijExhGenerator;
import ladybug.selenum.FuncIsoGenerator;
import ladybug.selenum.FunctionGenerator;
import ladybug.selenum.Perm;
import ladybug.selenum.RelIsoGenerator;
import ladybug.selenum.RelationGenerator;
import ladybug.selenum.SetGenerator;
import ladybug.selenum.SetIsoGenerator;
import ladybug.selenum.isomorph.AtomicPolicy;
import ladybug.selenum.isomorph.ColorPolicy;
import ladybug.selenum.isomorph.Coloring;
import ladybug.selenum.isomorph.GlobalAtomicPolicy;
import ladybug.selenum.isomorph.StructuralPolicy;

public class AutoFinder {
    static PrintStream outFile = System.out;
    static SetValue dom1;
    static SetValue dom2;
    static SetValue ran1;
    static SetValue ran2;
    static SetValue[] dsets1;
    static SetValue[] rsets1;
    static SetValue[] dsets2;
    static SetValue[] rsets2;
    static int numValues;
    static int numPerms;
    static int affectedValues;
    static int affectedPerms;
    static int domColors;
    static int ranColors;
    static int affDomColors;
    static int affRanColors;
    static int domPerms;
    static int ranPerms;
    static int affDomPerms;
    static int affRanPerms;
    static int affectedValuePerms;
    static int maxBound;
    static boolean useAtom;
    static boolean useStruct;
    static boolean useDomain;
    static boolean dumpMaps;

    /*
     * Unable to fully structure code
     */
    public static boolean areIsomorphs(FunctionValue fv1, FunctionValue fv2, Scope scope, Coloring coloring) {
        block9: {
            rt = (RelationType)fv1.getType();
            fv2.range(AutoFinder.ran2);
            fv1.range(AutoFinder.ran1);
            if (AutoFinder.ran1.card() != AutoFinder.ran2.card()) {
                return false;
            }
            fv2.domain(AutoFinder.dom2);
            fv1.domain(AutoFinder.dom1);
            if (AutoFinder.dom1.card() != AutoFinder.dom2.card()) {
                return false;
            }
            genLeft = AutoFinder.findBijGen(scope, rt.domain(), coloring);
            genRight = null;
            rightMap = null;
            scr1 = new FunctionValue(rt, scope);
            scr2 = new FunctionValue(rt, scope);
            sameTypes = false;
            if (rt.domain() == rt.range()) {
                sameTypes = true;
                rightMap = new FunctionValue(rt, scope);
            } else {
                genLeft.setDomain(AutoFinder.dom2);
                genLeft.setRange(AutoFinder.dom1);
                genRight = AutoFinder.findBijGen(scope, rt.range(), coloring);
                genRight.setDomain(AutoFinder.ran1);
                genRight.setRange(AutoFinder.ran2);
            }
            genLeft.reset();
            if (!sameTypes) ** GOTO lbl51
            while (genLeft.hasMoreElements()) {
                leftMap = genLeft.nextFunction();
                leftMap.compose(fv1, scr1);
                scr1.domain(AutoFinder.dom1);
                if (!AutoFinder.dom1.equals(AutoFinder.dom2)) continue;
                try {
                    leftMap.transpose(rightMap);
                }
                catch (ValueError v0) {
                    continue;
                }
                scr1.compose(rightMap, scr2);
                if (!scr2.equals(fv2)) continue;
                return true;
            }
            break block9;
lbl-1000:
            // 1 sources

            {
                leftMap = genLeft.nextFunction();
                leftMap.compose(fv1, scr1);
                scr1.domain(AutoFinder.dom1);
                if (!AutoFinder.dom1.equals(AutoFinder.dom2)) continue;
                genRight.reset();
                while (genRight.hasMoreElements()) {
                    rightMap = genRight.nextFunction();
                    scr1.compose(rightMap, scr2);
                    if (!scr2.equals(fv2)) continue;
                    return true;
                }
lbl51:
                // 3 sources

                ** while (genLeft.hasMoreElements())
            }
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean areIsomorphs(RelationValue fv1, RelationValue fv2, Scope scope, Coloring coloring) {
        block22: {
            rt = (RelationType)fv1.getType();
            fv2.range(AutoFinder.ran2);
            fv1.range(AutoFinder.ran1);
            if (AutoFinder.ran1.card() != AutoFinder.ran2.card()) {
                return false;
            }
            fv2.domain(AutoFinder.dom2);
            fv1.domain(AutoFinder.dom1);
            if (AutoFinder.dom1.card() != AutoFinder.dom2.card()) {
                return false;
            }
            i = 1;
            while (i <= AutoFinder.dom1.card()) {
                AutoFinder.rsets1[i - 1].init();
                AutoFinder.rsets2[i - 1].init();
                ++i;
            }
            i = 1;
            while (i <= AutoFinder.ran1.card()) {
                AutoFinder.dsets1[i - 1].init();
                AutoFinder.dsets2[i - 1].init();
                ++i;
            }
            i = 0;
            while (i < AutoFinder.maxBound) {
                degree = fv1.ddegree(i);
                if (degree > 0) {
                    AutoFinder.dsets1[degree - 1].addElement(i);
                }
                if ((degree = fv2.ddegree(i)) > 0) {
                    AutoFinder.dsets2[degree - 1].addElement(i);
                }
                if ((degree = fv1.rdegree(i)) > 0) {
                    AutoFinder.rsets1[degree - 1].addElement(i);
                }
                if ((degree = fv2.rdegree(i)) > 0) {
                    AutoFinder.rsets2[degree - 1].addElement(i);
                }
                ++i;
            }
            i = 0;
            while (i < AutoFinder.ran1.card()) {
                if (AutoFinder.dsets1[i].card() != AutoFinder.dsets2[i].card()) {
                    return false;
                }
                ++i;
            }
            i = 0;
            while (i < AutoFinder.dom1.card()) {
                if (AutoFinder.rsets1[i].card() != AutoFinder.rsets2[i].card()) {
                    return false;
                }
                ++i;
            }
            genLeft = AutoFinder.findBijGen(scope, rt.domain(), coloring, AutoFinder.dsets2, AutoFinder.dsets1, AutoFinder.ran1.card());
            if (genLeft == null) {
                return false;
            }
            genRight = null;
            rightMap = null;
            scr1 = new RelationValue(rt, scope);
            scr2 = new RelationValue(rt, scope);
            sameTypes = false;
            if (rt.domain() == rt.range()) {
                sameTypes = true;
                rightMap = new FunctionValue(rt, scope);
            } else {
                genLeft.setDomain(AutoFinder.dom2);
                genLeft.setRange(AutoFinder.dom1);
                genRight = AutoFinder.findBijGen(scope, rt.range(), coloring, AutoFinder.rsets1, AutoFinder.rsets2, AutoFinder.dom1.card());
                if (genRight == null) {
                    return false;
                }
                genRight.setDomain(AutoFinder.ran1);
                genRight.setRange(AutoFinder.ran2);
            }
            genLeft.reset();
            if (!sameTypes) ** GOTO lbl92
            while (genLeft.hasMoreElements()) {
                leftMap = genLeft.nextFunction();
                leftMap.compose(fv1, scr1);
                scr1.domain(AutoFinder.dom1);
                if (!AutoFinder.dom1.equals(AutoFinder.dom2)) continue;
                try {
                    leftMap.transpose(rightMap);
                }
                catch (ValueError v0) {
                    continue;
                }
                scr1.compose(rightMap, scr2);
                if (!scr2.equals(fv2)) continue;
                return true;
            }
            break block22;
lbl-1000:
            // 1 sources

            {
                leftMap = genLeft.nextFunction();
                leftMap.compose(fv1, scr1);
                scr1.domain(AutoFinder.dom1);
                if (!AutoFinder.dom1.equals(AutoFinder.dom2)) continue;
                genRight.reset();
                while (genRight.hasMoreElements()) {
                    rightMap = genRight.nextFunction();
                    scr1.compose(rightMap, scr2);
                    if (!scr2.equals(fv2)) continue;
                    return true;
                }
lbl92:
                // 3 sources

                ** while (genLeft.hasMoreElements())
            }
        }
        return false;
    }

    public static boolean areIsomorphs(SetValue sv1, SetValue sv2, Scope scope, Coloring coloring) {
        SetType st = (SetType)sv1.getType();
        if (sv1.card() != sv1.card()) {
            return false;
        }
        FunctionGenerator genMap = AutoFinder.findBijGen(scope, st.elemType(), coloring);
        genMap.reset();
        SetValue scr1 = new SetValue(st, scope);
        while (genMap.hasMoreElements()) {
            FunctionValue map = genMap.nextFunction();
            map.image(sv1, scr1);
            if (!scr1.equals(sv2)) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        try {
            Value baseValue;
            Value isoValue;
            Coloring baseColoring;
            RelationType rt;
            TypeList tl = new TypeList();
            GivenType typeA = new GivenType("A");
            typeA.setPrefix("a");
            tl.addType(typeA);
            GivenType typeB = new GivenType("B");
            typeB.setPrefix("b");
            tl.addType(typeB);
            LadyBug.init();
            Scope scope = new Scope(tl);
            maxBound = 3;
            Variable var = new Variable("x", null, null, SourceLoc.noLoc);
            VariableList vars = new VariableList(var);
            boolean doFuncs = false;
            boolean doSets = false;
            boolean doRels = false;
            boolean doChains = false;
            boolean sameTypes = false;
            boolean showAuto = false;
            boolean useIso = true;
            boolean useGen = false;
            boolean useAll = false;
            useStruct = true;
            useAtom = false;
            useDomain = false;
            dumpMaps = false;
            int i = 1;
            while (i < args.length) {
                if (args[i].substring(0, 1).equals("#")) {
                    String tname = args[i].substring(1, 2);
                    GivenType t = tname.equals("A") ? typeA : typeB;
                    int value = Integer.valueOf(args[i].substring(2));
                    if (value > maxBound) {
                        maxBound = value;
                    }
                    scope.setBound(t, value);
                }
                ++i;
            }
            ColorPolicy policy = null;
            int i2 = 1;
            while (i2 < args.length) {
                if (args[i2].equals("atom")) {
                    policy = new AtomicPolicy(scope);
                    break;
                }
                if (args[i2].equals("str")) {
                    policy = new StructuralPolicy(scope);
                    break;
                }
                if (args[i2].equals("global")) {
                    policy = new GlobalAtomicPolicy(scope);
                    break;
                }
                ++i2;
            }
            if (policy == null) {
                policy = new StructuralPolicy(scope);
            }
            if (args.length == 0) {
                rt = new RelationType(typeA, typeB, true, false, false, false, false);
                baseColoring = policy.createColoring(typeA.universe(scope)).extend(typeB.universe(scope));
                var.setType(rt);
                isoValue = new FunctionValue(rt, scope);
                baseValue = new FunctionValue(rt, scope);
                doFuncs = true;
            } else if (args[0].equals("A->B") || args[0].equals("A-B")) {
                rt = new RelationType(typeA, typeB, true, false, false, false, false);
                baseColoring = policy.createColoring(typeA.universe(scope)).extend(typeB.universe(scope));
                var.setType(rt);
                isoValue = new FunctionValue(rt, scope);
                baseValue = new FunctionValue(rt, scope);
                doFuncs = true;
            } else if (args[0].equals("A->A") || args[0].equals("A-A")) {
                rt = new RelationType(typeA, typeA, true, false, false, false, false);
                baseColoring = policy.createColoring(typeA.universe(scope));
                var.setType(rt);
                baseValue = new FunctionValue(rt, scope);
                isoValue = new FunctionValue(rt, scope);
                sameTypes = true;
                doFuncs = true;
            } else if (args[0].equals("A<->B") || args[0].equals("A=B")) {
                rt = new RelationType(typeA, typeB, false, false, false, false, false);
                baseColoring = policy.createColoring(typeA.universe(scope)).extend(typeB.universe(scope));
                var.setType(rt);
                isoValue = new RelationValue(rt, scope);
                baseValue = new RelationValue(rt, scope);
                doRels = true;
            } else if (args[0].equals("A<->A") || args[0].equals("A=A")) {
                rt = new RelationType(typeA, typeA, false, false, false, false, false);
                baseColoring = policy.createColoring(typeA.universe(scope));
                var.setType(rt);
                baseValue = new RelationValue(rt, scope);
                isoValue = new RelationValue(rt, scope);
                sameTypes = true;
                doRels = true;
            } else if (args[0].equals("setA")) {
                SetType st = new SetType(typeA);
                baseColoring = policy.createColoring(st.elemType().universe(scope));
                var.setType(st);
                baseValue = new SetValue(st, scope);
                isoValue = new SetValue(st, scope);
                doSets = true;
            } else if (args[0].equals("chainA")) {
                rt = new RelationType(typeA, typeA, true, false, false, false, false);
                baseColoring = policy.createColoring(typeA.universe(scope));
                var.setType(rt);
                baseValue = new FunctionValue(rt, scope);
                ((FunctionValue)baseValue).markChain();
                isoValue = new FunctionValue(rt, scope);
                ((FunctionValue)isoValue).markChain();
                sameTypes = true;
                doChains = true;
            } else {
                System.out.println("Unsupported type: " + args[0]);
                return;
            }
            int i3 = 1;
            while (i3 < args.length) {
                if (args[i3].equals("out")) {
                    outFile = new PrintStream(new FileOutputStream(new File(args[++i3])));
                } else if (args[i3].equals("atomic")) {
                    useAtom = true;
                    useDomain = false;
                    useStruct = false;
                } else if (args[i3].equals("struct")) {
                    useAtom = false;
                    useDomain = false;
                    useStruct = true;
                } else if (args[i3].equals("domain")) {
                    useAtom = false;
                    useDomain = true;
                    useStruct = false;
                } else if (args[i3].equals("useIso")) {
                    useIso = true;
                    useGen = false;
                    useAll = false;
                } else if (args[i3].equals("useGen")) {
                    useIso = false;
                    useGen = true;
                    useAll = false;
                } else if (args[i3].equals("useAll")) {
                    useIso = true;
                    useGen = false;
                    useAll = true;
                } else if (args[i3].equals("showAuto")) {
                    showAuto = true;
                } else if (!args[i3].substring(0, 1).equals("#")) {
                    if (args[i3].equals("showMaps")) {
                        dumpMaps = true;
                    } else {
                        System.out.println("Unsupported option: " + args[i3]);
                    }
                }
                ++i3;
            }
            SetType dtype = new SetType(typeA);
            SetType rtype = sameTypes ? new SetType(typeA) : new SetType(typeB);
            dom1 = new SetValue(dtype, scope);
            dom2 = new SetValue(dtype, scope);
            ran1 = new SetValue(rtype, scope);
            ran2 = new SetValue(rtype, scope);
            dsets1 = new SetValue[maxBound];
            rsets1 = new SetValue[maxBound];
            dsets2 = new SetValue[maxBound];
            rsets2 = new SetValue[maxBound];
            int i4 = 0;
            while (i4 < maxBound) {
                AutoFinder.dsets1[i4] = new SetValue(dtype, scope);
                AutoFinder.dsets2[i4] = new SetValue(dtype, scope);
                AutoFinder.rsets1[i4] = new SetValue(rtype, scope);
                AutoFinder.rsets2[i4] = new SetValue(rtype, scope);
                ++i4;
            }
            outFile.println("Testing " + (useAtom ? "atomic " : (useStruct ? "structural " : "domain")) + " coloring of " + (doFuncs ? "functions" : (doSets ? "sets" : (doRels ? "rels" : "??"))));
            outFile.println("For " + scope.toString());
            numValues = 0;
            numPerms = 0;
            affectedValues = 0;
            affectedPerms = 0;
            if (doFuncs) {
                FuncIsoGenerator isoGen = new FuncIsoGenerator((FunctionValue)isoValue, var, var.getType(), scope, baseColoring);
                AutoFinder.findAutos(isoGen, scope, baseColoring, useIso, useAll, showAuto);
            } else if (doRels) {
                RelIsoGenerator isoGen = new RelIsoGenerator((RelationValue)isoValue, var, var.getType(), scope, baseColoring);
                AutoFinder.findAutos(isoGen, scope, baseColoring, useIso, useAll, showAuto);
            } else if (doChains) {
                ChainIsoGenerator isoGen = new ChainIsoGenerator((FunctionValue)isoValue, var, var.getType(), scope, baseColoring);
                AutoFinder.findAutos(isoGen, scope, baseColoring, useIso, useAll, showAuto);
            } else if (doSets) {
                SetIsoGenerator isoGen = new SetIsoGenerator((SetValue)isoValue, var, var.getType(), scope, baseColoring);
                AutoFinder.findAutos(isoGen, scope, baseColoring, useIso, useAll, showAuto);
            }
            outFile.println(String.valueOf(String.valueOf(numValues)) + " total values with " + String.valueOf(numPerms) + " total permutations (" + String.valueOf((double)numPerms / (double)numValues) + ")");
            outFile.print(String.valueOf(String.valueOf(affectedValues)) + " affected values (" + String.valueOf((affectedValues * 100 + numValues / 2) / numValues) + "%) with " + String.valueOf(affectedValuePerms) + " total permutations (");
            if (affectedValues > 0) {
                outFile.println(String.valueOf(String.valueOf((double)affectedValuePerms / (double)affectedValues)) + ")");
            } else {
                outFile.println("*)");
            }
            outFile.println(String.valueOf(String.valueOf(affectedPerms)) + " affected permutations (" + String.valueOf((affectedPerms * 100 + numPerms / 2) / numPerms) + "%)");
            if (affectedValues > 0) {
                outFile.println(String.valueOf(String.valueOf((double)affectedPerms / (double)affectedValues)) + " affected permutations per affected value (" + String.valueOf((affectedPerms * 100 + affectedValuePerms / 2) / affectedValuePerms) + "%)");
            }
            outFile.println(String.valueOf(String.valueOf((double)domPerms / (double)numValues)) + " avg # dom perm and " + String.valueOf((double)ranPerms / (double)numValues) + " avg # ran perms");
            if (affectedValues > 0) {
                outFile.println(String.valueOf(String.valueOf((double)affDomPerms / (double)affectedValues)) + " avg # dom perms/affected value and " + String.valueOf((double)affRanPerms / (double)affectedValues) + " avg # ran perms/affected value");
            }
            outFile.println(String.valueOf(String.valueOf((double)domColors / (double)numValues)) + " avg # dom colors and " + String.valueOf((double)ranColors / (double)numValues) + " avg # ran colors");
            if (affectedValues > 0) {
                outFile.println(String.valueOf(String.valueOf((double)affDomColors / (double)affectedValues)) + " avg # dom colors/affected value and " + String.valueOf((double)affRanColors / (double)affectedValues) + " avg # ran colors/affected value");
            }
            System.out.println("Finished test");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void findAutos(FunctionGenerator isoFree, Scope scope, Coloring coloring, boolean useIso, boolean useAll, boolean showAuto) {
        int i;
        FunctionValue[] isoFreeValues;
        RelationType rt = (RelationType)isoFree.typeGenerated();
        if (useIso) {
            SetValue dom = new SetValue(new SetType(rt.domain()), scope);
            SetValue ran = new SetValue(new SetType(rt.range()), scope);
            Vector[][] isoFunctions = new Vector[(int)rt.domain().numValues(scope) + 1][(int)rt.range().numValues(scope) + 1];
            int d = 0;
            while ((long)d <= rt.domain().numValues(scope)) {
                int r = 0;
                while ((long)r <= rt.range().numValues(scope)) {
                    if (r <= d) {
                        isoFunctions[d][r] = new Vector();
                    }
                    ++r;
                }
                ++d;
            }
            isoFreeValues = AutoFinder.isoFreeSet(isoFree, scope, true, coloring, isoFunctions);
        } else {
            int count = 0;
            isoFree.reset();
            while (isoFree.hasMoreElements()) {
                isoFree.nextFunction();
                ++count;
            }
            isoFreeValues = new FunctionValue[count];
            isoFree.reset();
            i = 0;
            while (i < count) {
                isoFreeValues[i] = (FunctionValue)isoFree.nextFunction().copy();
                ++i;
            }
        }
        i = 0;
        while (i < isoFreeValues.length) {
            AutoFinder.checkAuto(isoFreeValues[i], coloring, scope, useAll, showAuto);
            if (i % 100 == 99) {
                System.err.println("Processed " + String.valueOf(i + 1) + " functions");
            }
            ++i;
        }
    }

    private static FunctionValue[] isoFreeSet(FunctionGenerator gen, Scope scope, boolean reportDups, Coloring coloring, Vector[][] isoFunctions) {
        gen.reset();
        int max = (int)gen.totalGenValues();
        FunctionValue[] isoFree = new FunctionValue[max];
        int numIsoFree = 0;
        RelationType rt = (RelationType)gen.typeGenerated();
        SetValue dom = new SetValue(new SetType(rt.domain()), scope);
        SetValue ran = new SetValue(new SetType(rt.range()), scope);
        boolean numDups = false;
        block0: while (gen.hasMoreElements()) {
            FunctionValue fv = gen.nextFunction();
            fv.domain(dom);
            int d = dom.card();
            fv.range(ran);
            int r = ran.card();
            Enumeration fe = isoFunctions[d][r].elements();
            while (fe.hasMoreElements()) {
                FunctionValue fv2 = (FunctionValue)fe.nextElement();
                if (!AutoFinder.areIsomorphs(fv, fv2, scope, coloring)) continue;
                if (!reportDups) continue block0;
                outFile.println("Isomorphic function discovered");
                outFile.println(AutoFinder.merge(fv.toString(), fv2.toString()));
                continue block0;
            }
            fv = (FunctionValue)fv.copy();
            isoFree[numIsoFree++] = fv;
            isoFunctions[d][r].insertElementAt(fv, 0);
        }
        if (numIsoFree == max) {
            return isoFree;
        }
        FunctionValue[] justFree = new FunctionValue[numIsoFree];
        int i = 0;
        while (i < numIsoFree) {
            justFree[i] = isoFree[i];
            ++i;
        }
        return justFree;
    }

    public static void checkAuto(FunctionValue f, Coloring coloring, Scope scope, boolean useAll, boolean showAuto) {
        ScalarType dom = f.domainType();
        ScalarType ran = f.rangeType();
        int dmax = f.domainMax();
        int rmax = f.rangeMax();
        RelationType rt = (RelationType)f.getType();
        FunctionValue scr1 = new FunctionValue(rt, dmax, rmax, false);
        Vector<Perm> dauto = new Vector<Perm>();
        if (dumpMaps) {
            outFile.println("Checking for automorphism group of " + f.toString());
        }
        f.domain(dom1);
        f.range(ran1);
        if (dom.equals(ran)) {
            dom1.union(ran1, dom2);
            FunctionGenerator domMaps = AutoFinder.findBijGen(dom, scope, dmax, f, true, true);
            domMaps.reset();
            while (domMaps.hasMoreElements()) {
                FunctionValue dmap = domMaps.nextFunction();
                if (dumpMaps) {
                    outFile.println("Checking domain map = " + dmap.toString());
                }
                dmap.compose(f, scr1);
                if (!scr1.equals(f)) continue;
                dauto.addElement(new Perm(dmap, dmax));
                if (!dumpMaps) continue;
                outFile.println("Is automorphism");
            }
            AutoFinder.computeAutos(f, dom, ran, dmax, dmax, dauto, null, useAll);
            if (showAuto) {
                AutoFinder.dumpAutos(f, dom, ran, dauto, null);
            }
        } else {
            Vector<Perm> rauto = new Vector<Perm>();
            FunctionGenerator domMaps = AutoFinder.findBijGen(dom, scope, dmax, f, true, false);
            FunctionGenerator ranMaps = AutoFinder.findBijGen(ran, scope, rmax, f, false, true);
            FunctionValue scr2 = new FunctionValue(rt, dmax, rmax, false);
            FunctionValue rmaptrans = new FunctionValue(new RelationType(ran, ran, true, true, true, false, false), rmax, rmax, false);
            domMaps.reset();
            while (domMaps.hasMoreElements()) {
                FunctionValue dmap = domMaps.nextFunction();
                Perm dmapCopy = new Perm(dmap, dmax);
                if (dumpMaps) {
                    outFile.println("Checking domain map = " + dmap.toString());
                }
                dmap.compose(f, scr1);
                ranMaps.reset();
                while (ranMaps.hasMoreElements()) {
                    FunctionValue rmap = ranMaps.nextFunction();
                    if (dumpMaps) {
                        outFile.println("Checking range map = " + rmap.toString());
                    }
                    try {
                        rmap.transpose(rmaptrans);
                    }
                    catch (Exception exception) {}
                    scr1.compose(rmaptrans, scr2);
                    if (!scr2.equals(f)) continue;
                    dauto.addElement(dmapCopy);
                    rauto.addElement(new Perm(rmap, rmax));
                    if (!dumpMaps) continue;
                    outFile.println("Is automorphism");
                }
            }
            AutoFinder.computeAutos(f, dom, ran, dmax, rmax, dauto, rauto, useAll);
            if (showAuto) {
                AutoFinder.dumpAutos(f, dom, ran, dauto, rauto);
            }
        }
    }

    public static void findAutos(RelationGenerator isoFree, Scope scope, Coloring coloring, boolean useIso, boolean useAll, boolean showAuto) {
        int i;
        RelationValue[] isoFreeValues;
        RelationType rt = (RelationType)isoFree.typeGenerated();
        if (useIso) {
            Vector[] isoRels = new Vector[1 + (int)rt.domain().numValues(scope) * (int)rt.range().numValues(scope) + 1];
            int e = (int)rt.domain().numValues(scope) * (int)rt.range().numValues(scope);
            while (e >= 0) {
                isoRels[e] = new Vector();
                --e;
            }
            isoFreeValues = AutoFinder.isoFreeSet(isoFree, scope, true, coloring, isoRels);
        } else {
            int count = 0;
            isoFree.reset();
            while (isoFree.hasMoreElements()) {
                isoFree.nextRelation();
                ++count;
            }
            isoFreeValues = new RelationValue[count];
            isoFree.reset();
            i = 0;
            while (i < count) {
                isoFreeValues[i] = (RelationValue)isoFree.nextRelation().copy();
                ++i;
            }
        }
        i = 0;
        while (i < isoFreeValues.length) {
            AutoFinder.checkAuto(isoFreeValues[i], coloring, scope, useAll, showAuto);
            if (i % 100 == 99) {
                System.err.println("Processed " + String.valueOf(i + 1) + " relations");
            }
            ++i;
        }
    }

    private static RelationValue[] isoFreeSet(RelationGenerator gen, Scope scope, boolean reportDups, Coloring coloring, Vector[] isoRels) {
        gen.reset();
        Vector<RelationValue> isoFree = new Vector<RelationValue>();
        int numIsoFree = 0;
        RelationType rt = (RelationType)gen.typeGenerated();
        boolean numDups = false;
        block0: while (gen.hasMoreElements()) {
            RelationValue rv = gen.nextRelation();
            int e = rv.card();
            Enumeration re = isoRels[e].elements();
            while (re.hasMoreElements()) {
                RelationValue rv2 = (RelationValue)re.nextElement();
                if (!AutoFinder.areIsomorphs(rv, rv2, scope, coloring)) continue;
                if (!reportDups) continue block0;
                outFile.println("Isomorphic relation discovered");
                outFile.println(AutoFinder.merge(rv.toString(), rv2.toString()));
                continue block0;
            }
            rv = (RelationValue)rv.copy();
            ++numIsoFree;
            isoFree.addElement(rv);
            isoRels[e].insertElementAt(rv, 0);
        }
        RelationValue[] justFree = new RelationValue[numIsoFree];
        int i = 0;
        while (i < numIsoFree) {
            justFree[i] = (RelationValue)isoFree.elementAt(i);
            ++i;
        }
        return justFree;
    }

    public static void checkAuto(RelationValue f, Coloring coloring, Scope scope, boolean useAll, boolean showAuto) {
        ScalarType dom = f.domainType();
        ScalarType ran = f.rangeType();
        int dmax = f.domainMax();
        int rmax = f.rangeMax();
        RelationType rt = (RelationType)f.getType();
        RelationValue scr1 = new RelationValue(rt, dmax, rmax);
        Vector<Perm> dauto = new Vector<Perm>();
        f.domain(dom1);
        f.range(ran1);
        if (dom.equals(ran)) {
            dom1.union(ran1, dom2);
            FunctionGenerator domMaps = AutoFinder.findBijGen(dom, scope, dmax, f, true, true);
            domMaps.reset();
            while (domMaps.hasMoreElements()) {
                FunctionValue dmap = domMaps.nextFunction();
                dmap.compose(f, scr1);
                if (!scr1.equals(f)) continue;
                dauto.addElement(new Perm(dmap, dmax));
            }
            AutoFinder.computeAutos(f, dom, ran, dmax, dmax, dauto, null, useAll);
            if (showAuto) {
                AutoFinder.dumpAutos(f, dom, ran, dauto, null);
            }
        } else {
            Vector<Perm> rauto = new Vector<Perm>();
            FunctionGenerator domMaps = AutoFinder.findBijGen(dom, scope, dmax, f, true, false);
            FunctionGenerator ranMaps = AutoFinder.findBijGen(ran, scope, rmax, f, false, true);
            RelationValue scr2 = new RelationValue(rt, dmax, rmax);
            FunctionValue rmaptrans = new FunctionValue(new RelationType(ran, ran, true, true, true, false, false), rmax, rmax, false);
            domMaps.reset();
            while (domMaps.hasMoreElements()) {
                FunctionValue dmap = domMaps.nextFunction();
                Perm dmapCopy = new Perm(dmap, dmax);
                dmap.compose(f, scr1);
                ranMaps.reset();
                while (ranMaps.hasMoreElements()) {
                    FunctionValue rmap = ranMaps.nextFunction();
                    try {
                        rmap.transpose(rmaptrans);
                    }
                    catch (Exception exception) {}
                    scr1.compose(rmaptrans, scr2);
                    if (!scr2.equals(f)) continue;
                    dauto.addElement(dmapCopy);
                    rauto.addElement(new Perm(rmap, rmax));
                }
            }
            AutoFinder.computeAutos(f, dom, ran, dmax, rmax, dauto, rauto, useAll);
            if (showAuto) {
                AutoFinder.dumpAutos(f, dom, ran, dauto, rauto);
            }
        }
    }

    public static void findAutos(SetGenerator isoFree, Scope scope, Coloring coloring, boolean useIso, boolean useAll, boolean showAuto) {
        int i;
        SetValue[] isoFreeValues;
        if (useIso) {
            isoFreeValues = AutoFinder.isoFreeSet(isoFree, scope, true, coloring);
        } else {
            int count = 0;
            isoFree.reset();
            while (isoFree.hasMoreElements()) {
                isoFree.nextSet();
                ++count;
            }
            isoFreeValues = new SetValue[count];
            isoFree.reset();
            i = 0;
            while (i < count) {
                isoFreeValues[i] = (SetValue)isoFree.nextSet().copy();
                ++i;
            }
        }
        i = 0;
        while (i < isoFreeValues.length) {
            AutoFinder.checkAuto(isoFreeValues[i], coloring, scope, useAll, showAuto);
            if (i % 100 == 99) {
                System.err.println("Processed " + String.valueOf(i + 1) + " sets");
            }
            ++i;
        }
    }

    private static SetValue[] isoFreeSet(SetGenerator gen, Scope scope, boolean reportDups, Coloring coloring) {
        int i;
        gen.reset();
        int max = (int)gen.totalGenValues();
        SetValue[] isoFree = new SetValue[max];
        int numIsoFree = 0;
        boolean numDups = false;
        block0: while (gen.hasMoreElements()) {
            SetValue sv = gen.nextSet();
            i = 0;
            while (i < numIsoFree) {
                if (AutoFinder.areIsomorphs(sv, isoFree[i], scope, coloring)) {
                    if (!reportDups) continue block0;
                    outFile.println("Isomorphic function discovered");
                    outFile.println(AutoFinder.merge(sv.toString(), isoFree[i].toString()));
                    continue block0;
                }
                ++i;
            }
            isoFree[numIsoFree++] = (SetValue)sv.copy();
        }
        if (numIsoFree == max) {
            return isoFree;
        }
        SetValue[] justFree = new SetValue[numIsoFree];
        i = 0;
        while (i < numIsoFree) {
            justFree[i] = isoFree[i];
            ++i;
        }
        return justFree;
    }

    public static void checkAuto(SetValue s, Coloring coloring, Scope scope, boolean useAll, boolean showAuto) {
        ScalarType dom = s.elemType();
        int max = s.elemMax();
        ++numValues;
        numPerms += AutoFinder.fact(s.card()) * AutoFinder.fact(max - s.card());
    }

    static void computeAutos(Value v, ScalarType dtype, ScalarType rtype, int dmax, int rmax, Vector dautos, Vector rautos, boolean useAll) {
        int unique;
        int[] dcolors = new int[dmax];
        int[] rcolors = null;
        int numRColors = 0;
        int numRPerms = 0;
        Enumeration r = null;
        int tperms = AutoFinder.fact(dmax);
        if (rautos != null) {
            tperms *= AutoFinder.fact(rmax);
        }
        int countsAs = 1;
        if (useAll) {
            countsAs = tperms / dautos.size();
        }
        numValues += countsAs;
        numPerms += countsAs * dautos.size();
        int i = 0;
        while (i < dmax) {
            dcolors[i] = i;
            ++i;
        }
        Enumeration d = dautos.elements();
        if (rautos != null) {
            r = rautos.elements();
        }
        block1: while (d.hasMoreElements()) {
            Perm dmap = (Perm)d.nextElement();
            if (!useDomain && rautos != null) {
                Perm rmap;
                if (useAtom) {
                    rmap = (Perm)r.nextElement();
                    i = 0;
                    while (i < rmax) {
                        if (rmap.mapsTo(i) != i) continue block1;
                        ++i;
                    }
                } else if (useStruct) {
                    rmap = (Perm)r.nextElement();
                    unique = -1;
                    i = 0;
                    while (i < rmax) {
                        if (rmap.mapsTo(i) != i) {
                            if (unique == -1) {
                                unique = i;
                            } else if (unique != rmap.mapsTo(i)) continue block1;
                        }
                        ++i;
                    }
                }
            }
            unique = -1;
            i = 0;
            while (i < dmax) {
                if (dmap.mapsTo(i) != i) {
                    if (unique == -1) {
                        unique = i;
                    } else if (unique != dmap.mapsTo(i)) {
                        unique = -1;
                        break;
                    }
                }
                ++i;
            }
            if (unique == -1 || dmap.mapsTo(unique) != unique + 1 || dcolors[unique] == dcolors[unique + 1]) continue;
            i = unique + 1;
            while (i < dmax) {
                int n = i++;
                dcolors[n] = dcolors[n] - 1;
            }
        }
        int numDColors = 1;
        int numDPerms = 1;
        int j = 0;
        i = 1;
        while (i < dmax) {
            if (dcolors[i - 1] != dcolors[i]) {
                numDPerms *= AutoFinder.fact(i - j);
                j = i;
                ++numDColors;
            }
            ++i;
        }
        domColors += numDColors * countsAs;
        domPerms += (numDPerms *= AutoFinder.fact(dmax - j)) * countsAs;
        if (rautos != null) {
            rcolors = new int[rmax];
            i = 0;
            while (i < rmax) {
                rcolors[i] = i;
                ++i;
            }
            d = dautos.elements();
            r = rautos.elements();
            block8: while (r.hasMoreElements()) {
                Perm rmap = (Perm)r.nextElement();
                if (!useDomain) {
                    Perm dmap;
                    if (useAtom) {
                        dmap = (Perm)d.nextElement();
                        i = 0;
                        while (i < dmax) {
                            if (dmap.mapsTo(i) != i) continue block8;
                            ++i;
                        }
                    } else if (useStruct) {
                        dmap = (Perm)d.nextElement();
                        unique = -1;
                        i = 0;
                        while (i < dmax) {
                            if (dmap.mapsTo(i) != i) {
                                if (unique == -1) {
                                    unique = i;
                                } else if (unique != dmap.mapsTo(i)) continue block8;
                            }
                            ++i;
                        }
                    }
                }
                unique = -1;
                i = 0;
                while (i < rmax) {
                    if (rmap.mapsTo(i) != i) {
                        if (unique == -1) {
                            unique = i;
                        } else if (unique != rmap.mapsTo(i)) {
                            unique = -1;
                            break;
                        }
                    }
                    ++i;
                }
                if (unique == -1 || rmap.mapsTo(unique) != unique + 1 || rcolors[unique] == rcolors[unique + 1]) continue;
                i = unique + 1;
                while (i < rmax) {
                    int n = i++;
                    rcolors[n] = rcolors[n] - 1;
                }
            }
            numRColors = 1;
            numRPerms = 1;
            j = 0;
            i = 1;
            while (i < rmax) {
                if (rcolors[i - 1] != rcolors[i]) {
                    numRPerms *= AutoFinder.fact(i - j);
                    j = i;
                    ++numRColors;
                }
                ++i;
            }
            ranColors += numRColors * countsAs;
            ranPerms += (numRPerms *= AutoFinder.fact(rmax - j)) * countsAs;
        }
        boolean foundAny = false;
        d = dautos.elements();
        if (rautos != null) {
            r = rautos.elements();
        }
        int allowedPerms = 0;
        block14: while (d.hasMoreElements()) {
            Perm dmap = (Perm)d.nextElement();
            Perm rmap = null;
            if (rautos != null) {
                rmap = (Perm)r.nextElement();
            }
            i = 0;
            while (i < dmax) {
                if (dcolors[i] != dcolors[dmap.mapsTo(i)]) {
                    affectedPerms += countsAs;
                    if (!foundAny) {
                        foundAny = true;
                        affectedValues += countsAs;
                        affDomColors += numDColors * countsAs;
                        affRanColors += numRColors * countsAs;
                        affDomPerms += numDPerms * countsAs;
                        affRanPerms += numRPerms * countsAs;
                        affectedValuePerms += dautos.size() * countsAs;
                        outFile.println("Value " + v.toString() + ":");
                    }
                    AutoFinder.dumpAuto(dtype, rtype, dmap, rmap);
                    continue block14;
                }
                ++i;
            }
            if (rautos != null) {
                i = 0;
                while (i < rmax) {
                    if (rcolors[i] != rcolors[rmap.mapsTo(i)]) {
                        affectedPerms += countsAs;
                        if (!foundAny) {
                            foundAny = true;
                            affectedValues += countsAs;
                            affDomColors += numDColors * countsAs;
                            affRanColors += numRColors * countsAs;
                            affDomPerms += numDPerms * countsAs;
                            affRanPerms += numRPerms * countsAs;
                            affectedValuePerms += dautos.size() * countsAs;
                            outFile.println("Value " + v.toString() + ":");
                        }
                        AutoFinder.dumpAuto(dtype, rtype, dmap, rmap);
                        continue block14;
                    }
                    ++i;
                }
            }
            ++allowedPerms;
        }
        if (allowedPerms > numDPerms * numRPerms) {
            outFile.println("problems with permutations in value " + v.toString());
        }
    }

    static void dumpAutos(Value v, ScalarType dtype, ScalarType rtype, Vector dautos, Vector rautos) {
        Enumeration r = null;
        outFile.println("Automorphism group for " + v.toString() + ":");
        Enumeration d = dautos.elements();
        if (rautos != null) {
            r = rautos.elements();
        }
        while (d.hasMoreElements()) {
            Perm df = (Perm)d.nextElement();
            if (rautos != null) {
                Perm rf = (Perm)r.nextElement();
                AutoFinder.dumpAuto(dtype, rtype, df, rf);
                continue;
            }
            AutoFinder.dumpAuto(dtype, rtype, df, null);
        }
    }

    static void dumpAuto(ScalarType dtype, ScalarType rtype, Perm dmap, Perm rmap) {
        outFile.print("    (");
        boolean foundAny = false;
        int i = 0;
        while (i < dmap.domainMax()) {
            if (i < dmap.mapsTo(i)) {
                if (foundAny) {
                    outFile.print(")(");
                } else {
                    foundAny = true;
                }
                outFile.print(String.valueOf(dtype.getElementName(i)) + dtype.getElementName(dmap.mapsTo(i)));
            }
            ++i;
        }
        if (rmap != null) {
            i = 0;
            while (i < rmap.domainMax()) {
                if (i < rmap.mapsTo(i)) {
                    if (foundAny) {
                        outFile.print(")(");
                    } else {
                        foundAny = true;
                    }
                    outFile.print(String.valueOf(rtype.getElementName(i)) + rtype.getElementName(rmap.mapsTo(i)));
                }
                ++i;
            }
        }
        outFile.println(")");
    }

    protected static int fact(int base) {
        int answer = 1;
        int i = 2;
        while (i <= base) {
            answer *= i;
            ++i;
        }
        return answer;
    }

    private static FunctionGenerator findBijGen(Scope scope, ScalarType elemType, Coloring coloring) {
        RelationType rt = new RelationType(elemType, elemType, true, true, true, true, false);
        FunctionValue map = new FunctionValue(rt, scope);
        Variable v = null;
        try {
            v = new Variable("x", rt, null, SourceLoc.noLoc);
        }
        catch (ParseError parseError) {}
        int[] colors = new int[(int)elemType.numValues(scope)];
        coloring.coloring(elemType.universe(scope), colors);
        int numColors = 1;
        int i = 1;
        while (i < map.domainMax()) {
            if (colors[i] != colors[i - 1]) {
                ++numColors;
            }
            ++i;
        }
        if (numColors == 1) {
            return new FuncBijExhGenerator(map, v, v.getType(), scope);
        }
        return new ColorMapper(map, v, scope, colors, numColors);
    }

    private static FunctionGenerator findBijGen(Scope scope, ScalarType elemType, Coloring coloring, SetValue[] sets1, SetValue[] sets2, int max) {
        RelationType rt = new RelationType(elemType, elemType, true, true, true, true, false);
        FunctionValue map = new FunctionValue(rt, scope);
        Variable v = null;
        try {
            v = new Variable("x", rt, null, SourceLoc.noLoc);
        }
        catch (ParseError parseError) {}
        int[] colors1 = new int[(int)elemType.numValues(scope)];
        int[] colors2 = new int[(int)elemType.numValues(scope)];
        coloring.coloring(elemType.universe(scope), colors1);
        coloring.coloring(elemType.universe(scope), colors2);
        int i = 0;
        while (i < colors1.length) {
            int n = i;
            colors1[n] = colors1[n] * (max + 1);
            int n2 = i;
            colors2[n2] = colors2[n2] * (max + 1);
            int j = 0;
            while (j < max) {
                if (sets1[j].hasElement(i)) {
                    int n3 = i;
                    colors1[n3] = colors1[n3] + (j + 1);
                }
                if (sets2[j].hasElement(i)) {
                    int n4 = i;
                    colors2[n4] = colors2[n4] + (j + 1);
                }
                ++j;
            }
            ++i;
        }
        int numColors1 = 1;
        int numColors2 = 1;
        int i2 = 1;
        while (i2 < map.domainMax()) {
            int j = 0;
            while (j < i2) {
                if (colors1[j] == colors1[i2]) break;
                ++j;
            }
            if (j == i2) {
                ++numColors1;
            }
            j = 0;
            while (j < i2) {
                if (colors2[j] == colors2[i2]) break;
                ++j;
            }
            if (j == i2) {
                ++numColors2;
            }
            ++i2;
        }
        if (numColors1 != numColors2) {
            return null;
        }
        if (numColors1 == 1) {
            return new FuncBijExhGenerator(map, v, v.getType(), scope);
        }
        DegreeMapper fg = new DegreeMapper(map, v, scope, colors1, colors2, numColors1);
        return fg;
    }

    private static FunctionGenerator findBijGen(ScalarType elemType, Scope scope, int max, RelOrFuncValue f, boolean consDom, boolean consRan) {
        RelationType rt = new RelationType(elemType, elemType, true, true, true, true, false);
        FunctionValue map = new FunctionValue(rt, max, max, false);
        Variable v = null;
        try {
            v = new Variable("x", rt, null, SourceLoc.noLoc);
        }
        catch (ParseError parseError) {}
        int[] colors = new int[max];
        int i = 0;
        while (i < max) {
            colors[i] = 0;
            if (consDom) {
                colors[i] = f.ddegree(i) * max;
            }
            if (consRan) {
                int n = i;
                colors[n] = colors[n] + f.rdegree(i);
            }
            ++i;
        }
        int numColors = 1;
        i = 1;
        while (i < max) {
            int j = 0;
            while (j < i) {
                if (colors[j] == colors[i]) break;
                ++j;
            }
            if (j == i) {
                ++numColors;
            }
            ++i;
        }
        if (numColors == 1) {
            return new FuncBijExhGenerator(map, v, v.getType(), scope);
        }
        return new DegreeMapper(map, v, scope, colors, colors, numColors);
    }

    private static void setColoring(Coloring baseColoring, ScalarType t, Scope scope, String coloringString) {
        SetValue sv = new SetValue(new SetType(t), scope);
        Coloring c = baseColoring;
        while (!c.baseType().equiv(t) && c.getPrevColoring() != null) {
            c = c.getPrevColoring();
        }
        c.reset();
        sv.init();
        sv.addElement(0);
        int j = 1;
        while (j < coloringString.length()) {
            if (coloringString.charAt(j - 1) != coloringString.charAt(j)) {
                c.distinguish(sv);
                sv.init();
            }
            sv.addElement(j);
            ++j;
        }
        c.distinguish(sv);
    }

    private static String merge(String s1, String s2) {
        int next;
        int maxlen = 0;
        int tabsize = 6;
        String s = "";
        String blanks = "                               ";
        int i1 = 0;
        while ((next = s1.indexOf(Tree.linesep(), i1)) >= 0) {
            if (next - i1 > maxlen) {
                maxlen = next - i1;
            }
            i1 = next + Tree.linesep().length();
        }
        if (s1.length() - i1 > maxlen) {
            maxlen = s1.length() - i1;
        }
        i1 = 0;
        int i2 = 0;
        while (i1 < s1.length() && i2 < s2.length()) {
            next = s1.indexOf(Tree.linesep(), i1);
            if (next >= 0) {
                s = String.valueOf(s) + s1.substring(i1, next);
                s = String.valueOf(s) + blanks.substring(0, maxlen - (next - i1) + tabsize);
                i1 = next + Tree.linesep().length();
            } else {
                s = String.valueOf(s) + s1.substring(i1);
                s = String.valueOf(s) + blanks.substring(0, maxlen - (s1.length() - i1) + tabsize);
                i1 = s1.length();
            }
            next = s2.indexOf(Tree.linesep(), i2);
            if (next >= 0) {
                s = String.valueOf(s) + s2.substring(i2, next);
                s = String.valueOf(s) + Tree.linesep();
                i2 = next + Tree.linesep().length();
                continue;
            }
            s = String.valueOf(s) + s2.substring(i2);
            s = String.valueOf(s) + Tree.linesep();
            i2 = s2.length();
        }
        if (i1 < s1.length()) {
            s = String.valueOf(s) + s1.substring(i1);
        } else if (i2 < s2.length()) {
            while ((next = s2.indexOf(Tree.linesep(), i2)) >= 0) {
                s = String.valueOf(s) + blanks.substring(0, maxlen + tabsize);
                s = String.valueOf(s) + s2.substring(i2, next) + Tree.linesep();
                i2 = next + Tree.linesep().length();
            }
            s = String.valueOf(s) + blanks.substring(0, maxlen + tabsize);
            s = String.valueOf(s) + s2.substring(i2) + Tree.linesep();
        }
        return s;
    }
}

