/*
 * Decompiled with CFR 0.152.
 */
package ladybug.parse;

import java.util.Hashtable;
import ladybug.engine.DerivedVars;
import ladybug.engine.Scope;
import ladybug.parse.FormulaList;
import ladybug.parse.PartitionType;
import ladybug.parse.RelationType;
import ladybug.parse.Renaming;
import ladybug.parse.SetType;
import ladybug.parse.SourceLoc;
import ladybug.parse.Term;
import ladybug.parse.TermIndex;
import ladybug.parse.TermList;
import ladybug.parse.Tree;
import ladybug.parse.Type;
import ladybug.parse.TypeConflict;
import ladybug.parse.Variable;
import ladybug.parse.VariableList;
import ladybug.util.Partitioning;

public final class VarTerm
extends Term {
    public static final boolean show_schema = false;
    private Variable var;

    public VarTerm(Variable var, SourceLoc loc) {
        super(loc, var.getType());
        this.var = var;
        this.debug_init();
    }

    public VarTerm(Variable var) {
        super(SourceLoc.noLoc, var.getType());
        this.var = var;
        this.debug_init();
    }

    public int precedence() {
        return 0;
    }

    public VariableList vars() {
        VariableList vl = new VariableList(this.var);
        if (this.getType().isPartition()) {
            PartitionType pt = (PartitionType)this.getType();
            vl.addVar(pt.partFunction());
        }
        return vl;
    }

    public TermList terms() {
        return new TermList(this);
    }

    public boolean dependsOn(Variable v, DerivedVars dv) {
        if (this.var == v) {
            return true;
        }
        if (dv.isDerived(this.var)) {
            return dv.findEquiv(this.var).dependsOn(v, dv);
        }
        return false;
    }

    public FormulaList constraints() {
        return new FormulaList();
    }

    public Term copy() {
        return new VarTerm(this.var, this.location);
    }

    public Variable getVariable() {
        return this.var;
    }

    public boolean isPrime() {
        return this.getVariable().isPrime();
    }

    public boolean isPrimable() {
        return this.getVariable().isPrimable();
    }

    public String toString() {
        if (this._str == null) {
            this._str = this.getVariable().getName();
        }
        return this._str;
    }

    public void setType(Type newType) throws TypeConflict {
        if (this.getType() != null && !this.getType().equiv(newType) && newType.isComplete()) {
            throw new TypeConflict(this.getType(), newType, "resetting the type of " + this.toString() + " from %1 to %2");
        }
        super.setType(newType);
    }

    public void setDomain(Type newType) throws TypeConflict {
        RelationType rtype;
        if (newType == null) {
            return;
        }
        if (this.getType() != null && this.getType().isRelation() && (rtype = (RelationType)this.getType()).domain() != null && !rtype.domain().equiv(newType)) {
            throw new TypeConflict(this.getType(), newType, "resetting the domain of " + this.toString() + " from %1 to %2");
        }
        super.setType(newType);
    }

    public void setRange(Type newType) throws TypeConflict {
        RelationType rtype;
        if (newType == null) {
            return;
        }
        if (this.getType() != null && this.getType().isRelation() && (rtype = (RelationType)this.getType()).range() != null && !rtype.range().equiv(newType)) {
            throw new TypeConflict(this.getType(), newType, "resetting the range of " + this.toString() + " from %1 to %2");
        }
        super.setType(newType);
    }

    public void setElemType(Type newType) throws TypeConflict {
        SetType stype;
        if (newType == null) {
            return;
        }
        if (this.getType() != null && this.getType().isSet() && (stype = (SetType)this.getType()).elemType() != null && !stype.elemType().equiv(newType)) {
            throw new TypeConflict(this.getType(), newType, "resetting the element type of " + this.toString() + " from %1 to %2");
        }
        super.setType(newType);
    }

    public Term rename(Renaming r) {
        Term t = r.get(this.getVariable());
        return t == null ? this.copy() : t;
    }

    public Term prime() {
        if (!this.isPrimable()) {
            return this.copy();
        }
        return new VarTerm(this.getVariable().prime());
    }

    public boolean equiv(Tree other) {
        if (other.getClass() != this.getClass()) {
            return false;
        }
        VarTerm otherVT = (VarTerm)other;
        return otherVT.getVariable() == this.getVariable();
    }

    public TermIndex index() {
        return new TermIndex(this);
    }

    int equivHashCode(int hashSize) {
        if (this.eqHashCode < 0) {
            this.eqHashCode = (this.toString().hashCode() >>> 1) % hashSize;
        }
        return this.eqHashCode;
    }

    public Type mergeTypes(Hashtable varTypes, Partitioning merges) {
        if (varTypes.containsKey(this.getVariable())) {
            return (Type)varTypes.get(this.getVariable());
        }
        return this.getType();
    }

    public double estCard(Scope scope) {
        if (this._estCard < 0.0) {
            RelationType rtype;
            this._estCard = this.getType().isSet() ? (double)((SetType)this.getType()).elemType().numValues(scope) / 2.0 : (this.getType().isRelation() ? ((rtype = (RelationType)this.getType()).isFunction() ? (rtype.isTotal() ? (double)rtype.domain().numValues(scope) : (double)rtype.domain().numValues(scope) * ((double)rtype.range().numValues(scope) / ((double)rtype.range().numValues(scope) + 1.0))) : (rtype.isInjection() ? (rtype.isOnto() ? (double)rtype.range().numValues(scope) : (double)rtype.range().numValues(scope) * ((double)rtype.domain().numValues(scope) / ((double)rtype.domain().numValues(scope) + 1.0))) : (double)(rtype.domain().numValues(scope) * rtype.range().numValues(scope)) / 2.0)) : 1.0);
        }
        return this._estCard;
    }

    public double estDomCard(Scope scope) {
        if (this._estDomCard < 0.0) {
            if (this.getType().isRelation()) {
                RelationType rtype = (RelationType)this.getType();
                if (rtype.isTotal()) {
                    this._estDomCard = rtype.domain().numValues(scope);
                }
                this._estDomCard = rtype.domain().numValues(scope) - 1L;
            } else {
                this._estDomCard = 0.0;
            }
        }
        return this._estDomCard;
    }

    public double estRanCard(Scope scope) {
        if (this._estRanCard < 0.0) {
            if (this.getType().isRelation()) {
                RelationType rtype = (RelationType)this.getType();
                if (rtype.isOnto()) {
                    this._estRanCard = rtype.range().numValues(scope);
                }
                this._estRanCard = rtype.range().numValues(scope) - 1L;
            } else {
                this._estRanCard = 0.0;
            }
        }
        return this._estRanCard;
    }
}

