/*
 * Decompiled with CFR 0.152.
 */
package ladybug.parse;

import java.util.Hashtable;
import ladybug.engine.DerivedVars;
import ladybug.engine.Scope;
import ladybug.parse.DelegateType;
import ladybug.parse.FormulaList;
import ladybug.parse.GivenType;
import ladybug.parse.RelationType;
import ladybug.parse.Renaming;
import ladybug.parse.ScalarType;
import ladybug.parse.SetType;
import ladybug.parse.SourceLoc;
import ladybug.parse.Term;
import ladybug.parse.TermIndex;
import ladybug.parse.TermList;
import ladybug.parse.Tree;
import ladybug.parse.Type;
import ladybug.parse.TypeConflict;
import ladybug.parse.Variable;
import ladybug.parse.VariableList;
import ladybug.util.Partitioning;

public final class UnivTerm
extends Term {
    public UnivTerm(Type t, SourceLoc loc) {
        super(loc, t);
        this.debug_init();
    }

    public int precedence() {
        return 0;
    }

    public VariableList vars() {
        return new VariableList();
    }

    public TermList terms() {
        return new TermList(this);
    }

    public boolean dependsOn(Variable v, DerivedVars dv) {
        return false;
    }

    public FormulaList constraints() {
        return new FormulaList();
    }

    public Term copy() {
        return new UnivTerm(this.type, this.location);
    }

    public String toString() {
        if (this._str != null) {
            return this._str;
        }
        if (this.getType() != null && this.getType().isSet()) {
            SetType st = (SetType)this.getType();
            if (st.elemType() != null) {
                this._str = st.elemType().toString();
            }
        } else {
            this._str = "Un";
        }
        return this._str;
    }

    public Term rename(Renaming r) {
        return this.copy();
    }

    public boolean isPrime() {
        return false;
    }

    public boolean isPrimable() {
        return false;
    }

    public Term prime() {
        return this.copy();
    }

    public void setType(Type newType) throws TypeConflict {
        if (!newType.isRelation() && !newType.isSet()) {
            throw new TypeConflict(newType, null, "Invalid type %1 for universal term");
        }
        super.setType(newType);
    }

    public boolean equiv(Tree other) {
        if (other.getClass() != this.getClass()) {
            return false;
        }
        UnivTerm ut = (UnivTerm)other;
        return this.type.equiv(ut.type);
    }

    public TermIndex index() {
        return new TermIndex(this);
    }

    int equivHashCode(int hashSize) {
        return 1;
    }

    public Type mergeTypes(Hashtable varTypes, Partitioning merges) {
        Type t = this.getType();
        if (t == null) {
            return null;
        }
        if (t.isSet()) {
            SetType st = (SetType)t;
            if (st.elemType().isGivenType()) {
                return new SetType(new DelegateType((GivenType)st.elemType(), 0));
            }
            return st;
        }
        RelationType rt = (RelationType)t;
        ScalarType d = rt.domain();
        ScalarType r = rt.range();
        if (d.isGivenType()) {
            d = new DelegateType((GivenType)d, 0);
        }
        if (r.isGivenType()) {
            r = new DelegateType((GivenType)r, 0);
        }
        return new RelationType(d, r);
    }

    public double estCard(Scope scope) {
        if (this._estCard < 0.0) {
            if (this.type.isSet()) {
                this._estCard = ((SetType)this.getType()).elemType().numValues(scope);
            } else {
                RelationType rtype = (RelationType)this.getType();
                this._estCard = rtype.domain().numValues(scope) * rtype.range().numValues(scope);
            }
        }
        return this._estCard;
    }

    public double estDomCard(Scope scope) {
        if (this._estDomCard < 0.0) {
            this._estDomCard = this.getType().isSet() ? 0.0 : (double)((RelationType)this.getType()).domain().numValues(scope);
        }
        return this._estDomCard;
    }

    public double estRanCard(Scope scope) {
        if (this._estRanCard < 0.0) {
            this._estRanCard = this.getType().isSet() ? 0.0 : (double)((RelationType)this.getType()).range().numValues(scope);
        }
        return this._estRanCard;
    }
}

