/*
 * Decompiled with CFR 0.152.
 */
package ladybug.parse;

import java.util.Hashtable;
import ladybug.engine.DerivedVars;
import ladybug.engine.Scope;
import ladybug.parse.ErrorReporter;
import ladybug.parse.FormulaList;
import ladybug.parse.IntType;
import ladybug.parse.RelationType;
import ladybug.parse.Renaming;
import ladybug.parse.ScalarType;
import ladybug.parse.SetType;
import ladybug.parse.SourceLoc;
import ladybug.parse.Term;
import ladybug.parse.TermIndex;
import ladybug.parse.TermList;
import ladybug.parse.Tree;
import ladybug.parse.Type;
import ladybug.parse.TypeConflict;
import ladybug.parse.UnaryOperator;
import ladybug.parse.Variable;
import ladybug.parse.VariableList;
import ladybug.util.Partitioning;

public final class UnaryTerm
extends Term {
    public UnaryOperator op;
    public Term child;

    public UnaryTerm(Term c, UnaryOperator o, SourceLoc loc) {
        super(loc.merge(c.getLocation()));
        this.child = c;
        this.op = o;
        this.computeType();
        this.debug_init();
    }

    public UnaryTerm(Term c, UnaryOperator o, SourceLoc loc, Type type) {
        super(loc.merge(c.getLocation()));
        this.child = c;
        this.op = o;
        try {
            this.setType(type);
        }
        catch (TypeConflict typeConflict) {}
        this.debug_init();
    }

    public int precedence() {
        return this.op.precedence();
    }

    public VariableList vars() {
        return this.child.vars();
    }

    public TermList terms() {
        return new TermList(this).union(this.child.terms());
    }

    public boolean dependsOn(Variable v, DerivedVars dv) {
        return this.child.dependsOn(v, dv);
    }

    public FormulaList constraints() {
        return this.child.constraints();
    }

    public Term copy() {
        return new UnaryTerm(this.child.copy(), this.op, this.location, this.getType());
    }

    public String toString() {
        if (this._str != null) {
            return this._str;
        }
        String c = this.child.toString();
        if (this.op.precedence() < this.child.precedence()) {
            c = "(" + c + ")";
        }
        this._str = this.op.isPrefix() ? String.valueOf(this.op.toString()) + (this.op.useSpaces() ? " " : "") + c : String.valueOf(c) + (this.op.useSpaces() ? " " : "") + this.op.toString();
        return this._str;
    }

    public Term rename(Renaming r) {
        return new UnaryTerm(this.child.rename(r), this.op, SourceLoc.noLoc, this.getType());
    }

    public boolean isPrime() {
        return this.child.isPrime();
    }

    public boolean isPrimable() {
        return this.child.isPrimable();
    }

    public Term prime() {
        if (!this.isPrimable()) {
            return this.copy();
        }
        return new UnaryTerm(this.child.prime(), this.op, SourceLoc.noLoc, this.getType());
    }

    public void setType(Type newType) throws TypeConflict {
        if (newType == null) {
            return;
        }
        super.setType(newType);
        RelationType rtype = null;
        SetType stype = null;
        ScalarType sctype = null;
        if (newType.isRelation()) {
            rtype = (RelationType)newType;
        } else if (newType.isSet()) {
            stype = (SetType)newType;
        } else if (newType.isScalarType()) {
            sctype = (ScalarType)newType;
        }
        switch (this.op.symbol) {
            case 44: {
                if (this.child == null) break;
                this.child.setDomain(rtype.range());
                this.child.setRange(rtype.domain());
                break;
            }
            case 45: 
            case 46: {
                if (this.child == null) break;
                this.child.setDomain(rtype.domain());
                this.child.setRange(rtype.range());
                break;
            }
            case 47: {
                if (this.child == null) break;
                this.child.setDomain(stype.elemType());
                break;
            }
            case 48: {
                if (this.child == null) break;
                this.child.setRange(stype.elemType());
                break;
            }
            case 60: 
            case 61: {
                if (this.child == null) break;
                this.child.setDomain(sctype);
                break;
            }
            case 73: {
                if (this.child == null) break;
                this.child.setRange(rtype.range());
                this.child.setDomain(rtype.domain());
                break;
            }
            default: {
                ErrorReporter.internalError(this.getLocation(), "Unexpected op in UnaryTerm.setType");
            }
        }
    }

    public void setDomain(ScalarType newType) throws TypeConflict {
        if (newType == null) {
            return;
        }
        super.setDomain(newType);
        switch (this.op.symbol) {
            case 44: {
                if (this.child == null) break;
                this.child.setRange(newType);
                break;
            }
            case 45: 
            case 46: {
                if (this.child == null) break;
                this.child.setDomain(newType);
                break;
            }
            case 73: {
                if (this.child == null) break;
                this.child.setDomain(newType);
                break;
            }
            default: {
                ErrorReporter.internalError(this.getLocation(), "Unexpected op in UnaryTerm.setDomain");
            }
        }
    }

    public void setRange(ScalarType newType) throws TypeConflict {
        if (newType == null) {
            return;
        }
        super.setRange(newType);
        switch (this.op.symbol) {
            case 44: {
                if (this.child == null) break;
                this.child.setDomain(newType);
                break;
            }
            case 45: 
            case 46: {
                if (this.child == null) break;
                this.child.setRange(newType);
                break;
            }
            case 73: {
                if (this.child == null) break;
                this.child.setRange(newType);
                break;
            }
            default: {
                ErrorReporter.internalError(this.getLocation(), "Unexpected op in UnaryTerm.setRange");
            }
        }
    }

    public void setElemType(ScalarType newType) throws TypeConflict {
        if (newType == null) {
            return;
        }
        super.setElemType(newType);
        switch (this.op.symbol) {
            case 47: {
                if (this.child == null) break;
                this.child.setDomain(newType);
                break;
            }
            case 48: {
                if (this.child == null) break;
                this.child.setRange(newType);
                break;
            }
            default: {
                ErrorReporter.internalError(this.getLocation(), "Unexpected op in UnaryTerm.setElemType");
            }
        }
    }

    public boolean equiv(Tree other) {
        if (other.getClass() != this.getClass()) {
            return false;
        }
        UnaryTerm otherUT = (UnaryTerm)other;
        if (otherUT.op != this.op) {
            return false;
        }
        return this.child.equiv(otherUT.child);
    }

    public TermIndex index() {
        return new TermIndex(this.op.symbol, this.getType().getTypeClass());
    }

    int equivHashCode(int hashSize) {
        if (this.eqHashCode < 0) {
            this.eqHashCode = (this.child.equivHashCode(hashSize) + this.op.symbol) % hashSize;
        }
        return this.eqHashCode;
    }

    /*
     * Unable to fully structure code
     */
    private void computeType() {
        ctype = null;
        crt = null;
        cst = null;
        if (this.child != null && (ctype = this.child.getType()) != null) {
            if (ctype.isRelation()) {
                crt = (RelationType)ctype;
            } else if (ctype.isSet()) {
                cst = (SetType)ctype;
            }
        }
        switch (this.op.symbol) {
            case 47: {
                if (ctype == null) {
                    try {
                        if (this.child != null) {
                            this.child.setType(new RelationType(null, null));
                        }
                    }
                    catch (TypeConflict tc) {
                        ErrorReporter.internalError(this.getLocation(), tc);
                    }
                    this.type = new SetType(null);
                    break;
                }
                if (crt == null) {
                    ErrorReporter.error(this.getLocation(), "The operand of dom is not a relation");
                    this.type = new SetType(null);
                }
                this.type = new SetType(crt.domain());
                break;
            }
            case 48: {
                if (ctype == null) {
                    try {
                        if (this.child != null) {
                            this.child.setType(new RelationType(null, null));
                        }
                    }
                    catch (TypeConflict tc) {
                        ErrorReporter.internalError(this.getLocation(), tc);
                    }
                    this.type = new SetType(null);
                    break;
                }
                if (crt == null) {
                    ErrorReporter.error(this.getLocation(), "The operand of ran is not a relation");
                    this.type = new SetType(null);
                }
                this.type = new SetType(crt.range());
                break;
            }
            case 73: {
                if (ctype == null) {
                    try {
                        if (this.child != null) {
                            this.child.setType(new RelationType(null, null));
                        }
                    }
                    catch (TypeConflict tc) {
                        ErrorReporter.internalError(this.getLocation(), tc);
                    }
                    reltype = new RelationType(null, null);
                    reltype.setFunction(true);
                    this.type = reltype;
                    break;
                }
                if (crt == null) {
                    ErrorReporter.error(this.getLocation(), "The operand of (func) is not a relation");
                    reltype = new RelationType(null, null);
                    reltype.setFunction(true);
                    this.type = reltype;
                }
                reltype = new RelationType(crt.domain(), crt.range());
                reltype.setFunction(true);
                if (crt.isInjection()) {
                    reltype.setInjection(true);
                }
                if (crt.isTotal()) {
                    reltype.setTotal(true);
                }
                if (crt.isOnto()) {
                    reltype.setOnto(true);
                }
                this.type = reltype;
                break;
            }
            case 45: 
            case 46: {
                if (ctype == null) {
                    try {
                        if (this.child != null) {
                            this.child.setType(new RelationType(null, null));
                        }
                    }
                    catch (TypeConflict tc) {
                        ErrorReporter.internalError(this.getLocation(), tc);
                    }
                    this.type = new RelationType(null, null);
                    break;
                }
                if (crt == null) {
                    ErrorReporter.error(this.getLocation(), "The operand of " + this.op.toString() + " is not a relation");
                    this.type = new SetType(null);
                }
                if (crt.domain() != null) ** GOTO lbl90
                try {
                    if (crt.range() != null) {
                        crt.setDomain(crt.range());
                    }
                    ** GOTO lbl101
                }
                catch (TypeConflict tc) {
                    ErrorReporter.internalError(this.getLocation(), tc);
                }
                ** GOTO lbl101
lbl90:
                // 1 sources

                if (crt.range() != null) ** GOTO lbl99
                try {
                    if (crt.range() != null) {
                        crt.setRange(crt.domain());
                    }
                    ** GOTO lbl101
                }
                catch (TypeConflict tc) {
                    ErrorReporter.internalError(this.getLocation(), tc);
                }
                ** GOTO lbl101
lbl99:
                // 1 sources

                if (!crt.domain().includes(crt.range())) {
                    ErrorReporter.error(this.getLocation(), "The domain and range disagree for " + this.op.toString());
                }
lbl101:
                // 9 sources

                reltype = new RelationType(crt.domain(), crt.range());
                if (this.op.symbol == 46) {
                    reltype.setTotal(true);
                    reltype.setOnto(true);
                } else {
                    if (crt.isTotal()) {
                        reltype.setTotal(true);
                    }
                    if (crt.isOnto()) {
                        reltype.setOnto(true);
                    }
                }
                this.type = reltype;
                break;
            }
            case 44: {
                if (ctype == null) {
                    try {
                        if (this.child != null) {
                            this.child.setType(new RelationType(null, null));
                        }
                    }
                    catch (TypeConflict tc) {
                        ErrorReporter.internalError(this.getLocation(), tc);
                    }
                    this.type = new RelationType(null, null);
                    break;
                }
                if (crt == null) {
                    ErrorReporter.error(this.getLocation(), "The operand of " + this.op.toString() + " is not a relation");
                    this.type = new SetType(null);
                }
                reltype = new RelationType(crt.range(), crt.domain());
                if (crt.isFunction()) {
                    reltype.setInjection(true);
                }
                if (crt.isInjection()) {
                    reltype.setFunction(true);
                }
                if (crt.isTotal()) {
                    reltype.setOnto(true);
                }
                if (crt.isOnto()) {
                    reltype.setTotal(true);
                }
                this.type = reltype;
                break;
            }
            case 65: {
                if (ctype == null) {
                    this.type = new IntType(0, 0x7FFFFFFF);
                    break;
                }
                if (cst != null) {
                    this.type = new IntType(cst.elemType());
                    break;
                }
                if (crt != null) {
                    this.type = crt.isFunction() ? new IntType(crt.domain()) : (crt.isInjection() ? new IntType(crt.range()) : new IntType(0, 0x7FFFFFFF));
                } else {
                    ErrorReporter.error(this.getLocation(), "Operand of " + this.op.toString() + " is not a set or a relation");
                }
            }
            case 60: 
            case 61: {
                if (ctype == null) break;
                if (crt != null) {
                    this.type = crt.domain();
                    if (crt.isChain()) break;
                    if (crt.isInjection() || crt.isOnto() || crt.domain() != null && !crt.domain().equiv(crt.range())) {
                        ErrorReporter.error(this.getLocation(), "Operand of " + this.op.toString() + " cannot be a chain()");
                        break;
                    }
                    ErrorReporter.warning(this.getLocation(), "Operand of " + this.op.toString() + " may not be a chain()");
                    break;
                }
                ErrorReporter.error(this.getLocation(), "Operand of " + this.op.toString() + " is not a chain or a relation");
            }
            default: {
                ErrorReporter.internalError(this.getLocation(), "Unexpected op in UnaryTerm.computeType");
            }
        }
    }

    public Type mergeTypes(Hashtable varTypes, Partitioning merges) {
        Type ctype = null;
        RelationType crt = null;
        SetType cst = null;
        if (this.child == null) {
            return null;
        }
        ctype = this.child.mergeTypes(varTypes, merges);
        if (ctype == null) {
            return null;
        }
        if (ctype.isRelation()) {
            crt = (RelationType)ctype;
        } else if (ctype.isSet()) {
            cst = (SetType)ctype;
        }
        switch (this.op.symbol) {
            case 47: {
                if (crt == null) {
                    return null;
                }
                return new SetType(crt.domain());
            }
            case 48: {
                if (crt == null) {
                    return null;
                }
                return new SetType(crt.range());
            }
            case 73: {
                if (crt == null) {
                    return null;
                }
                return crt;
            }
            case 45: 
            case 46: {
                if (crt == null) {
                    return null;
                }
                if (crt.domain() != null && crt.range() != null) {
                    merges.join(crt.domain(), crt.range());
                }
                return crt;
            }
            case 44: {
                if (crt == null) {
                    return null;
                }
                return new RelationType(crt.range(), crt.domain());
            }
            case 65: {
                return new IntType(0, Integer.MAX_VALUE);
            }
            case 60: 
            case 61: {
                if (crt == null) {
                    return null;
                }
                return crt.domain();
            }
        }
        ErrorReporter.internalError(this.getLocation(), "Unexpected op in UnaryTerm.mergeTypes");
        return null;
    }

    public double estCard(Scope scope) {
        if (this._estCard < 0.0) {
            switch (this.op.symbol) {
                case 47: {
                    this._estCard = this.child.estDomCard(scope);
                    break;
                }
                case 48: {
                    this._estCard = this.child.estRanCard(scope);
                    break;
                }
                case 46: {
                    RelationType rtype = (RelationType)this.getType();
                    long size = rtype.domain().numValues(scope);
                    this._estCard = ((double)(2L * size * size) + this.child.estCard(scope)) / 3.0;
                    break;
                }
                case 45: {
                    RelationType rtype = (RelationType)this.getType();
                    long size = rtype.domain().numValues(scope);
                    this._estCard = ((double)(size * size) + this.child.estCard(scope)) / 2.0;
                    break;
                }
                case 44: {
                    this._estCard = this.child.estCard(scope);
                    break;
                }
                case 73: {
                    this._estCard = this.child.estDomCard(scope);
                    break;
                }
                default: {
                    this._estCard = 1.0;
                }
            }
        }
        return this._estCard;
    }

    public double estDomCard(Scope scope) {
        if (this._estDomCard < 0.0) {
            switch (this.op.symbol) {
                case 46: {
                    RelationType rtype = (RelationType)this.getType();
                    this._estDomCard = rtype.domain().numValues(scope);
                    break;
                }
                case 45: {
                    this._estDomCard = this.child.estDomCard(scope);
                    break;
                }
                case 44: {
                    this._estDomCard = this.child.estRanCard(scope);
                    break;
                }
                case 73: {
                    this._estDomCard = this.child.estDomCard(scope);
                    break;
                }
                default: {
                    this._estDomCard = 0.0;
                }
            }
        }
        return this._estDomCard;
    }

    public double estRanCard(Scope scope) {
        if (this._estRanCard < 0.0) {
            switch (this.op.symbol) {
                case 46: {
                    RelationType rtype = (RelationType)this.getType();
                    this._estRanCard = rtype.domain().numValues(scope);
                    break;
                }
                case 45: {
                    this._estRanCard = this.child.estRanCard(scope);
                    break;
                }
                case 44: {
                    this._estRanCard = this.child.estDomCard(scope);
                    break;
                }
                case 73: {
                    this._estRanCard = this.child.estRanCard(scope);
                    break;
                }
                default: {
                    this._estRanCard = 0.0;
                }
            }
        }
        return this._estRanCard;
    }

    public void clearEstimates() {
        this.child.clearEstimates();
        super.clearEstimates();
    }
}

