/*
 * Decompiled with CFR 0.152.
 */
package ladybug.parse;

import ladybug.parse.ArgMismatch;
import ladybug.parse.ErrorReporter;
import ladybug.parse.Formula;
import ladybug.parse.ParseError;
import ladybug.parse.Renaming;
import ladybug.parse.Schema;
import ladybug.parse.Term;
import ladybug.parse.TermEnumeration;
import ladybug.parse.TermList;
import ladybug.parse.TypeConflict;
import ladybug.parse.VarConflict;
import ladybug.parse.VarEnumeration;
import ladybug.parse.VarTerm;
import ladybug.parse.Variable;
import ladybug.parse.VariableList;

public class Transition
extends Schema {
    private VariableList _params = new VariableList();

    public Transition(String name, boolean isClaim) {
        super(name, isClaim);
    }

    public boolean isTransition() {
        return true;
    }

    public void defineParam(Variable v) throws TypeConflict, VarConflict {
        v.makeParam(this);
        this.defineVar(v);
        this._params.append(v);
    }

    public VarEnumeration params() {
        return this._params.elements();
    }

    public Formula instantiate(TermList args) throws ArgMismatch {
        Renaming renames = new Renaming();
        VarEnumeration pe = this._params.elements();
        TermEnumeration ae = args.elements();
        while (pe.hasMoreElements()) {
            Variable p = pe.nextVar();
            if (!ae.hasMoreElements()) {
                throw new ArgMismatch(p, null, this, "Missing argument for %3.%1");
            }
            Term a = ae.nextTerm();
            if (!p.getType().includes(a.getType())) {
                throw new ArgMismatch(p, a, this, "Argument %2 does not match type of %3.%1");
            }
            renames.put(p, a);
        }
        if (ae.hasMoreElements()) {
            throw new ArgMismatch(null, ae.nextTerm(), this, "Extra argument %2 for %3");
        }
        Formula f = this.formula();
        return f.rename(renames);
    }

    public Schema copy(String name) {
        Transition trans = new Transition(name, this.isClaim());
        Renaming r = trans.copyVars(this);
        trans.copyFormulae(this, r);
        return trans;
    }

    Renaming copyVars(Transition trans) {
        Renaming r = super.copyVars(trans);
        VarEnumeration ve = trans.params();
        while (ve.hasMoreElements()) {
            Variable p = ve.nextVar();
            try {
                Variable newP = this.findVar(p);
                if (newP == null) {
                    newP = p.copyForSchema(this);
                    this.defineParam(newP);
                }
                r.put(p, new VarTerm(newP));
            }
            catch (ParseError pe) {
                ErrorReporter.internalError(this.getLocation(), pe);
            }
        }
        return r;
    }

    protected String headerString() {
        String s = String.valueOf(this.getName()) + "(";
        boolean first = true;
        VarEnumeration e = this.vars();
        while (e.hasMoreElements()) {
            Variable v = e.nextVar();
            if (!v.isParam()) continue;
            if (first) {
                first = false;
            } else {
                s = String.valueOf(s) + ", ";
            }
            s = String.valueOf(s) + v.getName() + " : " + v.getType().toString();
        }
        return String.valueOf(s) + ")" + (this.isClaim() ? ":: " : " = ");
    }
}

