/*
 * Decompiled with CFR 0.152.
 */
package ladybug.parse;

import java.util.Enumeration;
import java.util.Vector;
import ladybug.parse.SimpleTermEnum;
import ladybug.parse.Term;
import ladybug.parse.TermEnumeration;

public final class TermList {
    private Term[] _terms = new Term[8];
    private int _numTerms = 0;
    private int _allocTerms = 8;
    private static final int initAllocSize = 8;
    private static final int maxAllocIncr = 64;
    private Vector _tags = new Vector();

    public TermList() {
    }

    public TermList(Term t) {
        this();
        this.addTerm(t);
    }

    public TermList(Term t, Object tag) {
        this();
        this.addTerm(t, tag);
    }

    public TermList copy() {
        TermList tl = new TermList();
        tl._terms = new Term[this._allocTerms];
        tl._allocTerms = this._allocTerms;
        int i = 0;
        while (i < this._numTerms) {
            tl._terms[i] = this._terms[i];
            ++i;
        }
        tl._numTerms = this._numTerms;
        tl._tags = (Vector)this._tags.clone();
        return tl;
    }

    public int size() {
        return this._numTerms;
    }

    public boolean isEmpty() {
        return this._numTerms == 0;
    }

    public TermList union(TermList other) {
        TermList tl = new TermList();
        tl._terms = new Term[this._allocTerms + other._allocTerms];
        tl._allocTerms = this._allocTerms + other._allocTerms;
        tl._numTerms = 0;
        int i = 0;
        while (i < this._numTerms) {
            tl.append(this._terms[i], this._tags.elementAt(i));
            ++i;
        }
        TermEnumeration e = other.elements();
        while (e.hasMoreElements()) {
            Term t = e.nextTerm();
            if (tl.containsEquiv(t)) continue;
            Object tg = other.tag(t);
            if (tg != null) {
                tl.append(t, tg);
                continue;
            }
            tl.append(t);
        }
        return tl;
    }

    public TermEnumeration elements() {
        return new SimpleTermEnum(this._terms, this._numTerms);
    }

    public Enumeration tags() {
        return this._tags.elements();
    }

    public void addTerm(Term t) {
        this.append(t, null);
    }

    public void append(Term t) {
        this.append(t, null);
    }

    public void addTerm(Term t, Object tag) {
        this.append(t, tag);
    }

    public void append(Term t, Object tag) {
        if (this._numTerms >= this._allocTerms) {
            Term[] old = this._terms;
            this._allocTerms = this._allocTerms >= 64 ? (this._allocTerms += 64) : (this._allocTerms += this._allocTerms);
            this._terms = new Term[this._allocTerms];
            int i = 0;
            while (i < this._numTerms) {
                this._terms[i] = old[i];
                ++i;
            }
        }
        this._terms[this._numTerms] = t;
        this._tags.insertElementAt(tag, this._numTerms);
        ++this._numTerms;
    }

    public Term first() {
        return this._terms[0];
    }

    public Term last() {
        if (this._numTerms == 0) {
            return null;
        }
        return this._terms[this._numTerms - 1];
    }

    public void removeTerm(Term t) {
        int i = this._numTerms - 1;
        while (i >= 0) {
            if (this._terms[i] == t) {
                this._tags.removeElementAt(i);
                --this._numTerms;
                while (i < this._numTerms) {
                    this._terms[i] = this._terms[i + 1];
                    ++i;
                }
                return;
            }
            --i;
        }
    }

    public void removeEquiv(Term t) {
        int i = this._numTerms - 1;
        while (i >= 0) {
            if (t.equiv(this._terms[i])) {
                this._tags.removeElementAt(i);
                --this._numTerms;
                while (i < this._numTerms) {
                    this._terms[i] = this._terms[i + 1];
                    ++i;
                }
                return;
            }
            --i;
        }
    }

    public boolean equiv(TermList tl) {
        if (this._numTerms != tl._numTerms) {
            return false;
        }
        int i = 0;
        while (i < this._numTerms) {
            if (!this._terms[i].equiv(tl._terms[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean contains(Term t) {
        int i = 0;
        while (i < this._numTerms) {
            if (t == this._terms[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean containsEquiv(Term t) {
        int i = 0;
        while (i < this._numTerms) {
            if (t.equiv(this._terms[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Object tag(Term t) {
        int i = 0;
        while (i < this._numTerms) {
            if (t == this._terms[i]) {
                return this._tags.elementAt(i);
            }
            ++i;
        }
        return null;
    }

    public Object tagEquiv(Term t) {
        int i = 0;
        while (i < this._numTerms) {
            if (t.equiv(this._terms[i])) {
                return this._tags.elementAt(i);
            }
            ++i;
        }
        return null;
    }
}

