/*
 * Decompiled with CFR 0.152.
 */
package ladybug.parse;

import ladybug.parse.ConstantTerm;
import ladybug.parse.EmptyTerm;
import ladybug.parse.IdTerm;
import ladybug.parse.RelDisplay;
import ladybug.parse.ScalarConstTerm;
import ladybug.parse.SetDisplay;
import ladybug.parse.UnivTerm;
import ladybug.parse.VarTerm;

public final class TermIndex {
    private int k;
    private static final int varKey = 0;
    private static final int displayKey = 5;
    private static final int emptyKey = 10;
    private static final int constantKey = 15;
    private static final int univKey = 20;
    private static final int idKey = 25;
    private static final int constKey = 30;
    private static final int base = 35;
    public static final int maxKey = 405;

    public TermIndex(int symvalue, int typeClass) {
        this.k = symvalue * 5 + typeClass + 35;
    }

    public TermIndex(VarTerm vt) {
        this.k = TermIndex.computeKeyValue(0, vt.getType().getTypeClass());
    }

    public static TermIndex createVarIndex(int typeClass) {
        return new TermIndex(TermIndex.computeKeyValue(0, typeClass));
    }

    public TermIndex(RelDisplay rd) {
        this.k = TermIndex.computeKeyValue(5, rd.getType().getTypeClass());
    }

    public static TermIndex createRelDispIndex(int typeClass) {
        return new TermIndex(TermIndex.computeKeyValue(5, typeClass));
    }

    public TermIndex(SetDisplay sd) {
        this.k = TermIndex.computeKeyValue(5, sd.getType().getTypeClass());
    }

    public static TermIndex createSetDispIndex(int typeClass) {
        return new TermIndex(TermIndex.computeKeyValue(5, typeClass));
    }

    public TermIndex(EmptyTerm et) {
        this.k = TermIndex.computeKeyValue(10, et.getType().getTypeClass());
    }

    public static TermIndex createEmptyIndex(int typeClass) {
        return new TermIndex(TermIndex.computeKeyValue(10, typeClass));
    }

    public TermIndex(ConstantTerm ct) {
        this.k = TermIndex.computeKeyValue(10, ct.getType().getTypeClass());
    }

    public static TermIndex createConstantIndex(int typeClass) {
        return new TermIndex(TermIndex.computeKeyValue(15, typeClass));
    }

    public TermIndex(UnivTerm ut) {
        this.k = TermIndex.computeKeyValue(20, ut.getType().getTypeClass());
    }

    public static TermIndex createUnivIndex(int typeClass) {
        return new TermIndex(TermIndex.computeKeyValue(20, typeClass));
    }

    public TermIndex(IdTerm it) {
        this.k = TermIndex.computeKeyValue(25, it.getType().getTypeClass());
    }

    public static TermIndex createIdIndex(int typeClass) {
        return new TermIndex(TermIndex.computeKeyValue(25, typeClass));
    }

    public TermIndex(ScalarConstTerm st) {
        this.k = TermIndex.computeKeyValue(30, st.getType().getTypeClass());
    }

    public static TermIndex createConstIndex(int typeClass) {
        return new TermIndex(TermIndex.computeKeyValue(30, typeClass));
    }

    public int key() {
        return this.k;
    }

    private TermIndex(int keyValue) {
        this.k = keyValue;
    }

    private static int computeKeyValue(int keyType, int typeClass) {
        return keyType + typeClass;
    }
}

